/*
 * Program XBLAST V2.3.5 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * March 8th 1997
 * started August 1993
 *
 * File: func.c
 * special functions for levels 
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdlib.h>

#define _FUNC_C

#include "const.h"
#include "include.h"
#include "mytypes.h"
#include "graphics.h"
#include "maze.h"
#include "bomb.h"
#include "main.h"
#include "func.h"
#include "data.h"
#include "util.h"
#include "player.h"

#if defined(XBLAST_SOUND)
#include "sound.h"
#endif

/* 
 * void functions 
 */
#ifdef __STDC__
void 
special_init_void (BMPlayer *player_stat)
#else
void 
special_init_void (player_stat)
     BMPlayer *player_stat;
#endif
{
}

#ifdef __STDC__
void 
special_game_void (void)
#else
void 
special_game_void ()
#endif
{
}

#ifdef __STDC__
void 
special_extra_void (BMPlayer *ps)
#else
void 
special_extra_void (ps)
     BMPlayer *ps;
#endif
{
}

#ifdef __STDC__
void 
special_key_void (BMPlayer *ps)
#else
void 
special_key_void (ps)
     BMPlayer *ps;
#endif
{
}


/* 
 * Invincible 
 */
#ifdef __STDC__
void 
special_extra_invincible (BMPlayer *ps)
#else
void 
special_extra_invincible (ps)
     BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_INVINC, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ps->illtime = 0;
  ps->illness = ps->health;
  ps->invincible += EXTRA_INVINCIBLE;
}



/* 
 * Kicking 
 */
#ifdef __STDC__
void 
special_extra_kick (BMPlayer *ps)
#else
void 
special_extra_kick (ps)
     BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_NEWKICK, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ps->kick = TRUE;
}



/* 
 * Remote Control 
 */
#ifdef __STDC__
void 
special_extra_RC (BMPlayer *ps)
#else
void 
special_extra_RC(ps)
     BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_NEWRC, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ps->remote_control = TRUE;
}

#ifdef __STDC__
void 
special_key_RC (BMPlayer *ps)
#else
void 
special_key_RC (ps)
     BMPlayer *ps;
#endif
{
  if (ps->remote_control > 0) {
    if (ignite_players_bombs(ps)) {
#if defined(XBLAST_SOUND)
      play_sound(SND_SHOOT, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
    }
  }
}


/* 
 * Teleport 
 */
#ifdef __STDC__
void 
special_extra_teleport (BMPlayer *ps)
#else
void 
special_extra_teleport (ps)
     BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_NEWTELE, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  if (ps->teleport == 0) {
    ps->teleport = 1;
  }
}

#ifdef __STDC__
void 
special_key_teleport (BMPlayer *ps)
#else
void 
special_key_teleport (ps)
     BMPlayer *ps;
#endif
{
  if (ps->teleport == 1) {
    ps->teleport = TELEPORT_TIME;
  }
}


/* 
 * Extra Ignite All 
 */
#ifdef __STDC__
void 
special_extra_ignite_all (BMPlayer *ps)
#else
void 
special_extra_ignite_all (ps)
     BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_BUTT, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ignite_all_bombs(ps);
}


/* 
 * Special bombs 
 */
#ifdef __STDC__
void 
special_init_special_bombs_30 (BMPlayer *player_stat)
#else
void 
special_init_special_bombs_30 (player_stat)
     BMPlayer *player_stat;
#endif
{
  int player;
  
  for (player = 0; player < 2*MAX_PLAYER; player ++) {
    player_stat[player].special_bombs = 30;
  }
}

#ifdef __STDC__
void 
special_init_special_bombs_12 (BMPlayer *player_stat)
#else
void 
special_init_special_bombs_12 (player_stat)
     BMPlayer *player_stat;
#endif
{
  int player;
  
  for (player = 0; player < 2*MAX_PLAYER; player ++) {
    player_stat[player].special_bombs = 12;
  }
}

#ifdef __STDC__
void 
special_key_special_bomb (BMPlayer *ps)
#else
void 
special_key_special_bomb (ps)
     BMPlayer *ps;
#endif
{
  drop_bomb(ps, BMTspecial);
}

#ifdef __STDC__
void 
special_extra_special_bomb (BMPlayer *ps)
#else
void 
special_extra_special_bomb (ps)
     BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_SPBOMB, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ps->special_bombs += 3;
}

/*
 * Junkie (Garth again)
 */

#ifdef __STDC__
void 
special_extra_junkie (BMPlayer *ps)
#else
void
special_extra_junkie(ps)
     BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_INJ, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ps->junkie = MAX_JUNKIE_TIME;
}

/* 
 * Air Pump (Garth Denley) 
 */
#ifdef __STDC__
void 
special_extra_air (BMPlayer *ps)
#else
void 
special_extra_air(ps)
     BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_NEWPUMP, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ps->air_button = TRUE;
}

#ifdef __STDC__
void 
special_key_air (BMPlayer *ps)
#else
void 
special_key_air (ps)
     BMPlayer *ps;
#endif
{
  if ((ps->air_button > 0) && (ps->lives > 0)) {
#if defined(XBLAST_SOUND)
    play_sound(SND_PUMP, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
    do_air(ps);
  }
}



/* 
 * Haunting 
 */
#ifdef __STDC__
void 
special_game_haunt (void)
#else
void 
special_game_haunt ()
#endif
{
  haunt_kick(35);
}

#ifdef __STDC__
void 
special_game_haunt_fast (void)
#else
void 
special_game_haunt_fast ()
#endif
{
  haunt_kick(10);
}



/* 
 * Nasty Walls (Garth Denley) 
 */

static int next_nasty;
static int gentle_nasty;
static int range_nasty;

#define NASTY_INC GAME_TIME/12

#ifdef __STDC__
void
init_wall_launch_generic (int gentle,
			  int range)
#else
void
init_wall_launch_generic (gentle,range)
     int gentle,range;
#endif
{
  next_nasty = NASTY_INC;
  gentle_nasty = gentle * GAME_TIME;
  range_nasty = range;
}

#ifdef __STDC__
void
special_init_nasty_walls (BMPlayer *player_stat)
#else
void
special_init_nasty_walls (player_stat)
     BMPlayer *player_stat;
#endif
{
  init_wall_launch_generic(1,1);
}

#ifdef __STDC__
void
special_init_nasty_walls_2 (BMPlayer *player_stat)
#else
void
special_init_nasty_walls_2 (player_stat)
     BMPlayer *player_stat;
#endif
{
  init_wall_launch_generic(4,3);
}

#ifdef __STDC__
void
special_game_nasty_walls (void)
#else
void
special_game_nasty_walls ()
#endif
{
  int x,y;
  int dir = GoStop;

  if (game_time >= next_nasty) {
    if (game_time >= next_nasty + NASTY_INC) {
      next_nasty += NASTY_INC*2;
    }
    if (random_number(gentle_nasty) < game_time) {
      x = random_number(MAZE_W-2) + 1;
      y = random_number(MAZE_H-2) + 1;
      
      switch (random_number(4)) {
      case 0:
	dir=GoUp;
	y=MAZE_H-2;
	break;
      case 1:
	dir=GoDown;
	y=1;
	break;
      case 2:
	dir=GoLeft;
	x=MAZE_W-2;
	break;
      case 3:
	dir=GoRight;
	x=1;
	break;
      }
      new_nasty_bomb(x, y, range_nasty, dir);
    }
  }
}

/*
 * poison extra
 */
#ifdef __STDC__
void
special_extra_poison (BMPlayer *ps)
#else
void
special_extra_poison (ps)
  BMPlayer *ps;
#endif
{
  if (! ps->invincible) {
    ps->dying = DEAD_TIME;
  }
}

/*
 * spinner extra (long stunned )
 */
#ifdef __STDC__
void 
special_extra_long_stunned (BMPlayer *ps)
#else
void 
special_extra_long_stunned (ps)
  BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_STUN, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ps->stunned = STUN_TIME*4;
}

/*
 * speed extra
 */
#ifdef __STDC__
void
special_extra_speed (BMPlayer *ps)
#else
void
special_extra_speed (ps)
  BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_FAST, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ps->illness = IllRun;
  ps->health  = IllRun;
  ps->illtime = 0;
}

/*
 * slow extra
 */
#ifdef __STDC__
void
special_extra_slow (BMPlayer *ps)
#else
void
special_extra_slow (ps)
  BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_SLOW, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ps->illness = IllSlow;
  ps->health  = IllSlow;
  ps->illtime = 0;
}

/*
 * mayhem extra
 */
#ifdef __STDC__
void
special_extra_mayhem (BMPlayer *ps)
#else
void
special_extra_mayhem (ps)
  BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_SLAY, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ps->kick = TRUE;
  ps->illness = IllRun;
  ps->health  = IllRun;
  ps->illtime = 0;
}

/*
 * holy grail extra
 */
#ifdef __STDC__
void
special_extra_holy_grail (BMPlayer *ps)
#else
void
special_extra_holy_grail (ps)
  BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_HOLY, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  ps->lives += kill_other_players(ps->team);
  if (ps->lives > 9) {
    ps->lives = 9;
  }
  ps->invincible = NEW_INVINCIBLE;
  ps->dying = DEAD_TIME;
}

/*
 * multiple extra 
 */
#ifdef __STDC__
void
special_extra_life (BMPlayer *ps)
#else
void
special_extra_life (ps)
  BMPlayer *ps;
#endif
{
#if defined(XBLAST_SOUND)
  play_sound(SND_LIFE, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
  if (ps->lives < 9) {
    ps->lives ++;
  }
}


/*
 * multiple extra 
 */
#ifdef __STDC__
void
special_extra_multiple (BMPlayer *ps)
#else
void
special_extra_multiple (ps)
  BMPlayer *ps;
#endif
{
  switch (random_number(11)) {
  case 0:
  case 1:
    special_extra_speed(ps);
    break;
  case 2:
  case 3:
    special_extra_poison(ps);
    break;
  case 4:
  case 5:
    special_extra_invincible(ps);
    break;
  case 6:
  case 7:
    special_extra_long_stunned(ps);
    break;
  case 8:
  case 9:
    special_extra_air(ps);
    break;
  case 10:
    special_extra_life(ps);
    break;
  }
}

#ifdef __STDC__
void
special_extra_cloak (BMPlayer *ps)
#else
void
special_extra_cloak (ps)
  BMPlayer *ps;
#endif
{
  if (ps->cloaking < 0) {
    ps->cloaking *= -1;
  }
  ps->cloaking += 2*EXTRA_INVINCIBLE;
#ifdef XBLAST_SOUND
  play_sound(SND_NEWCLOAK, ps->x / (PIXW / MAX_SOUND_POSITION));
#endif
}

#ifdef __STDC__
void
special_key_cloak (BMPlayer *ps)
#else
void
special_key_cloak (ps)
  BMPlayer *ps;
#endif
{
  ps->cloaking *= -1;
#ifdef XBLAST_SOUND
  if (ps->cloaking > 0) {
    play_sound(SND_DECLOAK, ps->x / (PIXW / MAX_SOUND_POSITION));
  } else if (ps->cloaking < 0) {
    play_sound(SND_ENCLOAK, ps->x / (PIXW / MAX_SOUND_POSITION));
  }
#endif
}

/*
 * pow extra (stun others)
 */
#ifdef __STDC__
void 
special_extra_stun_others (BMPlayer *ps)
#else
void 
special_extra_stun_other (ps)
  BMPlayer *ps;
#endif
{
  stun_other_players(ps->team, STUN_TIME*4);
}

/*
 * end of file func.c
 */

