#! /bin/sh
# A script to store configuration variables for Mosaic's external
# software packages
#
# In all cases configure will check the dir you supply for all libs and
# header files as well the lib and include subdirectories of that directory.
# So if you do things right and install everything in a place like 
# /usr/local/include and /usr/local/lib
# you can just enter /usr/local (the default) for every field.
#
# Where to find jpeg stuff
jpegdir=/xdev/mosaic/libjpeg/sco

# Where to find libz (don't need any headers)
zdir=/xdev/mosaic/libpng/sco

# Where to find png stuff
pngdir=/xdev/mosaic/libpng/sco

# Where to find wais stuff
waisdir=/xdev/mosaic/freeWAIS/sco

# Where to find hdf stuff
hdfdir=

# Use DTM? (yes or no)
with_dtm=no

echo ./configure --with-jpegdir=$jpegdir --with-zdir=${zdir} --with-pngdir=$pngdir --with-wais=$waisdir --with-hdfdir=$hdfdir --enable-dtm=$with_dtm $*
./configure --with-jpegdir=$jpegdir --with-zdir=${zdir} --with-pngdir=$pngdir --with-wais=$waisdir --with-hdfdir=$hdfdir --enable-dtm=$with_dtm $*
