#include <stdlib.h>
#include <stdio.h>

#include <qapp.h>
#include <qwidget.h>
//#include <qkeycode.h>
#include <qpainter.h>

#include <QwSpriteField.h>

#define IMG_BACKGROUND "sprite/bg.ppm"
#define WIDTH 500
#define HEIGHT 400
#define IMG_SPRITE_DATA "sprite/sprite%d.ppm"
#define IMG_SPRITE_MASK "sprite/sprite%d.pbm"
#define NR_ROTS 32
#define BOUNDS_ACTION Bounce

static bool showtext=TRUE;
static bool showlines=FALSE;
static bool btext=TRUE;
static bool dsprite=TRUE;
static bool showredraws=FALSE;
static int refresh_delay=15;

class MySpriteField : public QwImageSpriteField {
public:
    MySpriteField(const char* imagefile, int w, int h, int chunksize=16, int maxclusters=200) :
	QwImageSpriteField(imagefile,w,h,chunksize,maxclusters),
	textarea(50,50,w-2*50,h-2*50)
    {
    }

    virtual void resize(int width, int height)
    {
	textarea=QRect(50,50,width-2*50,height-2*50);
	QwImageSpriteField::resize(width,height);
    }

    virtual void drawForeground(QPainter& painter, const QRect& r)
    {
	if (showredraws) {
	    painter.setPen(blue);
	    painter.drawRect(r);
	}
	if (showlines) {
	    int x2=width()-1;
	    int y2=height()-1;
	    painter.setPen(red);
	    painter.drawLine(0,0,x2,y2);
	    painter.drawLine(0,y2,x2,0);
	    painter.setPen(green);
	    painter.drawLine(x2/2,0,x2,y2/2);
	    painter.drawLine(x2/2,y2,0,y2/2);
	    painter.drawLine(x2/2,y2,x2,y2/2);
	    painter.drawLine(x2/2,0,0,y2/2);
	}
	if (showtext) {
	    static const char* text=
	        "This is an example of the QwSpritefield class set.  "
	        "The cloudy image is drawn as the background, "
	        "and this text is drawn as the foreground.  "
	        "The bouncing things are sprites.\n"
	        "\nOptions:\n"
	        "  -notext    Disables this text (faster)\n"
	        "  -btext     Disable bouncing text\n"
	        "  -dsprite   Disable drawn sprite\n"
	        "  -bounce n  Gives n bouncers (default 3)\n"
	        "  -lines     Draws lines on foreground (default off)\n"
	        "  -redraws   Draws rectangles showing redraws (default off)\n"
	        "  -delay n   Changes redraw delay to n milliseconds (default 15)\n"
	        "  -sb    Turn on smooth-scrolling scrollbars";
	    textarea.moveBy(1,1);
	    painter.setFont(QFont("Courier",12));
	    painter.setPen(darkGray);
	    painter.drawText(textarea,AlignVCenter|WordBreak,text);
	    textarea.moveBy(-1,-1);
	    painter.setPen(yellow);
	    painter.drawText(textarea,AlignVCenter|WordBreak,text);
	}
    }

private:
    QRect textarea;
};

class Example : public QWidget {
public:
    Example(int nsprites, bool scrbars) :
	field(IMG_BACKGROUND,scrbars ? WIDTH*3 : WIDTH, scrbars ? HEIGHT*3 : HEIGHT),
	view(scrbars ? (QWidget*)new QwScrollingSpriteFieldView(&field,this)
	    : (QWidget*)new QwSpriteFieldView(&field,this)
	    ),
	sprite(new QwRealMobileSprite*[nsprites]),
	textsprite("QwTextSprite",QFont("Helvetica",18)),
	scrollbars(scrbars),
	count(nsprites)
    {
	textsprite.setColor(red);
	if (!btext) textsprite.hide();
	if (dsprite) {
	    QPixmap pm(63,63);

	    QPainter p;
	    p.begin(&pm);
	    for (int i=0; i<50; i++) {
	        p.setPen(QColor(random()%255,random()%255,random()%255));
	        p.drawLine(random()%62,random()%62,random()%62,random()%62);
	    }
	    p.setPen(white);
	    p.drawText(0,0,63,63,AlignCenter,"DRAWN\nSPRITE");
	    pm.setMask(pm.createHeuristicMask());
	    p.end();

	    QPoint hs(31,31);
	    QList<QPixmap> lpm; lpm.append(&pm);
	    QList<QPoint> lhs; lhs.append(&hs);
	    drawnsprite = new QwSprite( new QwSpritePixmapSequence(lpm,lhs) );
	} else {
	    drawnsprite = 0;
	}
	QwSpritePixmapSequence* images=new QwSpritePixmapSequence(
	    IMG_SPRITE_DATA, IMG_SPRITE_MASK, NR_ROTS);

	for (int i=0; i<count; i++) {
	    sprite[i]=new QwRealMobileSprite(images);
	    sprite[i]->setBoundsAction(QwRealMobileSprite::BOUNDS_ACTION);
	    sprite[i]->frame(random()%NR_ROTS);
	    sprite[i]->setVelocity( // broad distribution of speeds
	        (double)(random()%256)*(random()%256)/10000,
	        (double)(random()%256)*(random()%256)/10000);
	}

	resize(WIDTH,HEIGHT);

	// Since it is virtual, ours won't be called in the constructor
	resizeEvent(0);
	startTimer(refresh_delay);
    }

protected:
    void resizeEvent(QResizeEvent* event)
    {
	QWidget::resizeEvent(event);
	view->resize(width(),height());
	if (!scrollbars)
	    field.resize(width(),height());
	for (int i=0; i<count; i++) {
	    sprite[i]->adoptSpritefieldBounds();
	}
    }

    void timerEvent(QTimerEvent*)
    {
	int tx=0,ty=0;
	static int t=0; t++; // tick tick tick
	for (int i=0; i<count; i++) {
	    sprite[i]->forward(2.0);
	    if (((t+count)&3)==0) // Occasionally
	        sprite[i]->frame((sprite[i]->frame()+1)%NR_ROTS);
	    tx+=sprite[i]->x();
	    ty+=sprite[i]->y();
	}
	QString text;
	text.sprintf("QwTextSprite (%d,%d)",tx/count, ty/count);
	textsprite.setText(text);
	textsprite.moveTo(tx/count, ty/count);
	drawnsprite->moveTo(width()-tx/count, height()-ty/count);

	field.update();
    }

private:
    MySpriteField field;
    QWidget* view;
    QwRealMobileSprite** sprite;
    QwTextSprite textsprite;
    QwSprite *drawnsprite;
    bool scrollbars;
    int count;
};

main(int argc, char** argv)
{
    QApplication app(argc,argv);

    int bouncers=3;
    bool scrollbars=FALSE;

    for (int arg=1; arg<argc; arg++) {
	if (0==strcmp(argv[arg],"-bounce")) {
	    bouncers=atoi(argv[++arg]);
	} else if (0==strcmp(argv[arg],"-notext")) {
	    showtext=FALSE;
	} else if (0==strcmp(argv[arg],"-redraws")) {
	    showredraws=TRUE;
	} else if (0==strcmp(argv[arg],"-lines")) {
	    showlines=TRUE;
	} else if (0==strcmp(argv[arg],"-btext")) {
	    btext=FALSE;
	} else if (0==strcmp(argv[arg],"-dsprite")) {
	    dsprite=FALSE;
	} else if (0==strcmp(argv[arg],"-delay")) {
	    refresh_delay=atoi(argv[++arg]);
	} else if (0==strcmp(argv[arg],"-sb")) {
	    scrollbars=TRUE;
	}
    }

    Example example(bouncers,scrollbars);
    app.setMainWidget(&example);
    example.show();
    return app.exec();
}


