/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: tfio.h,v 35004.1 1995/04/30 01:05:54 hawkeye Exp $ */

#ifndef TFIO_H
#define TFIO_H

#ifdef HAVE_STDARG
# include <stdarg.h>
#else
# include <varargs.h>
#endif

/* TFILE types */
#define TF_NULL     0
#define TF_QUEUE    1
#define TF_FILE     2
#define TF_PIPE     3

/* Sprintf flags */
#define SP_APPEND   1

/* TF's analogue of stdio's FILE */
typedef struct TFILE {
    int type;
    char *name;
    union {
        struct Queue *queue;
        FILE *fp;
    } u;
    char buf[80];
    int off, len;
} TFILE;

struct Aline;		/* incomplete declaration */

extern TFILE *tfout;	/* ... stdout */
extern TFILE *tferr;	/* ... stderr */
extern int errno;

#define operror(str)  eprintf("%s: %s", str, strerror(errno))
#define oputs(str)    tfputs(str, tfout)
#define oputa(aline)  tfputa(aline, tfout)
#define tfputc(c, file) fputc((c), (file)->u.fp)
#define tfflush(file) fflush((file)->u.fp)           /* undefined for QUEUEs */

extern char   *FDECL(tfname,(CONST char *name, CONST char *macname));
extern char   *FDECL(expand_filename,(CONST char *str));
extern TFILE  *FDECL(tfopen,(CONST char *name, CONST char *mode));
extern int     FDECL(tfclose,(TFILE *file));
extern void    FDECL(tfputs,(CONST char *str, TFILE *file));
extern void    FDECL(tfputa,(struct Aline *aline, TFILE *file));
extern void    FDECL(vSprintf,(struct String *buf, int flags, CONST char *fmt, va_list ap));
extern void    VDECL(Sprintf,(struct String *buf, int flags, CONST char *fmt, ...));
extern void    VDECL(oprintf,(CONST char *fmt, ...));
extern void    VDECL(tfprintf,(TFILE *file, CONST char *fmt, ...));
extern void    VDECL(eprintf,(CONST char *fmt, ...));
extern char    NDECL(igetchar);
extern struct String *FDECL(tfgetS,(struct String *str, TFILE *file));

extern void    FDECL(flushout_queue,(struct Queue *queue));
 
#endif /* TFIO_H */
