The `since` value is missing in a stability attribute.

Erroneous code example:

```compile_fail,E0542
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[stable(feature = "_stable_fn")] // invalid
fn _stable_fn() {}

#[rustc_const_stable(feature = "_stable_const_fn")] // invalid
const fn _stable_const_fn() {}

#[stable(feature = "_deprecated_fn", since = "0.1.0")]
#[deprecated(
    note = "explanation for deprecation"
)] // invalid
fn _deprecated_fn() {}
```

To fix this issue, you need to provide the `since` field. Example:

```
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[stable(feature = "_stable_fn", since = "1.0.0")] // ok!
fn _stable_fn() {}

#[rustc_const_stable(feature = "_stable_const_fn", since = "1.0.0")] // ok!
const fn _stable_const_fn() {}

#[stable(feature = "_deprecated_fn", since = "0.1.0")]
#[deprecated(
    since = "1.0.0",
    note = "explanation for deprecation"
)] // ok!
fn _deprecated_fn() {}
```

See the [How Rust is Made and “Nightly Rust”][how-rust-made-nightly] appendix
of the Book and the [Stability attributes][stability-attributes] section of the
Rustc Dev Guide for more details.

[how-rust-made-nightly]: https://doc.rust-lang.org/book/appendix-07-nightly-rust.html
[stability-attributes]: https://rustc-dev-guide.rust-lang.org/stability.html
