#ifndef MD5_H
#define MD5_H

#ifdef	HAVE_GLIBC_MD5
struct md5_ctx {
    u_int32_t A;
    u_int32_t B;
    u_int32_t C;
    u_int32_t D;
    u_int32_t total[2];
    u_int32_t buflen;
    char buffer[128];
};

typedef	struct md5_ctx		MD5_CTX;
#define	MD5Init(ctx)		md5_init_ctx(ctx)
#define	MD5Update(ctx,buf,len)	md5_process_bytes(buf,len,ctx)
#define	MD5Final(buf,ctx)	md5_finish_ctx(ctx,buf)

#else	/* HAVE_GLIBC_MD5 */

#define	uint32	u_int32_t

struct MD5Context {
	uint32 buf[4];
	uint32 bits[2];
	unsigned char in[64];
};

void MD5Init(struct MD5Context *context);
void MD5Update(struct MD5Context *context, unsigned char const *buf,
	       unsigned len);
void MD5Final(unsigned char digest[16], struct MD5Context *context);
void MD5Transform(uint32 buf[4], uint32 const in[16]);

/*
 * This is needed to make RSAREF happy on some MS-DOS compilers.
 */
typedef struct MD5Context MD5_CTX;

#endif	/* HAVE_GLIBC_MD5 */

#endif /* !MD5_H */
