#include <stdio.h>
#include <math.h>
#include <termios.h>
#include <sys/ioctl.h>

#include "fppxp.h"

#include <support.h>
#include <xcio.h>
#include <ppxp.h>

static struct {
    unsigned int b;
    const char *name;
    int x;
} sioInfo[]={
    {TIOCM_DTR, "DTR", 0},
    {TIOCM_RTS, "RTS", 0},
    {TIOCM_CTS, "CTS", 0},
    {TIOCM_CD, "CD", 0},
    {TIOCM_RNG, "RNG", 0},
    {TIOCM_DSR, "DSR", 0}
};

#define	NUM_SIOINFO	sizeof(sioInfo)/sizeof(sioInfo[0])

#define	BPS_HEIGHT	30
#define	SIO_HEIGHT	25

static FL_OBJECT *monObjs[4];

#define	bpsObj		(monObjs[0])
#define	rangeObj	(monObjs[1])
#define	sioObj		(monObjs[1])

void
UpdateMonitorPanel(struct pppinfo_s *old, struct pppinfo_s *new)
{
    static unsigned int minfo;
    float rbps, sbps;

    if (new->phase < PS_ESTABLISH) return;
    if (new->s.lsize >= old->s.lsize) {
	rbps = (float)(new->r.lsize - old->r.lsize);
	sbps = (float)(new->s.lsize - old->s.lsize);
	fl_set_bchart_value(bpsObj, 1, sbps, rbps);

	rbps = (float)(new->r.nsize - old->r.nsize);
	sbps = (float)(new->s.nsize - old->s.nsize);
	fl_set_bchart_value(bpsObj, 0, sbps, rbps);

	fl_redraw_object(bpsObj);
    }
    if (new->minfo != minfo) {
	unsigned n;

	if (new->minfo == (u_int)-1) {
	    fl_set_object_lcol(sioObj, FL_MCOL);
	} else {
	    for (n = 0; n < NUM_SIOINFO; n ++) {
		fl_set_led_name(sioObj, n, sioInfo[n].name);
		fl_set_led(sioObj, n,
			   (new->minfo & sioInfo[n].b) ? FL_BLUE:
			   FL_MCOL);
	    }
	    fl_set_object_lcol(sioObj, FL_BLACK);
	    fl_redraw_object(sioObj);
	}
    }
}

void
ActivateMonitorPanel(int sw)
{
    int i;

    for (i = 0; monObjs[i] ; i ++) {
	if (sw) {
	    fl_activate_object(monObjs[i]);
	    fl_show_object(monObjs[i]);
	} else {
	    fl_deactivate_object(monObjs[i]);
	    fl_hide_object(monObjs[i]);
	}
    }
}

FL_OBJECT **
CreateMonitorPanel(int x, int y, int w, int h)
{
    FL_OBJECT *obj;
    unsigned int i, n=0, width;

    width = (w - (FRAME_GAP << 1));

    obj = fl_add_bchart(FL_NORMAL_BCHART, x + FRAME_GAP, y + FRAME_GAP,
			width, BPS_HEIGHT, "");
    fl_set_object_boxtype(obj, FL_FLAT_BOX);
/*    fl_set_bchart_max(obj, 2000.0);*/
    fl_set_bchart_max(obj, 0.0);
    fl_set_bchart_color(obj, 0, FL_SLATEBLUE, FL_INDIANRED);
    fl_set_bchart_color(obj, 1, FL_BLUE, FL_RED);
    fl_set_bchart_name(obj, "Send", "Receive");
    fl_set_bchart_style(obj, 0, LineSolid);
    fl_set_bchart_style(obj, 1, LineSolid);
/*    fl_set_bchart_scale(obj, FL_BCHART_MIDSCALE);*/
    fl_set_bchart_scale(obj, FL_BCHART_LOGSCALE);
    fl_set_bchart_max(obj, 20000.0);
    fl_set_object_lalign(obj, FL_ALIGN_BOTTOM|FL_ALIGN_CENTER);
    monObjs[n ++] = obj;

    y = y + h - FRAME_GAP - SIO_HEIGHT;
    obj = fl_add_leds(0, x + FRAME_GAP, y, width, SIO_HEIGHT, "");
    fl_set_object_boxtype(obj, FL_FLAT_BOX);
    fl_setup_leds(obj, NUM_SIOINFO, 6, 6);
    for (i = 0; i < NUM_SIOINFO; i ++) {
	fl_set_led_name(obj, i, sioInfo[i].name);
	fl_set_led(obj, i, FL_MCOL);
    }
    monObjs[n ++] = obj;
    return(monObjs);
}
