
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_utilities.h
**  Date:    June 3, 2002
**
**  Author:  Brian Wotring
**  Purpose: common operations.
**
******************************************************************************/

#ifndef MD_UTILITIES_H_
#define MD_UTILITIES_H_

/* helper methods for paths to various things. */

void osi_set_path_to_hosts( char *path, int path_size );
void osi_set_path_to_shared_configs( char *path, int path_size );

void osi_set_path_to_host( const char *host, char *path, int path_size );
void osi_set_path_to_host_config( const char *host, char *path, int path_size );

void osi_set_path_to_log( const char *host, const char *name,
                          char *path, int path_size );

void osi_set_path_to_database( const char *host, const char *name,
                               char *path, int path_size );

void osi_set_path_to_scan_config( const char *name,
                                  char *path, int path_size );

void osi_set_path_to_host_scan_config( const char *host, const char *name,
                                       char *path, int path_size );

void osi_set_path_to_configs( const char *host, char *path, int path_size );
void osi_set_path_to_databases( const char *host, char *path, int path_size );
void osi_set_path_to_logs( const char *host, char *path, int path_size );

/* random utilities. */

osi_bool perform_session_key_negotiation( SSL *ssl, OSI_HOST *host );

int osi_host_push_config( const char *host_name, const char *name );
int osi_host_push_base_db_config( const char *host_name );

#endif
