
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_filter.h
**  Date:    September 17, 2003
**
**  Author:  Brian Wotring
**  Purpose: handle comparison filter operations.
**
******************************************************************************/

#ifndef MD_FILTER_H_
#define MD_FILTER_H_

osi_bool md_filter_create_database( const char *filter_db_path );

osi_bool md_filter_open_database( OSI_DB *filter_db );
osi_bool md_filter_close_database( OSI_DB *filter_db );

void md_filter_changes( OSI_DB *filter_db, char *host,
                        unsigned int file_attr, char *path,
                        unsigned int *unfiltered_mask );

#endif
