/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: numhead.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/25 14:56:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svtools.hxx"
#ifndef GCC
#endif

#ifndef _DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif

#include "numhead.hxx"

//		ID's fuer Dateien:
#define SV_NUMID_SIZES						0x4200

// STATIC DATA -----------------------------------------------------------

//SEG_EOFGLOBALS()

// =======================================================================
/*								wird fuer SvNumberformatter nicht gebraucht
//#pragma SEG_FUNCDEF(numhead_01)

SvNumReadHeader::SvNumReadHeader(SvStream& rNewStream) :
	rStream( rNewStream )
{
	ULONG nDataSize;
	rStream >> nDataSize;
	nDataEnd = rStream.Tell() + nDataSize;
}

//#pragma SEG_FUNCDEF(numhead_02)

SvNumReadHeader::~SvNumReadHeader()
{
	ULONG nReadEnd = rStream.Tell();
	DBG_ASSERT( nReadEnd <= nDataEnd, "zuviele Bytes gelesen" );
	if ( nReadEnd != nDataEnd )
		rStream.Seek(nDataEnd); 					// Rest ueberspringen
}

//#pragma SEG_FUNCDEF(numhead_03)

ULONG SvNumReadHeader::BytesLeft() const
{
	ULONG nReadEnd = rStream.Tell();
	if (nReadEnd <= nDataEnd)
		return nDataEnd-nReadEnd;

	DBG_ERROR("Fehler bei SvNumReadHeader::BytesLeft");
	return 0;
}

// -----------------------------------------------------------------------

//#pragma SEG_FUNCDEF(numhead_04)

SvNumWriteHeader::SvNumWriteHeader(SvStream& rNewStream, ULONG nDefault) :
	rStream( rNewStream )
{
	nDataSize = nDefault;
	rStream << nDataSize;
	nDataPos = rStream.Tell();
}

//#pragma SEG_FUNCDEF(numhead_05)

SvNumWriteHeader::~SvNumWriteHeader()
{
	ULONG nPos = rStream.Tell();

	if ( nPos - nDataPos != nDataSize )				// Default getroffen?
	{
		nDataSize = nPos - nDataPos;
		rStream.Seek(nDataPos - sizeof(sal_uInt32));
		rStream << nDataSize;						// Groesse am Anfang eintragen
		rStream.Seek(nPos);
	}
}
*/

// =======================================================================

//#pragma SEG_FUNCDEF(numhead_06)

//! mit Skip() synchron
ImpSvNumMultipleReadHeader::ImpSvNumMultipleReadHeader(SvStream& rNewStream) :
	rStream( rNewStream )
{
	sal_uInt32 nDataSize;
	rStream >> nDataSize;
	ULONG nDataPos = rStream.Tell();
	nEntryEnd = nDataPos;

	rStream.SeekRel(nDataSize);
	USHORT nID;
	rStream >> nID;
	if (nID != SV_NUMID_SIZES)
	{
		DBG_ERROR("SV_NUMID_SIZES nicht gefunden");
	}
	sal_uInt32 nSizeTableLen;
	rStream >> nSizeTableLen;
	pBuf = new char[nSizeTableLen];
	rStream.Read( pBuf, nSizeTableLen );
	pMemStream = new SvMemoryStream( pBuf, nSizeTableLen, STREAM_READ );

	nEndPos = rStream.Tell();
	rStream.Seek( nDataPos );
}

//#pragma SEG_FUNCDEF(numhead_07)

ImpSvNumMultipleReadHeader::~ImpSvNumMultipleReadHeader()
{
	DBG_ASSERT( pMemStream->Tell() == pMemStream->GetSize(),
				"Sizes nicht vollstaendig gelesen" );
	delete pMemStream;
	delete [] pBuf;

	rStream.Seek(nEndPos);
}

//! mit ctor synchron
// static
void ImpSvNumMultipleReadHeader::Skip( SvStream& rStream )
{
	sal_uInt32 nDataSize;
	rStream >> nDataSize;
	rStream.SeekRel( nDataSize );
	USHORT nID;
	rStream >> nID;
	if ( nID != SV_NUMID_SIZES )
	{
		DBG_ERROR("SV_NUMID_SIZES nicht gefunden");
	}
	sal_uInt32 nSizeTableLen;
	rStream >> nSizeTableLen;
	rStream.SeekRel( nSizeTableLen );
}

//#pragma SEG_FUNCDEF(numhead_08)

void ImpSvNumMultipleReadHeader::EndEntry()
{
	ULONG nPos = rStream.Tell();
	DBG_ASSERT( nPos <= nEntryEnd, "zuviel gelesen" );
	if ( nPos != nEntryEnd )
		rStream.Seek( nEntryEnd );			// Rest ueberspringen
}

//#pragma SEG_FUNCDEF(numhead_0d)

void ImpSvNumMultipleReadHeader::StartEntry()
{
	ULONG nPos = rStream.Tell();
	sal_uInt32 nEntrySize;
	(*pMemStream) >> nEntrySize;

	nEntryEnd = nPos + nEntrySize;
}

//#pragma SEG_FUNCDEF(numhead_09)

ULONG ImpSvNumMultipleReadHeader::BytesLeft() const
{
	ULONG nReadEnd = rStream.Tell();
	if (nReadEnd <= nEntryEnd)
		return nEntryEnd-nReadEnd;

	DBG_ERROR("Fehler bei ImpSvNumMultipleReadHeader::BytesLeft");
	return 0;
}

// -----------------------------------------------------------------------

//#pragma SEG_FUNCDEF(numhead_0a)

ImpSvNumMultipleWriteHeader::ImpSvNumMultipleWriteHeader(SvStream& rNewStream,
												   ULONG nDefault) :
	rStream( rNewStream ),
	aMemStream( 4096, 4096 )
{
	nDataSize = nDefault;
	rStream << nDataSize;

	nDataPos = rStream.Tell();
	nEntryStart = nDataPos;
}

//#pragma SEG_FUNCDEF(numhead_0b)

ImpSvNumMultipleWriteHeader::~ImpSvNumMultipleWriteHeader()
{
	ULONG nDataEnd = rStream.Tell();

	rStream << (USHORT) SV_NUMID_SIZES;
	rStream << static_cast<sal_uInt32>(aMemStream.Tell());
	rStream.Write( aMemStream.GetData(), aMemStream.Tell() );

	if ( nDataEnd - nDataPos != nDataSize )					// Default getroffen?
	{
		nDataSize = nDataEnd - nDataPos;
		ULONG nPos = rStream.Tell();
		rStream.Seek(nDataPos-sizeof(sal_uInt32));
		rStream << nDataSize;								// Groesse am Anfang eintragen
		rStream.Seek(nPos);
	}
}

//#pragma SEG_FUNCDEF(numhead_0c)

void ImpSvNumMultipleWriteHeader::EndEntry()
{
	ULONG nPos = rStream.Tell();
	aMemStream << static_cast<sal_uInt32>(nPos - nEntryStart);
}

//#pragma SEG_FUNCDEF(numhead_0e)

void ImpSvNumMultipleWriteHeader::StartEntry()
{
	ULONG nPos = rStream.Tell();
	nEntryStart = nPos;
}

