/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: breakiterator_unicode.hxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: kz $ $Date: 2006/12/12 16:11:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _I18N_BREAKITERATOR_UNICODE_HXX_
#define _I18N_BREAKITERATOR_UNICODE_HXX_

#include <breakiteratorImpl.hxx>

#include "warnings_guard_unicode_brkiter.h"

namespace com { namespace sun { namespace star { namespace i18n {

#define LOAD_CHARACTER_BREAKITERATOR    0
#define LOAD_WORD_BREAKITERATOR         1
#define LOAD_SENTENCE_BREAKITERATOR     2
#define LOAD_LINE_BREAKITERATOR         3

//	----------------------------------------------------
//	class BreakIterator_Unicode
//	----------------------------------------------------
class BreakIterator_Unicode : public BreakIteratorImpl
{
public:
	BreakIterator_Unicode();
	~BreakIterator_Unicode();

	virtual sal_Int32 SAL_CALL previousCharacters( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale, sal_Int16 nCharacterIteratorMode, sal_Int32 nCount, 
		sal_Int32& nDone ) throw(com::sun::star::uno::RuntimeException);
	virtual sal_Int32 SAL_CALL nextCharacters( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& rLocale, sal_Int16 nCharacterIteratorMode, sal_Int32 nCount, 
		sal_Int32& nDone ) throw(com::sun::star::uno::RuntimeException);

	virtual Boundary SAL_CALL previousWord( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale, sal_Int16 WordType) throw(com::sun::star::uno::RuntimeException);
	virtual Boundary SAL_CALL nextWord( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale, sal_Int16 WordType) throw(com::sun::star::uno::RuntimeException);
	virtual Boundary SAL_CALL getWordBoundary( const rtl::OUString& Text, sal_Int32 nPos, 
		const com::sun::star::lang::Locale& nLocale, sal_Int16 WordType, sal_Bool bDirection ) 
		throw(com::sun::star::uno::RuntimeException);

	virtual sal_Int32 SAL_CALL beginOfSentence( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale ) throw(com::sun::star::uno::RuntimeException);
	virtual sal_Int32 SAL_CALL endOfSentence( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale ) throw(com::sun::star::uno::RuntimeException);

	virtual LineBreakResults SAL_CALL getLineBreak( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale, sal_Int32 nMinBreakPos, 
		const LineBreakHyphenationOptions& hOptions, const LineBreakUserOptions& bOptions ) 
		throw(com::sun::star::uno::RuntimeException);

	//XServiceInfo
	virtual rtl::OUString SAL_CALL getImplementationName() throw( com::sun::star::uno::RuntimeException );
	virtual sal_Bool SAL_CALL supportsService(const rtl::OUString& ServiceName) 
		throw( com::sun::star::uno::RuntimeException );
	virtual com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL getSupportedServiceNames() 
		throw( com::sun::star::uno::RuntimeException );

protected:
	const sal_Char *cBreakIterator, *wordRule, *lineRule;
	Boundary result; // for word break iterator

    struct {
        UnicodeString aICUText;
        icu::BreakIterator *aBreakIterator;
    } character, word, sentence, line, *icuBI; 
    com::sun::star::lang::Locale aLocale;
    sal_Int16 aBreakType, aWordType;
    void SAL_CALL loadICUBreakIterator(const com::sun::star::lang::Locale& rLocale, 
        sal_Int16 rBreakType, sal_Int16 rWordType, const sal_Char* name, const rtl::OUString& rText) throw(com::sun::star::uno::RuntimeException);
};

} } } } 

#endif
