/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mediatypedetectionhelper.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 14:10:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_framework.hxx"

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_SERVICES_MEDIATYPEDETECTIONHELPER_HXX_
#include <services/mediatypedetectionhelper.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

#ifndef _INETTYPE_HXX
#include <svtools/inettype.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework
{

using namespace ::com::sun::star		;
using namespace ::rtl					;

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
MediaTypeDetectionHelper::MediaTypeDetectionHelper( const uno::Reference< lang::XMultiServiceFactory >& xFactory )
	: m_xFactory( xFactory )
{
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
MediaTypeDetectionHelper::~MediaTypeDetectionHelper()
{
}

//*****************************************************************************************************************
//	XInterface, XTypeProvider, XServiceInfo
//*****************************************************************************************************************

DEFINE_XINTERFACE_3					(	MediaTypeDetectionHelper
										, OWeakObject
										, DIRECT_INTERFACE( lang::XTypeProvider )
										, DIRECT_INTERFACE( lang::XServiceInfo  )
										, DIRECT_INTERFACE( util::XStringMapping )
									)

DEFINE_XTYPEPROVIDER_3				(	MediaTypeDetectionHelper
										, lang::XTypeProvider
										, lang::XServiceInfo
										, util::XStringMapping
									)

DEFINE_XSERVICEINFO_ONEINSTANCESERVICE	(	MediaTypeDetectionHelper
                                        , ::cppu::OWeakObject
										, SERVICENAME_MEDIATYPEDETECTIONHELPER
										, IMPLEMENTATIONNAME_MEDIATYPEDETECTIONHELPER
									)

DEFINE_INIT_SERVICE                 (   MediaTypeDetectionHelper,
                                        {
                                        }
                                    )

//*****************************************************************************************************************
//	 XStringMapping
//*****************************************************************************************************************

//virtual
sal_Bool SAL_CALL MediaTypeDetectionHelper::mapStrings(
		uno::Sequence< OUString >& rSeq )
		throw(uno::RuntimeException)
{
	sal_Bool bModified = sal_False;
	for( sal_Int32 i = rSeq.getLength(); i--; )
	{

		OUString& rUrl = rSeq[i];
		INetContentType eType = INetContentTypes::GetContentTypeFromURL( rUrl );

		UniString aType( INetContentTypes::GetContentType( eType ) );
		if( aType.Len() )
		{
			rUrl = aType;
			bModified = sal_True;
		}
	}
	return bModified;
}

}	// namespace framework

