/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: scmod.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: obo $ $Date: 2007/07/17 12:29:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_SCMOD_HXX
#define SC_SCMOD_HXX

#ifndef SC_SCDLL_HXX
#include "scdll.hxx"
#endif

#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif

#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif

#ifndef SC_SCGLOB_HXX
#include "global.hxx"		// ScInputMode
#endif

#ifndef SC_MARKDATA_HXX     //@05.01.98
#include "markdata.hxx"		//ScMarkData
#endif

#ifndef SC_SHELLIDS_HXX
#include "shellids.hxx"
#endif
namespace svtools { class ColorConfig; }
class KeyEvent;
class SfxErrorHandler;
class SvtAccessibilityOptions;
class SvtCTLOptions;
namespace binfilter {

class SdrModel;
class SdrView;
class EditView;
class SvxErrorHandler;

//STRIP008 namespace svtools { class ColorConfig; }

class ScRange;
class ScDocument;
class ScViewCfg;
class ScDocCfg;
class ScAppCfg;
class ScInputCfg;
class ScPrintCfg;
class ScViewOptions;
class ScDocOptions;
class ScAppOptions;
class ScInputOptions;
class ScPrintOptions;
class ScInputHandler;
class ScInputWindow;
class ScTabViewShell;
class ScFunctionDlg;
class ScArgDlgBase;
class ScTeamDlg;
class ScEditFunctionDlg;
class ScMessagePool;
class EditFieldInfo;
class ScNavipiCfg;
class ScFormEditData;
class ScTransferObj;
class ScDrawTransferObj;

//==================================================================

//		for internal Drag&Drop:

#define SC_DROP_NAVIGATOR		1
#define SC_DROP_TABLE			2

struct ScDragData
{
	ScTransferObj*		pCellTransfer;
	ScDrawTransferObj*	pDrawTransfer;

	String				aLinkDoc;
	String				aLinkTable;
	String				aLinkArea;
	ScDocument*			pJumpLocalDoc;
	String				aJumpTarget;
	String				aJumpText;
};

struct ScClipData
{
	ScTransferObj*		pCellClipboard;
	ScDrawTransferObj*	pDrawClipboard;
};

//==================================================================


class ScModule: public ScModuleDummy, public SfxListener
{
	Timer				aIdleTimer;
	Timer				aSpellTimer;
	ScDragData			aDragData;
	ScClipData			aClipData;
	ScMessagePool*      pMessagePool;
	//	globalen InputHandler gibt's nicht mehr, jede View hat einen
	ScInputHandler*     pRefInputHandler;
	ScTeamDlg*			pTeamDlg;
	ScViewCfg*			pViewCfg;
	ScDocCfg*			pDocCfg;
	ScAppCfg*           pAppCfg;
	ScInputCfg*			pInputCfg;
	ScPrintCfg*			pPrintCfg;
	ScNavipiCfg*		pNavipiCfg;
    ::svtools::ColorConfig*   pColorConfig;
	SvtAccessibilityOptions* pAccessOptions;
	SvtCTLOptions*		pCTLOptions;
	SfxErrorHandler*	pErrorHdl;
	SvxErrorHandler* 	pSvxErrorHdl;
	ScFormEditData*		pFormEditData;
	USHORT				nCurRefDlgId;
	BOOL				bIsWaterCan;
	BOOL				bIsInEditCommand;

public:
					ScModule( SfxObjectFactory* pFact );
	virtual			~ScModule();

	virtual SfxModule*	Load();
	virtual void    	FillStatusBar(StatusBar &rBar);

	virtual void		Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

	void				DeleteCfg();

						// von der Applikation verschoben:

	DECL_LINK( IdleHandler,		Timer* );	// Timer statt idle
	DECL_LINK( SpellTimerHdl,	Timer* );
	DECL_LINK( CalcFieldValueHdl, EditFieldInfo* );

	void				AnythingChanged();

	//	Drag & Drop:
	const ScDragData&	GetDragData() const		{ return aDragData; }
	void				ResetDragObject();

	//	clipboard:
	const ScClipData&	GetClipData() const		{ return aClipData; }
	void				SetClipObject( ScTransferObj* pCellObj, ScDrawTransferObj* pDrawObj );

	ScDocument*			GetClipDoc();		// called from document - should be removed later

	void				SetWaterCan( BOOL bNew )	{ bIsWaterCan = bNew; }
	BOOL				GetIsWaterCan() const 		{ return bIsWaterCan; }

	void				SetInEditCommand( BOOL bNew )	{ bIsInEditCommand = bNew; }
	BOOL				IsInEditCommand() const 		{ return bIsInEditCommand; }

	// Options:
	const ScViewOptions&	GetViewOptions	();
	const ScDocOptions&		GetDocOptions	();
	const ScAppOptions&		GetAppOptions	();
	const ScInputOptions&	GetInputOptions	();
	const ScPrintOptions&	GetPrintOptions	();
	void					SetAppOptions	( const ScAppOptions& rOpt );
	void					SetInputOptions	( const ScInputOptions& rOpt );
	void					SetPrintOptions	( const ScPrintOptions& rOpt );
	void					RecentFunctionsChanged();

	static void			GetSpellSettings( USHORT& rDefLang, USHORT& rCjkLang, USHORT& rCtlLang,
										BOOL& rAutoSpell, BOOL& rHideAuto );

	USHORT				GetOptDigitLanguage();		// from CTL options

    ::svtools::ColorConfig&   GetColorConfig();
	SvtAccessibilityOptions& GetAccessOptions();
	SvtCTLOptions&		GetCTLOptions();


	//	InputHandler:
	void                InputEnterHandler( BYTE nBlockMode = 0 );
	ScInputHandler*		GetInputHdl( ScTabViewShell* pViewSh = NULL, BOOL bUseRef = TRUE );

	ScInputHandler*		GetRefInputHdl();

	void				ViewShellGone(ScTabViewShell* pViewSh);
	// Kommunikation mit Funktionsautopilot

	ScFormEditData*		GetFormEditData()		{ return pFormEditData; }

	//	Referenzeingabe:
	BOOL                IsFormulaMode();
	void				SetTeamDlg( ScTeamDlg* pDlg )			{ pTeamDlg = pDlg; }
	ScTeamDlg*			GetTeamDlg() const						{ return pTeamDlg; }
	USHORT				GetCurRefDlgId() const					{ return nCurRefDlgId; }

	//virtuelle Methoden fuer den Optionendialog
};

#define SC_MOD() ( *(ScModule**) GetAppData(BF_SHL_CALC) )

} //namespace binfilter
#endif


