/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: OOXMLSaxHandler.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2007/05/21 14:41:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef INCLUDED_OOXML_SAX_HANDLER_HXX
#define INCLUDED_OOXML_SAX_HANDLER_HXX

#ifndef _COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>	// helper for implementations
#endif

#include <doctok/WW8ResourceModel.hxx>
#include <ooxml/OOXMLDocument.hxx>
#include "OOXMLresources.hxx"

#include <vector>

namespace ooxml
{
using namespace ::std;
using namespace ::com::sun::star;
using namespace doctok;

class OOXMLSaxHandler :
        public ::cppu::WeakImplHelper1< xml::sax::XDocumentHandler>
{
private:
    Stream & mrStream;
    typedef vector<OOXMLContext::Pointer_t> OOXMLContextStack_t;
    OOXMLContextStack_t mContextStack;
    OOXMLDocument * mpDocument;
    rtl::OUString msXNoteId;

protected:
    static void handleNamespaceMappings
    (OOXMLContext::Pointer_t pContext,
     const uno::Reference<xml::sax::XAttributeList> & attriblist);

    static void handleAttributes
    (OOXMLContext::Pointer_t pContext,
     const uno::Reference<xml::sax::XAttributeList> & attriblist);

public:
    OOXMLSaxHandler(Stream & rStream, OOXMLDocument * pDocument); 
    virtual ~OOXMLSaxHandler();

    virtual void pushContext(OOXMLContext::Pointer_t pContext);
    virtual OOXMLContext::Pointer_t popContext();

    virtual void  SAL_CALL startDocument()
        throw (xml::sax::SAXException,uno::RuntimeException);

    virtual void  SAL_CALL endDocument()
        throw (xml::sax::SAXException,uno::RuntimeException);

    virtual void  SAL_CALL startElement
    (const rtl::OUString& str,
     const uno::Reference<xml::sax::XAttributeList>& attriblist)
        throw (xml::sax::SAXException,uno::RuntimeException);

    virtual void  SAL_CALL endElement(const rtl::OUString& str)
        throw (xml::sax::SAXException,uno::RuntimeException);

    virtual void  SAL_CALL characters(const rtl::OUString& str)
        throw (xml::sax::SAXException,uno::RuntimeException);

    virtual void  SAL_CALL ignorableWhitespace(const rtl::OUString& str)
        throw (xml::sax::SAXException,uno::RuntimeException);

    virtual void  SAL_CALL processingInstruction
    (const rtl::OUString& str,
     const rtl::OUString& str2)
        throw (xml::sax::SAXException,uno::RuntimeException) ;

    virtual void  SAL_CALL setDocumentLocator
    (const uno::Reference<xml::sax::XLocator>& doclocator)
        throw (xml::sax::SAXException,uno::RuntimeException) ;

    void setXNoteId(const rtl::OUString & rId);

    void dumpContextStack() const;
};

}
#endif // INCLUDED_OOXML_SAX_HANDLER_HXX
