/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: wrt_fn.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2007/09/27 09:56:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"

#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif


#include "shellio.hxx"
#include "wrt_fn.hxx"
#include "pam.hxx"
#include "node.hxx"
#include "format.hxx"



Writer& Out( const SwAttrFnTab pTab, const SfxPoolItem& rHt, Writer & rWrt )
{
	USHORT nId = rHt.Which();
	ASSERT(  nId < POOLATTR_END && nId >= POOLATTR_BEGIN, "SwAttrFnTab::Out()" );
	FnAttrOut pOut;
	if( 0 != ( pOut = pTab[ nId - RES_CHRATR_BEGIN] ))
		(*pOut)( rWrt, rHt );
	return rWrt;

}

Writer& Out_SfxItemSet( const SwAttrFnTab pTab, Writer& rWrt,
						const SfxItemSet& rSet, BOOL bDeep,
						BOOL bTstForDefault )
{
	// erst die eigenen Attribute ausgeben
	const SfxItemPool& rPool = *rSet.GetPool();
	const SfxItemSet* pSet = &rSet;
	if( !pSet->Count() )        // Optimierung - leere Sets
	{
		if( !bDeep )
			return rWrt;
		while( 0 != ( pSet = pSet->GetParent() ) && !pSet->Count() )
			;
		if( !pSet )
			return rWrt;
	}
	const SfxPoolItem* pItem;
	FnAttrOut pOut;
	if( !bDeep || !pSet->GetParent() )
	{
		ASSERT( rSet.Count(), "Wurde doch schon behandelt oder?" );
		SfxItemIter aIter( *pSet );
		pItem = aIter.GetCurItem();
		do {
			if( 0 != ( pOut = pTab[ pItem->Which() - RES_CHRATR_BEGIN] ))
					(*pOut)( rWrt, *pItem );
		} while( !aIter.IsAtEnd() && 0 != ( pItem = aIter.NextItem() ) );
	}
	else
	{
		SfxWhichIter aIter( *pSet );
		USHORT nWhich = aIter.FirstWhich();
		while( nWhich )
		{
			if( SFX_ITEM_SET == pSet->GetItemState( nWhich, bDeep, &pItem ) &&
				( !bTstForDefault || (
					*pItem != rPool.GetDefaultItem( nWhich )
					|| ( pSet->GetParent() &&
						*pItem != pSet->GetParent()->Get( nWhich ))
				)) && 0 != ( pOut = pTab[ nWhich - RES_CHRATR_BEGIN] ))
					(*pOut)( rWrt, *pItem );
			nWhich = aIter.NextWhich();
		}
	}
	return rWrt;
}



Writer& Out( const SwNodeFnTab pTab, SwNode& rNode, Writer & rWrt )
{
	// es muss ein CntntNode sein !!
	SwCntntNode * pCNd = rNode.GetCntntNode();
	if( !pCNd )
		return rWrt;

	USHORT nId = RES_TXTNODE;
	switch (pCNd->GetNodeType())
	{
		case ND_TEXTNODE:
			nId = RES_TXTNODE;
			 break;
		case ND_GRFNODE:
			nId = RES_GRFNODE;
			break;
		case ND_OLENODE:
			nId = RES_OLENODE;
			break;
		default:
			ASSERT(false, "was fuer ein Node ist es denn nun?");
			break;
	}
	FnNodeOut pOut;
	if( 0 != ( pOut = pTab[ nId - RES_NODE_BEGIN ] ))
		(*pOut)( rWrt, *pCNd );
	return rWrt;
}


