/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jsp;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Stack;
import java.util.Vector;
import org.gjt.jsp.Pos;

class StackedReader
extends Reader {
    Stack readers = new Stack();
    Stack includes = new Stack();
    Vector visitedIncludes = new Vector();
    LineNumberReader currentReader;
    String currentInclude;

    int getLineNumber() {
        return this.currentReader.getLineNumber();
    }

    Pos getPos() {
        return new Pos(this.getCurrentInclude().toString(), this.currentReader.getLineNumber() + 1);
    }

    public void pushReader(Reader reader, String string) {
        if (this.currentReader != null) {
            this.readers.push(this.currentReader);
            this.includes.push(this.currentInclude);
        }
        this.currentReader = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
        this.visitedIncludes.addElement(string);
        this.currentInclude = string;
    }

    private void pop() {
        this.currentReader = (LineNumberReader)this.readers.pop();
        this.currentInclude = (String)this.includes.pop();
    }

    public String getCurrentInclude() {
        return this.currentInclude;
    }

    public String[] getAllIncludes() {
        Object[] objectArray = new String[this.visitedIncludes.size()];
        this.visitedIncludes.copyInto(objectArray);
        return objectArray;
    }

    public final int read() throws IOException {
        if (this.currentReader == null) {
            return -1;
        }
        int n = this.currentReader.read();
        if (n == -1 && !this.readers.empty()) {
            this.currentReader.close();
            this.pop();
            return this.read();
        }
        return n;
    }

    public final int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public final int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.currentReader.read(cArray, n, n2);
        if (n3 == -1 && !this.readers.empty()) {
            this.currentReader.close();
            this.pop();
            return this.read(cArray, n, n2);
        }
        return n3;
    }

    public boolean ready() throws IOException {
        return this.currentReader.ready();
    }

    public void reset() throws IOException {
        this.currentReader.reset();
    }

    public void close() throws IOException {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
        if (!this.readers.empty()) {
            this.pop();
        }
    }

    public void mark(int n) throws IOException {
        this.currentReader.mark(n);
    }

    public boolean markSupported() {
        return this.currentReader.markSupported();
    }

    public long skip(long l) throws IOException {
        long l2 = this.currentReader.skip(l);
        if (l2 < l && !this.readers.empty()) {
            this.currentReader.close();
            this.pop();
            return this.currentReader.skip(l - l2);
        }
        return l2;
    }

    StackedReader(Reader reader, String string) {
        this.pushReader(reader, string);
    }
}

