/* GnomeMeeting -- A Video-Conferencing application
 * Copyright (C) 2000-2001 Damien Sandras
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *                         splash.h  -  description
 *                         -------------------------
 *   begin                : Mon Mar 19 2001
 *   copyright            : (C) 2000-2001 by Damien Sandras
 *   description          : This file contains functions to display the splash
 *                          screen at startup.
 *   email                : dsandras@seconix.com
 *
 */

#ifndef _SPLASH_H_
#define _SPLASH_H_


#include <glib.h>
#include <gnome.h>
#include <sys/time.h>


/* The functions */

/* DESCRIPTION  :  /
 * BEHAVIOR     :  Initialize the splash screen with the logo and return the
 *                 corresponding widget.
 * PRE          :  /
 */
GtkWidget *gnomemeeting_splash_init (void);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Set the splash window to gfloat % completed with 
 *                 the char *text.
 * PRE          :  1 <= gfloat <= 0, char * not empty, GtkWidget * not Null
 */
void gnomemeeting_splash_advance_progress (GtkWidget *, char *, gfloat);

#endif
