/* powerpc-linux.kernel.vmlinux.h
   created from powerpc-linux.kernel.vmlinux.bin, 9090 (0x2382) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2018 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2018 Laszlo Molnar
   Copyright (C) 2000-2018 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_POWERPC_LINUX_KERNEL_VMLINUX_SIZE    9090
#define STUB_POWERPC_LINUX_KERNEL_VMLINUX_ADLER32 0x07ef2789
#define STUB_POWERPC_LINUX_KERNEL_VMLINUX_CRC32   0x4e7e9b33

unsigned char stub_powerpc_linux_kernel_vmlinux[9090] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 20,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 25, 20,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0,  0,  0,  0, 72,  0,  0,  0, 72,  0,  0,  0,  0,  0,  0,  0,
/* 0x0040 */   0,  0,  0,  0, 40,  6,  0,208, 76,130,  0, 32, 84,132,240,191,
/* 0x0050 */  77,130,  0, 32, 60,  0,  0, 16,124,  4,  0, 64, 65,128,  0,  8,
/* 0x0060 */ 124,  4,  3,120, 56,165,  1, 32,124,103, 27,120, 56, 99,255,252,
/* 0x0070 */ 124,137,  3,166, 72,  0,  0, 28, 85, 96,  2,186,124,  3,  0, 80,
/* 0x0080 */ 124,  0, 58, 20, 80, 11,  1,186,145, 99,  0,  0, 78, 64,  0, 32,
/* 0x0090 */ 133, 99,  0,  4, 85, 96, 85,190,124,  0, 40, 64, 65,162,255,220,
/* 0x00a0 */  66,  0,255,240, 78,128,  0, 32,124,  0, 41,236,125,168,  2,166,
/* 0x00b0 */  40,  7,  0,  2, 64,130,  0,228,144,166,  0,  0,124,132, 26, 20,
/* 0x00c0 */  60,  0,128,  0, 61, 32,128,  0, 56, 99,255,255, 56,165,255,255,
/* 0x00d0 */  57, 64,255,255, 72,  0,  0,180,124,  9,  0, 64,125, 41, 72, 20,
/* 0x00e0 */  76,162,  0, 32, 57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4,
/* 0x00f0 */ 124,  9,  0, 64,125, 41, 73, 20, 78,128,  0, 32,141,  3,  0,  1,
/* 0x0100 */ 157,  5,  0,  1, 75,255,255,213, 65,129,255,244, 56,224,  0,  1,
/* 0x0110 */  75,255,255,201,124,231, 57, 21, 75,255,255,193, 65,160,255,244,
/* 0x0120 */  52,231,255,253, 57,  0,  0,  0, 65,128,  0, 20,141, 99,  0,  1,
/* 0x0130 */  84,231, 64, 46,124,234, 88,249, 65,130,  0,  0, 75,255,255,157,
/* 0x0140 */ 125,  8, 65, 21, 75,255,255,149,125,  8, 65, 21, 56,224,  0,  1,
/* 0x0150 */  64,130,  0, 28, 56,224,  0,  3, 57,  0,  0,  1, 75,255,255,125,
/* 0x0160 */ 125,  8, 65, 21, 75,255,255,117, 65,160,255,244, 33,106,242,255,
/* 0x0170 */ 125,  8, 57, 20,124,234, 42, 20,125,  9,  3,166,141,  7,  0,  1,
/* 0x0180 */ 157,  5,  0,  1, 66,  0,255,248, 56,224,  1,  0,124,  7, 41,236,
/* 0x0190 */ 124,  7, 26, 44, 75,255,255,112,124,  0, 41,236,125,168,  2,166,
/* 0x01a0 */  40,  7,  0,  5, 64,130,  1, 32,144,166,  0,  0,124,132, 26, 20,
/* 0x01b0 */  60,  0,128,  0, 61, 32,128,  0, 56, 99,255,255, 56,165,255,255,
/* 0x01c0 */  57, 64,255,255, 72,  0,  0,240, 57, 32,  0,  1,125, 41, 28, 44,
/* 0x01d0 */  56, 99,  0,  4,124,  9,  0, 64,125, 41, 72, 20, 97, 41,  0,  1,
/* 0x01e0 */  78,128,  0, 32,141,  3,  0,  1,157,  5,  0,  1,124,  9,  0, 64,
/* 0x01f0 */ 125, 41, 74, 20, 65,162,255,213, 65,129,255,236, 56,224,  0,  1,
/* 0x0200 */  72,  0,  0, 20, 56,231,255,255,125, 41, 72, 21, 65,162,255,189,
/* 0x0210 */ 124,231, 57, 21,125, 41, 72, 21, 65,162,255,177,124,231, 57, 21,
/* 0x0220 */ 124,  9,  0, 64,125, 41, 74, 20, 65,162,255,161, 65,160,255,216,
/* 0x0230 */  57,  0,  0,  0, 52,231,255,253, 84,231, 64, 46, 65,128,  0, 24,
/* 0x0240 */ 141, 99,  0,  1,124,234, 88,249,125, 74, 14,112, 65,130,  0,  0,
/* 0x0250 */  72,  0,  0, 12,125, 41, 72, 21, 65,162,255,113,125,  8, 65, 21,
/* 0x0260 */ 125, 41, 72, 21, 65,162,255,101,125,  8, 65, 21, 64,130,  0, 40,
/* 0x0270 */  57,  0,  0,  1,125, 41, 72, 21, 65,162,255, 81,125,  8, 65, 21,
/* 0x0280 */ 124,  9,  0, 64,125, 41, 74, 20, 65,162,255, 65, 65,160,255,232,
/* 0x0290 */  57,  8,  0,  2, 32,234,250,255, 57,  8,  0,  1,125,  8,  1,148,
/* 0x02a0 */ 124,234, 42, 20,125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1,
/* 0x02b0 */  66,  0,255,248, 56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44,
/* 0x02c0 */  75,255,255, 44,124,  0, 41,236,125,168,  2,166, 40,  7,  0,  8,
/* 0x02d0 */  64,130,  1, 60,144,166,  0,  0,124,132, 26, 20, 60,  0,128,  0,
/* 0x02e0 */  61, 32,128,  0, 56, 99,255,255, 56,165,255,255, 57, 64,255,255,
/* 0x02f0 */  72,  0,  1, 12, 57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4,
/* 0x0300 */ 124,  9,  0, 64,125, 41, 72, 20, 97, 41,  0,  1, 78,128,  0, 32,
/* 0x0310 */ 141,  3,  0,  1,157,  5,  0,  1,124,  9,  0, 64,125, 41, 74, 20,
/* 0x0320 */  65,162,255,213, 65,129,255,236, 56,224,  0,  1, 72,  0,  0, 20,
/* 0x0330 */  56,231,255,255,125, 41, 72, 21, 65,162,255,189,124,231, 57, 20,
/* 0x0340 */ 125, 41, 72, 21, 65,162,255,177,124,231, 57, 20,124,  9,  0, 64,
/* 0x0350 */ 125, 41, 74, 20, 65,162,255,161, 65,160,255,216, 57,  0,  0,  0,
/* 0x0360 */  52,231,255,253, 84,231, 64, 46, 65,128,  0, 32,141, 99,  0,  1,
/* 0x0370 */ 124,234, 88,249,125, 74, 14,112, 65,130,  0,  0,113,107,  0,  1,
/* 0x0380 */  65,162,  0, 80, 72,  0,  0, 20,124,  9,  0, 64,125, 41, 74, 20,
/* 0x0390 */  65,162,255,101, 65,161,  0, 60, 57,  0,  0,  1,124,  9,  0, 64,
/* 0x03a0 */ 125, 41, 74, 20, 65,162,255, 81, 65,161,  0, 40,125, 41, 72, 21,
/* 0x03b0 */  65,162,255, 69,125,  8, 65, 20,124,  9,  0, 64,125, 41, 74, 20,
/* 0x03c0 */  65,162,255, 53, 65,160,255,232, 57,  8,  0,  2, 72,  0,  0, 16,
/* 0x03d0 */ 125, 41, 72, 21, 65,162,255, 33,125,  8, 65, 20, 32,234,250,255,
/* 0x03e0 */  57,  8,  0,  2,125,  8,  1,148,124,234, 42, 20,125,  9,  3,166,
/* 0x03f0 */ 141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248, 56,224,  1,  0,
/* 0x0400 */ 124,  7, 41,236,124,  7, 26, 44, 75,255,255, 16,128,230,  0,  0,
/* 0x0410 */ 125,168,  3,166,124,100, 24, 80,124,135, 40, 80, 56, 99,  0,  1,
/* 0x0420 */  56,132,  0,  1,144,134,  0,  0, 96,231,  0, 31,124,  0, 56,108,
/* 0x0430 */ 124,  7, 40, 64,124,  0, 63,172, 56,231,  0, 32, 65,128,255,240,
/* 0x0440 */ 124,  0,  4,172, 76,  0,  1, 44, 78,128,  0, 32, 40,  7,  0, 14,
/* 0x0450 */  64,130,  0, 36,148, 33,255,232,124,  8,  2,166,124,201, 51,120,
/* 0x0460 */ 129,  6,  0,  0,124,167, 43,120, 56,164,255,254, 56,131,  0,  2,
/* 0x0470 */ 144,  1,  0,  8,136,  3,  0,  0, 84, 11,232,254, 84, 12,  7,126,
/* 0x0480 */  56, 96,250,  0,124, 99, 88, 48, 56, 99,241,124,124, 38, 11,120,
/* 0x0490 */ 124, 33, 26, 20, 84, 33,  0, 52, 56,  0,  0,  0,124,195, 51,120,
/* 0x04a0 */ 144,  9,  0,  0,148,  3,255,252,124,  1, 24, 64, 65,128,255,248,
/* 0x04b0 */ 144,193,  0,  0,136,  4,255,255,144,225,  0,  8, 56,193,  0, 16,
/* 0x04c0 */ 145, 33,  0, 12, 56, 97,  0, 20, 84, 11,225, 62, 84,  0,  7, 62,
/* 0x04d0 */ 153,131,  0,  2,153, 99,  0,  1,152,  3,  0,  0,124,  8,  2,166,
/* 0x04e0 */ 148, 33,255,160,189,193,  0, 24, 59, 32,  0,  0,125, 40,  3,166,
/* 0x04f0 */ 124,206, 51,120,124,147, 35,120,144,  1,  0,100,124,245, 59,120,
/* 0x0500 */ 125, 20, 67,120,137, 67,  0,  2, 59,  3,  0,  4, 59,224,  0,  0,
/* 0x0510 */ 137, 99,  0,  1, 58,224,  0,  0, 59, 64,  0,  1,138, 67,  0,  0,
/* 0x0520 */  58, 32,  0,  1, 58,  0,  0,  1,147, 38,  0,  0, 57,224,  0,  1,
/* 0x0530 */ 147, 41,  0,  0, 57, 32,  3,  0,136,  3,  0,  1,124, 18,  2, 20,
/* 0x0540 */ 125, 41,  0, 48, 56,  9,  7, 54, 57, 32,  0,  1,127,153,  0, 64,
/* 0x0550 */ 125, 43, 88, 48,125, 41, 80, 48, 57,107,255,255, 57, 41,255,255,
/* 0x0560 */ 145, 97,  0, 12,145, 33,  0,  8, 57, 32,  0,  0, 64,156,  0, 28,
/* 0x0570 */ 124,  9,  3,166, 57, 96,  4,  0, 85, 32,  8, 60, 57, 41,  0,  1,
/* 0x0580 */ 125,120,  3, 46, 66,  0,255,244,127,147, 42, 20,126,108,155,120,
/* 0x0590 */  56,160,  0,  0, 57,  0,255,255, 57, 96,  0,  0,127,140,224,  0,
/* 0x05a0 */  57,107,  0,  1, 47, 11,  0,  4, 84,169, 64, 46, 65,158,  8,156,
/* 0x05b0 */ 136, 12,  0,  0, 57,140,  0,  1,125, 37,  3,120, 64,153,255,224,
/* 0x05c0 */ 127,153,160, 64, 64,156,  8,100, 62,192,  0,255, 98,214,255,255,
/* 0x05d0 */ 127,136,176, 64,128,  1,  0,  8,127, 35,  0, 56, 86,224, 32, 54,
/* 0x05e0 */ 124,  0, 26, 20, 84,  6,  8, 60, 65,157,  0, 32,127,140,224,  0,
/* 0x05f0 */  65,158,  8, 88,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x0600 */  57,140,  0,  1,124,  5, 75,120,124,230,194, 46, 85,  0,170,254,
/* 0x0610 */ 125, 64, 57,214,127,133, 80, 64, 64,156,  1,172,128,  1,  0, 12,
/* 0x0620 */  47,151,  0,  6,125, 72, 83,120, 56, 96,  0,  1,127, 41,  0, 56,
/* 0x0630 */  32, 18,  0,  8,127,224,  6, 48,125, 41,144, 48,125, 41,  2, 20,
/* 0x0640 */  32,  7,  8,  0, 29, 41,  6,  0,124,  0, 46,112,124,  7,  2, 20,
/* 0x0650 */ 124,  6,195, 46,125, 56, 74, 20, 56,201, 14,108, 64,157,  0,180,
/* 0x0660 */ 124, 26,200, 80, 63, 96,  0,255,127,245,  0,174, 99,123,255,255,
/* 0x0670 */ 127,136,216, 64, 87,255,  8, 60, 87,253,  5,238, 84,100,  8, 60,
/* 0x0680 */  87,160,  8, 60,127, 12,224,  0,124,  6,  2, 20, 84,169, 64, 46,
/* 0x0690 */ 124,224, 34, 20, 65,157,  0, 24, 65,154,  7,176,136, 12,  0,  0,
/* 0x06a0 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,161,103,  2,  0,
/* 0x06b0 */  85,  0,170,254, 47, 29,  0,  0,124,131, 35,120,125, 64, 89,214,
/* 0x06c0 */  32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,124, 11,  2, 20,
/* 0x06d0 */ 125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 20,
/* 0x06e0 */ 176,  7,  2,  0,125, 72, 83,120, 65,186,  0, 24, 72,  0,  0, 28,
/* 0x06f0 */ 177,103,  2,  0,124,170, 40, 80, 56,100,  0,  1, 65,154,  0, 12,
/* 0x0700 */  47,131,  0,255, 64,157,255,108, 47,131,  0,255, 65,157,  0,132,
/* 0x0710 */  63,224,  0,255, 99,255,255,255,127,136,248, 64, 84,103,  8, 60,
/* 0x0720 */ 127, 12,224,  0, 84,169, 64, 46,124,227, 59,120, 65,157,  0, 24,
/* 0x0730 */  65,154,  7, 24,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0740 */ 125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x0750 */  32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,124, 11,  2, 20,
/* 0x0760 */ 125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,
/* 0x0770 */ 125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,
/* 0x0780 */ 125,102, 59, 46, 56,103,  0,  1, 47,131,  0,255, 64,157,255,140,
/* 0x0790 */  47,151,  0,  3, 84,127,  6, 62,127,249,169,174, 59, 57,  0,  1,
/* 0x07a0 */  65,157,  0, 12, 58,224,  0,  0, 72,  0,  6,120, 47,151,  0,  9,
/* 0x07b0 */  65,157,  0, 12, 58,247,255,253, 72,  0,  6,104, 58,247,255,250,
/* 0x07c0 */  72,  0,  6, 96,125, 10, 64, 80, 84,224,217,126,127,136,176, 64,
/* 0x07d0 */ 124,  0, 56, 80, 86,233,  8, 60,124,  6,195, 46,124,170, 40, 80,
/* 0x07e0 */ 124,248, 74, 20, 65,157,  0, 32,127,140,224,  0, 65,158,  6, 92,
/* 0x07f0 */ 137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0800 */ 124,  5, 75,120,161,103,  1,128, 85,  0,170,254,125, 64, 89,214,
/* 0x0810 */ 127,133, 80, 64, 64,156,  0, 64, 47,151,  0,  6, 32, 11,  8,  0,
/* 0x0820 */ 124,  0, 46,112,126, 15,131,120,124, 11,  2, 20,126, 48,139,120,
/* 0x0830 */ 176,  7,  1,128,125, 72, 83,120, 56,  0,  0,  0,127, 81,211,120,
/* 0x0840 */  64,157,  0,  8, 56,  0,  0,  3,124, 23,  3,120, 56,216,  6,100,
/* 0x0850 */  72,  0,  2, 24,125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,
/* 0x0860 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,128, 65,157,  0, 32,
/* 0x0870 */ 127,140,224,  0, 65,158,  5,212,137, 44,  0,  0, 84,160, 64, 46,
/* 0x0880 */  85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,161,103,  1,152,
/* 0x0890 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0,188,
/* 0x08a0 */ 127,138,176, 64, 32, 11,  8,  0,124,  0, 46,112, 86,233, 40, 52,
/* 0x08b0 */ 124, 11,  2, 20,125, 56, 74, 20, 84,107,  8, 60,176,  7,  1,152,
/* 0x08c0 */ 125, 72, 83,120,124,233, 90, 20, 65,157,  0, 32,127,140,224,  0,
/* 0x08d0 */  65,158,  5,120,137, 44,  0,  0, 84,160, 64, 46, 85, 72, 64, 46,
/* 0x08e0 */  57,140,  0,  1,124,  5, 75,120,161,103,  1,224, 85,  0,170,254,
/* 0x08f0 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 72, 47,153,  0,  0,
/* 0x0900 */  32, 11,  8,  0,124,  0, 46,112,125, 72, 83,120,124, 11,  2, 20,
/* 0x0910 */ 176,  7,  1,224, 65,158,  5, 52, 47,151,  0,  6, 57, 32,  0,  9,
/* 0x0920 */  64,157,  0,  8, 57, 32,  0, 11,124, 26,200, 80,125, 55, 75,120,
/* 0x0930 */ 127,245,  0,174,127,249,169,174, 59, 57,  0,  1, 72,  0,  4,228,
/* 0x0940 */  85, 96,217,126,124,170, 40, 80,124,  0, 88, 80,125, 10, 64, 80,
/* 0x0950 */ 176,  7,  1,224, 72,  0,  0,252,125, 10, 64, 80, 85, 96,217,126,
/* 0x0960 */ 127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,152,
/* 0x0970 */  65,157,  0, 32,127,140,224,  0, 65,158,  4,208,137, 44,  0,  0,
/* 0x0980 */  84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,
/* 0x0990 */ 161,103,  1,176, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x09a0 */  64,156,  0, 32, 32, 11,  8,  0,125, 72, 83,120,124,  0, 46,112,
/* 0x09b0 */ 126, 41,139,120,124, 11,  2, 20,176,  7,  1,176, 72,  0,  0,140,
/* 0x09c0 */ 125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,124,  0, 88, 80,
/* 0x09d0 */ 124,170, 40, 80,176,  7,  1,176, 65,157,  0, 32,127,140,224,  0,
/* 0x09e0 */  65,158,  4,104,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x09f0 */  57,140,  0,  1,124,  5, 75,120,161,103,  1,200, 85,  0,170,254,
/* 0x0a00 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,
/* 0x0a10 */ 125, 72, 83,120,124,  0, 46,112,126,  9,131,120,124, 11,  2, 20,
/* 0x0a20 */ 176,  7,  1,200, 72,  0,  0, 32, 85, 96,217,126,125,233,123,120,
/* 0x0a30 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,200,125, 10, 64, 80,
/* 0x0a40 */ 126, 15,131,120,126, 48,139,120,127, 81,211,120,125, 58, 75,120,
/* 0x0a50 */  47,151,  0,  6, 56,  0,  0,  8, 64,157,  0,  8, 56,  0,  0, 11,
/* 0x0a60 */ 124, 23,  3,120, 56,216, 10,104,127,136,176, 64, 65,157,  0, 32,
/* 0x0a70 */ 127,140,224,  0, 65,158,  3,212,137, 44,  0,  0, 84,160, 64, 46,
/* 0x0a80 */  85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,161,102,  0,  0,
/* 0x0a90 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48,
/* 0x0aa0 */  84,105, 32, 54, 32, 11,  8,  0,125, 38, 74, 20,124,  0, 46,112,
/* 0x0ab0 */ 124, 11,  2, 20,125, 72, 83,120, 56,137,  0,  4, 59, 96,  0,  0,
/* 0x0ac0 */ 176,  6,  0,  0, 56, 96,  0,  3, 72,  0,  0,156,125, 10, 64, 80,
/* 0x0ad0 */  85, 96,217,126,127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,
/* 0x0ae0 */ 176,  6,  0,  0, 65,157,  0, 32,127,140,224,  0, 65,158,  3, 92,
/* 0x0af0 */ 137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0b00 */ 124,  5, 75,120,161,102,  0,  2, 85,  0,170,254,125, 64, 89,214,
/* 0x0b10 */ 127,133, 80, 64, 64,156,  0, 48, 84,105, 32, 54, 32, 11,  8,  0,
/* 0x0b20 */ 125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,
/* 0x0b30 */  56,137,  1,  4, 59, 96,  0,  8,176,  6,  0,  2, 56, 96,  0,  3,
/* 0x0b40 */  72,  0,  0, 36, 85, 96,217,126,124,170, 40, 80,124,  0, 88, 80,
/* 0x0b50 */ 125, 10, 64, 80,176,  6,  0,  2, 56,134,  2,  4, 59, 96,  0, 16,
/* 0x0b60 */  56, 96,  0,  8, 63,224,  0,255,124,105,  3,166, 59,160,  0,  1,
/* 0x0b70 */  99,255,255,255,127,136,248, 64, 87,167,  8, 60,127, 12,224,  0,
/* 0x0b80 */  84,169, 64, 46,124,253, 59,120, 65,157,  0, 24, 65,154,  2,188,
/* 0x0b90 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x0ba0 */ 125,100, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x0bb0 */  85,105,217,126,124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,
/* 0x0bc0 */ 127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x0bd0 */ 124,  4, 59, 46, 72,  0,  0, 16,124,170, 40, 80, 59,167,  0,  1,
/* 0x0be0 */ 125,100, 59, 46, 66,  0,255,144, 47,151,  0,  3, 56,  0,  0,  1,
/* 0x0bf0 */ 124,  0, 24, 48,127,160,232, 80,127,189,218, 20, 65,157,  1,232,
/* 0x0c00 */  47,157,  0,  3, 58,247,  0,  7,127,169,235,120, 64,157,  0,  8,
/* 0x0c10 */  57, 32,  0,  3, 85, 41, 56, 48, 63,224,  0,255,125, 56, 74, 20,
/* 0x0c20 */  99,255,255,255, 56,201,  3, 96, 57, 32,  0,  6,125, 41,  3,166,
/* 0x0c30 */  56,128,  0,  1,127,136,248, 64, 84,135,  8, 60,127, 12,224,  0,
/* 0x0c40 */  84,169, 64, 46,124,228, 59,120, 65,157,  0, 24, 65,154,  1,252,
/* 0x0c50 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x0c60 */ 125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x0c70 */  85,105,217,126,124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,
/* 0x0c80 */ 127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x0c90 */ 124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80, 56,135,  0,  1,
/* 0x0ca0 */ 125,102, 59, 46, 66,  0,255,144, 56,132,255,192, 47,132,  0,  3,
/* 0x0cb0 */ 124,154, 35,120, 64,157,  1, 40, 47,132,  0, 13,124,137, 14,112,
/* 0x0cc0 */  84,128,  7,254, 57,105,255,255, 96, 26,  0,  2,125,105,  3,166,
/* 0x0cd0 */  65,157,  0, 32,127, 90, 88, 48, 84,128,  8, 60, 87, 73,  8, 60,
/* 0x0ce0 */ 125, 56, 74, 20,125, 32, 72, 80, 56,201,  5, 94, 72,  0,  0,100,
/* 0x0cf0 */  57, 41,255,251, 61, 96,  0,255,125, 41,  3,166, 97,107,255,255,
/* 0x0d00 */ 127,136, 88, 64,127, 12,224,  0, 84,169, 64, 46, 87, 90,  8, 60,
/* 0x0d10 */  65,157,  0, 24, 65,154,  1, 52,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x0d20 */  57,140,  0,  1,125, 37,  3,120, 85,  8,248,126,127,133, 64, 64,
/* 0x0d30 */  65,156,  0, 12,124,168, 40, 80, 99, 90,  0,  1, 66,  0,255,196,
/* 0x0d40 */  56,  0,  0,  4, 87, 90, 32, 54,124,  9,  3,166, 56,216,  6, 68,
/* 0x0d50 */  60, 96,  0,255, 56,128,  0,  1, 96, 99,255,255, 59,224,  0,  1,
/* 0x0d60 */ 127,136, 24, 64, 87,231,  8, 60,127, 12,224,  0, 84,169, 64, 46,
/* 0x0d70 */ 124,255, 59,120, 65,157,  0, 24, 65,154,  0,208,136, 12,  0,  0,
/* 0x0d80 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,
/* 0x0d90 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0, 85,105,217,126,
/* 0x0da0 */ 124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,127,133, 80, 64,
/* 0x0db0 */ 125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,
/* 0x0dc0 */  72,  0,  0, 20,124,170, 40, 80, 59,231,  0,  1,125,102, 59, 46,
/* 0x0dd0 */ 127, 90, 35,120, 84,132,  8, 60, 66,  0,255,136, 55, 90,  0,  1,
/* 0x0de0 */  65,130,  0, 72,127,154,200, 64, 59,189,  0,  2, 65,157,  0, 92,
/* 0x0df0 */ 124, 26,200, 80, 59,189,255,255,127,245,  0,174, 49,125,255,255,
/* 0x0e00 */ 125, 43,233, 16,127,249,169,174, 59, 57,  0,  1,124, 20,200, 16,
/* 0x0e10 */ 124,  0,  1, 16,124,  0,  0,208,125, 43,  0, 57, 64,130,255,212,
/* 0x0e20 */ 127,153,160, 64, 65,156,247,172, 60,  0,  0,255, 96,  0,255,255,
/* 0x0e30 */ 127,136,  0, 64, 65,157,  0, 32,127,140,224,  0, 56, 96,  0,  1,
/* 0x0e40 */  65,158,  0, 40, 72,  0,  0, 12, 56, 96,  0,  1, 72,  0,  0, 28,
/* 0x0e50 */  57,140,  0,  1,125, 40,  2,166,124, 19, 96, 80, 56, 96,  0,  0,
/* 0x0e60 */ 144, 14,  0,  0,147, 41,  0,  0,128,  1,  0,100,185,193,  0, 24,
/* 0x0e70 */  56, 33,  0, 96,124,  8,  3,166,124,  8,  2,166,148, 33,255,160,
/* 0x0e80 */ 189,193,  0, 24, 59, 32,  0,  0,125, 40,  3,166,124,206, 51,120,
/* 0x0e90 */ 124,147, 35,120,144,  1,  0,100,124,245, 59,120,125, 20, 67,120,
/* 0x0ea0 */ 137, 67,  0,  2, 59,  3,  0,  4, 59,224,  0,  0,137, 99,  0,  1,
/* 0x0eb0 */  58,224,  0,  0, 59, 64,  0,  1,138, 67,  0,  0, 58, 32,  0,  1,
/* 0x0ec0 */  58,  0,  0,  1,147, 38,  0,  0, 57,224,  0,  1,147, 41,  0,  0,
/* 0x0ed0 */  57, 32,  3,  0,136,  3,  0,  1,124, 18,  2, 20,125, 41,  0, 48,
/* 0x0ee0 */  56,  9,  7, 54, 57, 32,  0,  1,127,153,  0, 64,125, 43, 88, 48,
/* 0x0ef0 */ 125, 41, 80, 48, 57,107,255,255, 57, 41,255,255,145, 97,  0, 12,
/* 0x0f00 */ 145, 33,  0,  8, 57, 32,  0,  0, 64,156,  0, 28,124,  9,  3,166,
/* 0x0f10 */  57, 96,  4,  0, 85, 32,  8, 60, 57, 41,  0,  1,125,120,  3, 46,
/* 0x0f20 */  66,  0,255,244,127,147, 42, 20,126,108,155,120, 56,160,  0,  0,
/* 0x0f30 */  57,  0,255,255, 57, 96,  0,  0,127,140,224,  0, 57,107,  0,  1,
/* 0x0f40 */  47, 11,  0,  4, 84,169, 64, 46, 65,158,  8,156,136, 12,  0,  0,
/* 0x0f50 */  57,140,  0,  1,125, 37,  3,120, 64,153,255,224,127,153,160, 64,
/* 0x0f60 */  64,156,  8,100, 62,192,  0,255, 98,214,255,255,127,136,176, 64,
/* 0x0f70 */ 128,  1,  0,  8,127, 35,  0, 56, 86,224, 32, 54,124,  0, 26, 20,
/* 0x0f80 */  84,  6,  8, 60, 65,157,  0, 32,127,140,224,  0, 65,158,  8, 88,
/* 0x0f90 */ 137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0fa0 */ 124,  5, 75,120,124,230,194, 46, 85,  0,170,254,125, 64, 57,214,
/* 0x0fb0 */ 127,133, 80, 64, 64,156,  1,172,128,  1,  0, 12, 47,151,  0,  6,
/* 0x0fc0 */ 125, 72, 83,120, 56, 96,  0,  1,127, 41,  0, 56, 32, 18,  0,  8,
/* 0x0fd0 */ 127,224,  6, 48,125, 41,144, 48,125, 41,  2, 20, 32,  7,  8,  0,
/* 0x0fe0 */  29, 41,  6,  0,124,  0, 46,112,124,  7,  2, 20,124,  6,195, 46,
/* 0x0ff0 */ 125, 56, 74, 20, 56,201, 14,108, 64,157,  0,180,124, 26,200, 80,
/* 0x1000 */  63, 96,  0,255,127,245,  0,174, 99,123,255,255,127,136,216, 64,
/* 0x1010 */  87,255,  8, 60, 87,253,  5,238, 84,100,  8, 60, 87,160,  8, 60,
/* 0x1020 */ 127, 12,224,  0,124,  6,  2, 20, 84,169, 64, 46,124,224, 34, 20,
/* 0x1030 */  65,157,  0, 24, 65,154,  7,176,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x1040 */  57,140,  0,  1,125, 37,  3,120,161,103,  2,  0, 85,  0,170,254,
/* 0x1050 */  47, 29,  0,  0,124,131, 35,120,125, 64, 89,214, 32, 11,  8,  0,
/* 0x1060 */  85,105,217,126,124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,
/* 0x1070 */ 127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 20,176,  7,  2,  0,
/* 0x1080 */ 125, 72, 83,120, 65,186,  0, 24, 72,  0,  0, 28,177,103,  2,  0,
/* 0x1090 */ 124,170, 40, 80, 56,100,  0,  1, 65,154,  0, 12, 47,131,  0,255,
/* 0x10a0 */  64,157,255,108, 47,131,  0,255, 65,157,  0,132, 63,224,  0,255,
/* 0x10b0 */  99,255,255,255,127,136,248, 64, 84,103,  8, 60,127, 12,224,  0,
/* 0x10c0 */  84,169, 64, 46,124,227, 59,120, 65,157,  0, 24, 65,154,  7, 24,
/* 0x10d0 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x10e0 */ 125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x10f0 */  85,105,217,126,124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,
/* 0x1100 */ 127,133, 80, 64,125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x1110 */ 124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,125,102, 59, 46,
/* 0x1120 */  56,103,  0,  1, 47,131,  0,255, 64,157,255,140, 47,151,  0,  3,
/* 0x1130 */  84,127,  6, 62,127,249,169,174, 59, 57,  0,  1, 65,157,  0, 12,
/* 0x1140 */  58,224,  0,  0, 72,  0,  6,120, 47,151,  0,  9, 65,157,  0, 12,
/* 0x1150 */  58,247,255,253, 72,  0,  6,104, 58,247,255,250, 72,  0,  6, 96,
/* 0x1160 */ 125, 10, 64, 80, 84,224,217,126,127,136,176, 64,124,  0, 56, 80,
/* 0x1170 */  86,233,  8, 60,124,  6,195, 46,124,170, 40, 80,124,248, 74, 20,
/* 0x1180 */  65,157,  0, 32,127,140,224,  0, 65,158,  6, 92,137, 44,  0,  0,
/* 0x1190 */  84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,
/* 0x11a0 */ 161,103,  1,128, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x11b0 */  64,156,  0, 64, 47,151,  0,  6, 32, 11,  8,  0,124,  0, 46,112,
/* 0x11c0 */ 126, 15,131,120,124, 11,  2, 20,126, 48,139,120,176,  7,  1,128,
/* 0x11d0 */ 125, 72, 83,120, 56,  0,  0,  0,127, 81,211,120, 64,157,  0,  8,
/* 0x11e0 */  56,  0,  0,  3,124, 23,  3,120, 56,216,  6,100, 72,  0,  2, 24,
/* 0x11f0 */ 125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,124,  0, 88, 80,
/* 0x1200 */ 124,170, 40, 80,176,  7,  1,128, 65,157,  0, 32,127,140,224,  0,
/* 0x1210 */  65,158,  5,212,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x1220 */  57,140,  0,  1,124,  5, 75,120,161,103,  1,152, 85,  0,170,254,
/* 0x1230 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0,188,127,138,176, 64,
/* 0x1240 */  32, 11,  8,  0,124,  0, 46,112, 86,233, 40, 52,124, 11,  2, 20,
/* 0x1250 */ 125, 56, 74, 20, 84,107,  8, 60,176,  7,  1,152,125, 72, 83,120,
/* 0x1260 */ 124,233, 90, 20, 65,157,  0, 32,127,140,224,  0, 65,158,  5,120,
/* 0x1270 */ 137, 44,  0,  0, 84,160, 64, 46, 85, 72, 64, 46, 57,140,  0,  1,
/* 0x1280 */ 124,  5, 75,120,161,103,  1,224, 85,  0,170,254,125, 64, 89,214,
/* 0x1290 */ 127,133, 80, 64, 64,156,  0, 72, 47,153,  0,  0, 32, 11,  8,  0,
/* 0x12a0 */ 124,  0, 46,112,125, 72, 83,120,124, 11,  2, 20,176,  7,  1,224,
/* 0x12b0 */  65,158,  5, 52, 47,151,  0,  6, 57, 32,  0,  9, 64,157,  0,  8,
/* 0x12c0 */  57, 32,  0, 11,124, 26,200, 80,125, 55, 75,120,127,245,  0,174,
/* 0x12d0 */ 127,249,169,174, 59, 57,  0,  1, 72,  0,  4,228, 85, 96,217,126,
/* 0x12e0 */ 124,170, 40, 80,124,  0, 88, 80,125, 10, 64, 80,176,  7,  1,224,
/* 0x12f0 */  72,  0,  0,252,125, 10, 64, 80, 85, 96,217,126,127,136,176, 64,
/* 0x1300 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,152, 65,157,  0, 32,
/* 0x1310 */ 127,140,224,  0, 65,158,  4,208,137, 44,  0,  0, 84,160, 64, 46,
/* 0x1320 */  85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,161,103,  1,176,
/* 0x1330 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32,
/* 0x1340 */  32, 11,  8,  0,125, 72, 83,120,124,  0, 46,112,126, 41,139,120,
/* 0x1350 */ 124, 11,  2, 20,176,  7,  1,176, 72,  0,  0,140,125, 10, 64, 80,
/* 0x1360 */  85, 96,217,126,127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,
/* 0x1370 */ 176,  7,  1,176, 65,157,  0, 32,127,140,224,  0, 65,158,  4,104,
/* 0x1380 */ 137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x1390 */ 124,  5, 75,120,161,103,  1,200, 85,  0,170,254,125, 64, 89,214,
/* 0x13a0 */ 127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,125, 72, 83,120,
/* 0x13b0 */ 124,  0, 46,112,126,  9,131,120,124, 11,  2, 20,176,  7,  1,200,
/* 0x13c0 */  72,  0,  0, 32, 85, 96,217,126,125,233,123,120,124,  0, 88, 80,
/* 0x13d0 */ 124,170, 40, 80,176,  7,  1,200,125, 10, 64, 80,126, 15,131,120,
/* 0x13e0 */ 126, 48,139,120,127, 81,211,120,125, 58, 75,120, 47,151,  0,  6,
/* 0x13f0 */  56,  0,  0,  8, 64,157,  0,  8, 56,  0,  0, 11,124, 23,  3,120,
/* 0x1400 */  56,216, 10,104,127,136,176, 64, 65,157,  0, 32,127,140,224,  0,
/* 0x1410 */  65,158,  3,212,137, 44,  0,  0, 84,160, 64, 46, 85,  8, 64, 46,
/* 0x1420 */  57,140,  0,  1,124,  5, 75,120,161,102,  0,  0, 85,  0,170,254,
/* 0x1430 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48, 84,105, 32, 54,
/* 0x1440 */  32, 11,  8,  0,125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,
/* 0x1450 */ 125, 72, 83,120, 56,137,  0,  4, 59, 96,  0,  0,176,  6,  0,  0,
/* 0x1460 */  56, 96,  0,  3, 72,  0,  0,156,125, 10, 64, 80, 85, 96,217,126,
/* 0x1470 */ 127,136,176, 64,124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  0,
/* 0x1480 */  65,157,  0, 32,127,140,224,  0, 65,158,  3, 92,137, 44,  0,  0,
/* 0x1490 */  84,160, 64, 46, 85,  8, 64, 46, 57,140,  0,  1,124,  5, 75,120,
/* 0x14a0 */ 161,102,  0,  2, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x14b0 */  64,156,  0, 48, 84,105, 32, 54, 32, 11,  8,  0,125, 38, 74, 20,
/* 0x14c0 */ 124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120, 56,137,  1,  4,
/* 0x14d0 */  59, 96,  0,  8,176,  6,  0,  2, 56, 96,  0,  3, 72,  0,  0, 36,
/* 0x14e0 */  85, 96,217,126,124,170, 40, 80,124,  0, 88, 80,125, 10, 64, 80,
/* 0x14f0 */ 176,  6,  0,  2, 56,134,  2,  4, 59, 96,  0, 16, 56, 96,  0,  8,
/* 0x1500 */  63,224,  0,255,124,105,  3,166, 59,160,  0,  1, 99,255,255,255,
/* 0x1510 */ 127,136,248, 64, 87,167,  8, 60,127, 12,224,  0, 84,169, 64, 46,
/* 0x1520 */ 124,253, 59,120, 65,157,  0, 24, 65,154,  2,188,136, 12,  0,  0,
/* 0x1530 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,100, 58, 46,
/* 0x1540 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0, 85,105,217,126,
/* 0x1550 */ 124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,127,133, 80, 64,
/* 0x1560 */ 125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,124,  4, 59, 46,
/* 0x1570 */  72,  0,  0, 16,124,170, 40, 80, 59,167,  0,  1,125,100, 59, 46,
/* 0x1580 */  66,  0,255,144, 47,151,  0,  3, 56,  0,  0,  1,124,  0, 24, 48,
/* 0x1590 */ 127,160,232, 80,127,189,218, 20, 65,157,  1,232, 47,157,  0,  3,
/* 0x15a0 */  58,247,  0,  7,127,169,235,120, 64,157,  0,  8, 57, 32,  0,  3,
/* 0x15b0 */  85, 41, 56, 48, 63,224,  0,255,125, 56, 74, 20, 99,255,255,255,
/* 0x15c0 */  56,201,  3, 96, 57, 32,  0,  6,125, 41,  3,166, 56,128,  0,  1,
/* 0x15d0 */ 127,136,248, 64, 84,135,  8, 60,127, 12,224,  0, 84,169, 64, 46,
/* 0x15e0 */ 124,228, 59,120, 65,157,  0, 24, 65,154,  1,252,136, 12,  0,  0,
/* 0x15f0 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,
/* 0x1600 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0, 85,105,217,126,
/* 0x1610 */ 124,  0, 46,112,124, 11,  2, 20,125,105, 88, 80,127,133, 80, 64,
/* 0x1620 */ 125, 10, 64, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,
/* 0x1630 */  72,  0,  0, 16,124,170, 40, 80, 56,135,  0,  1,125,102, 59, 46,
/* 0x1640 */  66,  0,255,144, 56,132,255,192, 47,132,  0,  3,124,154, 35,120,
/* 0x1650 */  64,157,  1, 40, 47,132,  0, 13,124,137, 14,112, 84,128,  7,254,
/* 0x1660 */  57,105,255,255, 96, 26,  0,  2,125,105,  3,166, 65,157,  0, 32,
/* 0x1670 */ 127, 90, 88, 48, 84,128,  8, 60, 87, 73,  8, 60,125, 56, 74, 20,
/* 0x1680 */ 125, 32, 72, 80, 56,201,  5, 94, 72,  0,  0,100, 57, 41,255,251,
/* 0x1690 */  61, 96,  0,255,125, 41,  3,166, 97,107,255,255,127,136, 88, 64,
/* 0x16a0 */ 127, 12,224,  0, 84,169, 64, 46, 87, 90,  8, 60, 65,157,  0, 24,
/* 0x16b0 */  65,154,  1, 52,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x16c0 */ 125, 37,  3,120, 85,  8,248,126,127,133, 64, 64, 65,156,  0, 12,
/* 0x16d0 */ 124,168, 40, 80, 99, 90,  0,  1, 66,  0,255,196, 56,  0,  0,  4,
/* 0x16e0 */  87, 90, 32, 54,124,  9,  3,166, 56,216,  6, 68, 60, 96,  0,255,
/* 0x16f0 */  56,128,  0,  1, 96, 99,255,255, 59,224,  0,  1,127,136, 24, 64,
/* 0x1700 */  87,231,  8, 60,127, 12,224,  0, 84,169, 64, 46,124,255, 59,120,
/* 0x1710 */  65,157,  0, 24, 65,154,  0,208,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x1720 */  57,140,  0,  1,125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,
/* 0x1730 */ 125, 64, 89,214, 32, 11,  8,  0, 85,105,217,126,124,  0, 46,112,
/* 0x1740 */ 124, 11,  2, 20,125,105, 88, 80,127,133, 80, 64,125, 10, 64, 80,
/* 0x1750 */  64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 20,
/* 0x1760 */ 124,170, 40, 80, 59,231,  0,  1,125,102, 59, 46,127, 90, 35,120,
/* 0x1770 */  84,132,  8, 60, 66,  0,255,136, 55, 90,  0,  1, 65,130,  0, 72,
/* 0x1780 */ 127,154,200, 64, 59,189,  0,  2, 65,157,  0, 92,124, 26,200, 80,
/* 0x1790 */  59,189,255,255,127,245,  0,174, 49,125,255,255,125, 43,233, 16,
/* 0x17a0 */ 127,249,169,174, 59, 57,  0,  1,124, 20,200, 16,124,  0,  1, 16,
/* 0x17b0 */ 124,  0,  0,208,125, 43,  0, 57, 64,130,255,212,127,153,160, 64,
/* 0x17c0 */  65,156,247,172, 60,  0,  0,255, 96,  0,255,255,127,136,  0, 64,
/* 0x17d0 */  65,157,  0, 32,127,140,224,  0, 56, 96,  0,  1, 65,158,  0, 40,
/* 0x17e0 */  72,  0,  0, 12, 56, 96,  0,  1, 72,  0,  0, 28, 57,140,  0,  1,
/* 0x17f0 */ 125, 40,  2,166,124, 19, 96, 80, 56, 96,  0,  0,144, 14,  0,  0,
/* 0x1800 */ 147, 41,  0,  0,128,  1,  0,100,185,193,  0, 24, 56, 33,  0, 96,
/* 0x1810 */ 124,  8,  3,166,128,161,  0, 12,128,225,  0,  8,128,165,  0,  0,
/* 0x1820 */ 128, 33,  0,  0,124,165, 58, 20,128,  1,  0,  8, 56,165,255,255,
/* 0x1830 */ 128, 33,  0,  0,124,  8,  3,166, 85, 80, 88, 33,161,216,208,213,
/* 0x1840 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1850 */   0,  0,  0,  0,  0,  0,  0, 45,102,105,108,101, 32,102,111,114,
/* 0x1860 */ 109, 97,116, 32,101,108,102, 51, 50, 45,112,111,119,101,114,112,
/* 0x1870 */  99, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120,
/* 0x1880 */  32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x1890 */ 105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32,
/* 0x18a0 */  32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,
/* 0x18b0 */ 101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,
/* 0x18c0 */ 103,115, 10, 32, 32, 48, 32, 76, 73, 78, 85, 88, 48, 48, 48, 32,
/* 0x18d0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48,
/* 0x18e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x18f0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42,
/* 0x1900 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x1910 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49,
/* 0x1920 */  32, 76, 73, 78, 85, 88, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1930 */  48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1940 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1950 */  48, 48, 48, 51, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1960 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x1970 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 76, 73, 78, 85, 88,
/* 0x1980 */  48, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 54,
/* 0x1990 */  52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x19a0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 52, 32,
/* 0x19b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x19c0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 76, 73,
/* 0x19d0 */  78, 85, 88, 48, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x19e0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x19f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1a00 */  97, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1a10 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52,
/* 0x1a20 */  32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x1a30 */  48, 48, 48, 48, 48,102, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a40 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1a50 */  48, 48, 48, 97, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1a60 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x1a70 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 78, 82, 86, 50, 68,
/* 0x1a80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 50,
/* 0x1a90 */  99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1aa0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 57, 56, 32,
/* 0x1ab0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1ac0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1ad0 */  10, 32, 32, 54, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32,
/* 0x1ae0 */  32, 32, 32, 48, 48, 48, 48, 48, 49, 52, 56, 32, 32, 48, 48, 48,
/* 0x1af0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1b00 */  32, 48, 48, 48, 48, 48, 50, 99, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x1b10 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x1b20 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 78,
/* 0x1b30 */  82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1b40 */  48, 48, 48, 49, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1b50 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1b60 */  52, 48, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1b70 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1b80 */  56, 32, 67, 70, 76, 85, 83, 72, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b90 */  48, 48, 48, 48, 48, 48, 50, 52, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1ba0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1bb0 */  48, 48, 48, 52, 50, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1bc0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1bd0 */  10, 32, 32, 57, 32, 76, 90, 77, 65, 32, 32, 32, 32, 32, 32, 32,
/* 0x1be0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1bf0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1c00 */  32, 48, 48, 48, 48, 48, 52, 52, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x1c10 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x1c20 */  78, 76, 89, 10, 32, 49, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x1c30 */  48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 57, 48, 32, 32,
/* 0x1c40 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1c50 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 52, 99, 32, 32, 50, 42,
/* 0x1c60 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1c70 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,
/* 0x1c80 */  49, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32,
/* 0x1c90 */  48, 48, 48, 48, 48, 57, 57, 99, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1ca0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1cb0 */  48, 48, 48, 52,100, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1cc0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1cd0 */  10, 32, 49, 50, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32,
/* 0x1ce0 */  32, 32, 32, 48, 48, 48, 48, 48, 57, 57, 99, 32, 32, 48, 48, 48,
/* 0x1cf0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1d00 */  32, 48, 48, 48, 48, 48,101, 55, 56, 32, 32, 50, 42, 42, 48, 32,
/* 0x1d10 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x1d20 */  78, 76, 89, 10, 32, 49, 51, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x1d30 */  51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 52, 32, 32,
/* 0x1d40 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1d50 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 49, 52, 32, 32, 50, 42,
/* 0x1d60 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1d70 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 85, 80, 88, 49, 72,
/* 0x1d80 */  69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50,
/* 0x1d90 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1da0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 51, 56, 32,
/* 0x1db0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1dc0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76,
/* 0x1dd0 */  32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1de0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 50,
/* 0x1df0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88,
/* 0x1e00 */  48, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1e10 */  32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 51, 48,  9, 48, 48,
/* 0x1e20 */  48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88, 48, 51, 48, 10,
/* 0x1e30 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x1e40 */  32, 78, 82, 86, 95, 84, 65, 73, 76,  9, 48, 48, 48, 48, 48, 48,
/* 0x1e50 */  48, 48, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48,
/* 0x1e60 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x1e70 */  65, 95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e80 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48,
/* 0x1e90 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78,
/* 0x1ea0 */  85, 88, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x1eb0 */  73, 78, 85, 88, 48, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ec0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 49,
/* 0x1ed0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88,
/* 0x1ee0 */  48, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1ef0 */  32, 32,100, 32, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48, 48,
/* 0x1f00 */  48, 48, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,
/* 0x1f10 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,
/* 0x1f20 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 10,
/* 0x1f30 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x1f40 */  32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1f50 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1f60 */  32, 32, 32, 32,100, 32, 32, 67, 70, 76, 85, 83, 72,  9, 48, 48,
/* 0x1f70 */  48, 48, 48, 48, 48, 48, 32, 67, 70, 76, 85, 83, 72, 10, 48, 48,
/* 0x1f80 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x1f90 */  90, 77, 65,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77,
/* 0x1fa0 */  65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1fb0 */ 100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48,
/* 0x1fc0 */  48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x1fd0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1fe0 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48,
/* 0x1ff0 */  48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x2000 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2010 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48,
/* 0x2020 */  48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2030 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2040 */ 100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48,
/* 0x2050 */  48, 48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48,
/* 0x2060 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x2070 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,
/* 0x2080 */ 108,116,101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48,
/* 0x2090 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x20a0 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,
/* 0x20b0 */ 101,114, 95, 99,116,111, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x20c0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x20d0 */  76, 73, 78, 85, 88, 48, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x20e0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x20f0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x2100 */  48, 48, 48, 48, 32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 50, 52,
/* 0x2110 */  32, 32, 32, 32, 32, 32, 32, 76, 73, 78, 85, 88, 48, 51, 48, 10,
/* 0x2120 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80, 67, 95, 82,
/* 0x2130 */  69, 76, 50, 52, 32, 32, 32, 32, 32, 32, 32, 76, 73, 78, 85, 88,
/* 0x2140 */  48, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x2150 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78,
/* 0x2160 */  85, 88, 48, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x2170 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2180 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2190 */  48, 32, 82, 95, 80, 80, 67, 95, 65, 68, 68, 82, 51, 50, 32, 32,
/* 0x21a0 */  32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,
/* 0x21b0 */ 104, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80, 67,
/* 0x21c0 */  95, 65, 68, 68, 82, 51, 50, 32, 32, 32, 32, 32, 32,102,105,108,
/* 0x21d0 */ 116,101,114, 95, 99,116,111, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x21e0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x21f0 */  91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x2200 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2210 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2220 */  57, 48, 32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 49, 52, 32, 32,
/* 0x2230 */  32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82,
/* 0x2240 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x2250 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10, 79,
/* 0x2260 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x2270 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x2280 */  48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 80, 80, 67, 95, 82,
/* 0x2290 */  69, 76, 49, 52, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84,
/* 0x22a0 */  65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x22b0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86,
/* 0x22c0 */  50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x22d0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x22e0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82,
/* 0x22f0 */  95, 80, 80, 67, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 32,
/* 0x2300 */  32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67,
/* 0x2310 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x2320 */  82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10,
/* 0x2330 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x2340 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x2350 */  10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80, 67, 95,
/* 0x2360 */  82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2370 */  95, 68, 69, 67, 51, 48, 43, 48,120, 48, 48, 48, 48, 48, 48, 50,
/* 0x2380 */  52, 10
};
