;; -*-scheme-*-

;; Copyright (C) 2015 Tommi Höynälänmaa


(use-modules (srfi srfi-1))

(import (th-scheme-utilities stdutils))


;;(define (symbol-hash sym i-size)
;;  (remainder (string-hash (symbol->string sym)) i-size))

(define symbol-hash hashq)

(define (symbol-assoc sym al)
  (find (lambda (pr) (eq? sym (car pr))) al))

(define (symbol-hash-ref ht sym-key)
  (hashx-ref symbol-hash symbol-assoc ht sym-key))

(define (symbol-hash-set! ht sym-key obj-value)
  (hashx-set! symbol-hash symbol-assoc ht sym-key obj-value))


;; Keywords have an address field, too.
(define (address-hash address i-size)
  (let* ((sym-name (hfield-ref address 'source-name))
	 (i-name-hash
	  (if (not-null? sym-name)
;;	      (string-hash
;;	       (symbol->string sym-name))
	      (hashq sym-name i-size)
	      0))
	 (i-number0 (hfield-ref address 'number))
	 (i-number (if (>= i-number0 0) i-number0 0))
	 (i-hash (remainder (+ i-name-hash i-number) i-size)))
    i-hash))

(define (address-assoc address al)
;;  (assert (hrecord-is-instance? address <address>))
  (find (lambda (pr) (address=? address (car pr))) al))

(define (address-hash-ref ht addr-key)
;;  (assert (hash-table? ht))
;;  (assert (is-address? addr-key))
  (hashx-ref address-hash address-assoc ht addr-key))

(define (address-hash-set! ht addr-key obj-value)
;;  (assert (hash-table? ht))
;;  (assert (is-address? addr-key))
  (hashx-set! address-hash address-assoc ht addr-key obj-value))


(define (hash-count-elements ht)
  (hash-count (const #t) ht))
