#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main (int argc, char **argv) {
  geo omega (argv[1]);
  size_t n_max = (argc > 2) ? atoi(argv[2]) : 10;
  Float delta_t = 0.5/n_max;
  space Vh (omega, "P1");
  Vh.block ("boundary");
  form m (Vh, Vh, "mass");
  form a (Vh, Vh, "grad_grad");
  form c = m + delta_t*a;
  ssk<Float> c_fact = ldlt (c.uu);
  field fh (Vh, 1.);
  field uh (Vh, 0.);
  branch event ("t","u");
  cout << event (0, uh);
  for (size_t n = 1; n <= n_max; n++) {
    field mb = m*(uh + delta_t*fh);
    uh.u = c_fact.solve (mb.u - c.ub*uh.b);
    cout << event (Float(n)*delta_t, uh);
  }
}
