/**
 *
 * Copyright (c) 2010, Zed A. Shaw and Mongrel2 Project Contributors.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 * 
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 * 
 *     * Neither the name of the Mongrel2 Project, Zed A. Shaw, nor the names
 *       of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written
 *       permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _state_h
#define _state_h

struct State;
struct Connection;

typedef int (*state_action_cb)(struct Connection *conn);

typedef struct StateActions {
    state_action_cb error;
    state_action_cb close;
    state_action_cb parse;
    state_action_cb register_request;
    state_action_cb identify_request;
    state_action_cb route_request;
    state_action_cb send_socket_response;
    state_action_cb msg_to_handler;
    state_action_cb http_to_handler;
    state_action_cb http_to_proxy;
    state_action_cb http_to_directory;
    state_action_cb proxy_deliver;
    state_action_cb proxy_failed;
    state_action_cb proxy_reply_parse;
    state_action_cb proxy_req_parse;
    state_action_cb proxy_close;
    state_action_cb websocket_established;
} StateActions;

typedef struct State {
    int cs;
    void *data;
    StateActions *actions;
} State;

int State_exec(State *state, int event, struct Connection *conn);
int State_invariant(State *state);
int State_init(State *state, StateActions *actions);

const char *State_event_name(int event);

#endif
