/*
    libmaus2
    Copyright (C) 2020 German Tischler-Höhle

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#if ! defined(LIBMAUS2_AIO_SECRECYOUTPUTSTREAMFACTORY_HPP)
#define       LIBMAUS2_AIO_SECRECYOUTPUTSTREAMFACTORY_HPP

#include <libmaus2/LibMausConfig.hpp>

#if defined(LIBMAUS2_HAVE_LIBSECRECY)
#include <libmaus2/aio/OutputStreamFactory.hpp>

namespace libmaus2
{
	namespace aio
	{
		struct SecrecyOutputStreamFactory : public libmaus2::aio::OutputStreamFactory
		{
			typedef SecrecyOutputStreamFactory this_type;
			typedef std::unique_ptr<this_type> unique_ptr_type;
			typedef std::shared_ptr<this_type> shared_ptr_type;

			virtual ~SecrecyOutputStreamFactory();
			virtual libmaus2::aio::OutputStream::unique_ptr_type constructUnique(std::string const & filename, std::string const & params);
			virtual libmaus2::aio::OutputStream::unique_ptr_type constructUnique(std::string const & filename);
			virtual libmaus2::aio::OutputStream::shared_ptr_type constructShared(std::string const & filename, std::string const & params);
			virtual libmaus2::aio::OutputStream::shared_ptr_type constructShared(std::string const & filename);
			virtual void rename(std::string const & from, std::string const & to);

			virtual void mkdir(std::string const & /* name */, uint64_t const /* mode */);
		};
	}
}
#endif
#endif
