package CParse::StructDeclarator;

use 5.6.0;
use strict;
use warnings;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $declarator = shift;
    my $field_width = shift;
    my $self = {declarator => $declarator,
                field_width => $field_width,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $str = $self->{declarator}->dump_c;

    if (defined $self->{field_width})
      {
        $str .= " : " . $self->{field_width}->dump_c;
      }

    return $str;
  }

sub get_member
  {
    my $self = shift;

    my $namespace = shift;

    return $self->{declarator}->get_member($namespace, $self->{field_width}, @_);
  }

1;
