/****
DIAMOND protein aligner
Copyright (C) 2020 Max Planck Society for the Advancement of Science e.V.

Code developed by Benjamin Buchfink <benjamin.buchfink@tue.mpg.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
****/

#include "../standard_matrix.h"

namespace Stats {

const StandardMatrix blosum45{

    14, 2,

    {{ (double)INT2_MAX, (double)INT2_MAX, (double)INT2_MAX, 0.2291, 0.0924, 0.2514, 0.9113, -5.7, 0.641318, 9.611060, 9.611060 },
    { 13, 3, (double)INT2_MAX, 0.207, 0.049, 0.14, 1.5, -22, 0.671128, 35.855900, 35.963900 },
    { 12, 3, (double)INT2_MAX, 0.199, 0.039, 0.11, 1.8, -34, 0.691530, 45.693600, 45.851700 },
    { 11, 3, (double)INT2_MAX, 0.190, 0.031, 0.095, 2.0, -38, 0.691181, 62.874100, 63.103700 },
    { 10, 3, (double)INT2_MAX, 0.179, 0.023, 0.075, 2.4, -51, 0.710529, 88.286800, 88.639100 },
    { 16, 2, (double)INT2_MAX, 0.210, 0.051, 0.14, 1.5, -24, 0.666680, 36.279800, 36.452400 },
    { 15, 2, (double)INT2_MAX, 0.203, 0.041, 0.12, 1.7, -31, 0.673871, 44.825700, 45.060400 },
    { 14, 2, (double)INT2_MAX, 0.195, 0.032, 0.10, 1.9, -36, 0.685753, 60.736200, 61.102300 },
    { 13, 2, (double)INT2_MAX, 0.185, 0.024, 0.084, 2.2, -45, 0.698480, 85.148100, 85.689400 },
    { 12, 2, (double)INT2_MAX, 0.171, 0.016, 0.061, 2.8, -65, 0.713429, 127.758000, 128.582000 },
    { 19, 1, (double)INT2_MAX, 0.205, 0.040, 0.11, 1.9, -43, 0.672302, 53.071400, 53.828200 },
    { 18, 1, (double)INT2_MAX, 0.198, 0.032, 0.10, 2.0, -43, 0.682580, 72.342400, 73.403900 },
    { 17, 1, (double)INT2_MAX, 0.189, 0.024, 0.079, 2.4, -57, 0.695035, 103.055000, 104.721000 },
    { 16, 1, (double)INT2_MAX, 0.176, 0.016, 0.063, 2.8, -67, 0.712966, 170.100000, 173.003000 } },

	{
    /*       A,  R,  N,  D,  C,  Q,  E,  G,  H,  I,  L,  K,  M,
             F,  P,  S,  T,  W,  Y,  V,  B,  J,  Z,  X,  *        */ 
    /*A*/    5, -2, -1, -2, -1, -1, -1,  0, -2, -1, -1, -1, -1,
            -2, -1,  1,  0, -2, -2,  0, -1, -1, -1, -1, -5, -16,
    /*R*/   -2,  7,  0, -1, -3,  1,  0, -2,  0, -3, -2,  3, -1,
            -2, -2, -1, -1, -2, -1, -2, -1, -3,  1, -1, -5, -16,
    /*N*/   -1,  0,  6,  2, -2,  0,  0,  0,  1, -2, -3,  0, -2,
            -2, -2,  1,  0, -4, -2, -3,  5, -3,  0, -1, -5, -16,
    /*D*/   -2, -1,  2,  7, -3,  0,  2, -1,  0, -4, -3,  0, -3,
            -4, -1,  0, -1, -4, -2, -3,  6, -3,  1, -1, -5, -16,
    /*C*/   -1, -3, -2, -3, 12, -3, -3, -3, -3, -3, -2, -3, -2,
            -2, -4, -1, -1, -5, -3, -1, -2, -2, -3, -1, -5, -16,
    /*Q*/   -1,  1,  0,  0, -3,  6,  2, -2,  1, -2, -2,  1,  0,
            -4, -1,  0, -1, -2, -1, -3,  0, -2,  4, -1, -5, -16,
    /*E*/   -1,  0,  0,  2, -3,  2,  6, -2,  0, -3, -2,  1, -2,
            -3,  0,  0, -1, -3, -2, -3,  1, -3,  5, -1, -5, -16,
    /*G*/    0, -2,  0, -1, -3, -2, -2,  7, -2, -4, -3, -2, -2,
            -3, -2,  0, -2, -2, -3, -3, -1, -4, -2, -1, -5, -16,
    /*H*/   -2,  0,  1,  0, -3,  1,  0, -2, 10, -3, -2, -1,  0,
            -2, -2, -1, -2, -3,  2, -3,  0, -2,  0, -1, -5, -16,
    /*I*/   -1, -3, -2, -4, -3, -2, -3, -4, -3,  5,  2, -3,  2,
             0, -2, -2, -1, -2,  0,  3, -3,  4, -3, -1, -5, -16,
    /*L*/   -1, -2, -3, -3, -2, -2, -2, -3, -2,  2,  5, -3,  2,
             1, -3, -3, -1, -2,  0,  1, -3,  4, -2, -1, -5, -16,
    /*K*/   -1,  3,  0,  0, -3,  1,  1, -2, -1, -3, -3,  5, -1,
            -3, -1, -1, -1, -2, -1, -2,  0, -3,  1, -1, -5, -16,
    /*M*/   -1, -1, -2, -3, -2,  0, -2, -2,  0,  2,  2, -1,  6,
             0, -2, -2, -1, -2,  0,  1, -2,  2, -1, -1, -5, -16,
    /*F*/   -2, -2, -2, -4, -2, -4, -3, -3, -2,  0,  1, -3,  0,
             8, -3, -2, -1,  1,  3,  0, -3,  1, -3, -1, -5, -16,
    /*P*/   -1, -2, -2, -1, -4, -1,  0, -2, -2, -2, -3, -1, -2,
            -3,  9, -1, -1, -3, -3, -3, -2, -3, -1, -1, -5, -16,
    /*S*/    1, -1,  1,  0, -1,  0,  0,  0, -1, -2, -3, -1, -2,
            -2, -1,  4,  2, -4, -2, -1,  0, -2,  0, -1, -5, -16,
    /*T*/    0, -1,  0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1,
            -1, -1,  2,  5, -3, -1,  0,  0, -1, -1, -1, -5, -16,
    /*W*/   -2, -2, -4, -4, -5, -2, -3, -2, -3, -2, -2, -2, -2,
             1, -3, -4, -3, 15,  3, -3, -4, -2, -2, -1, -5, -16,
    /*Y*/   -2, -1, -2, -2, -3, -1, -2, -3,  2,  0,  0, -1,  0,
             3, -3, -2, -1,  3,  8, -1, -2,  0, -2, -1, -5, -16,
    /*V*/    0, -2, -3, -3, -1, -3, -3, -3, -3,  3,  1, -2,  1,
             0, -3, -1,  0, -3, -1,  5, -3,  2, -3, -1, -5, -16,
    /*B*/   -1, -1,  5,  6, -2,  0,  1, -1,  0, -3, -3,  0, -2,
            -3, -2,  0,  0, -4, -2, -3,  5, -3,  1, -1, -5, -16,
    /*J*/   -1, -3, -3, -3, -2, -2, -3, -4, -2,  4,  4, -3,  2,
             1, -3, -2, -1, -2,  0,  2, -3,  4, -2, -1, -5, -16,
    /*Z*/   -1,  1,  0,  1, -3,  4,  5, -2,  0, -3, -2,  1, -1,
            -3, -1,  0, -1, -2, -2, -3,  1, -2,  5, -1, -5, -16,
    /*X*/   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5, -16,
    /***/   -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
            -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,  1, -16,
			-16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16,
			-16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16
},

{
  {1.8067859192199651e-02, 2.8632970280029189e-03, 2.5852716092104864e-03,
   2.6802872542729885e-03, 1.4721761726112878e-03, 2.4357016851740214e-03,
   3.7509741193044975e-03, 6.3392371060867767e-03, 1.2691974410907309e-03,
   3.6179059863255059e-03, 5.2267067349121834e-03, 3.6916191127573101e-03,
   1.6118871872377726e-03, 2.1340510849853227e-03, 2.3620871424910785e-03,
   6.2253573100243412e-03, 4.1104541288450981e-03, 5.9150588019808183e-04,
   1.6885104821419373e-03, 5.5306101689579796e-03},
  {2.8632970280029189e-03, 1.2981201352308378e-02, 1.9658257815459023e-03,
   2.0049066095474076e-03, 5.7991132007379289e-04, 2.4961427104605001e-03,
   3.0703156814048727e-03, 2.2360083825481514e-03, 1.2617224002813071e-03,
   1.5810689324881372e-03, 2.9473459585734607e-03, 6.0953893700066292e-03,
   1.0175430650195330e-03, 1.4313644854523438e-03, 1.2956809668774457e-03,
   2.5563801601305607e-03, 1.9632608045077912e-03, 4.0556397557578358e-04,
   1.4263902102458958e-03, 2.1140813134646885e-03},
  {2.5852716092104864e-03, 1.9658257815459023e-03, 7.8501470034711886e-03,
   3.1259558053206788e-03, 6.6941554412093584e-04, 1.5524817804651980e-03,
   2.1724722312522963e-03, 3.3237456813136586e-03, 1.2666696726132058e-03,
   1.4625067095661482e-03, 1.8988677499765833e-03, 2.8106528553236663e-03,
   7.1583261905988334e-04, 1.1127971670944336e-03, 1.1422087671867729e-03,
   3.0730446623880589e-03, 2.4501354524355920e-03, 2.1811180797041274e-04,
   8.5687995159461643e-04, 1.6162116532974411e-03},
  {2.6802872542729885e-03, 2.0049066095474076e-03, 3.1259558053206788e-03,
   1.3237563732845571e-02, 6.2265374552703391e-04, 1.7098653558570117e-03,
   4.7436012699642992e-03, 2.7602948240886133e-03, 1.2034182798676748e-03,
   1.3552305161392132e-03, 2.1559462215056625e-03, 2.8090778444402500e-03,
   6.1643397738889020e-04, 9.9489940177469407e-04, 1.5334105263610980e-03,
   2.8268709927001139e-03, 2.2865632447178858e-03, 2.4814784831918892e-04,
   1.0831280925706914e-03, 1.7172231262216453e-03},
  {1.4721761726112878e-03, 5.7991132007379289e-04, 6.6941554412093584e-04,
   6.2265374552703391e-04, 9.4412874076739879e-03, 4.1042025902182758e-04,
   7.4458585782220040e-04, 9.8139056130103924e-04, 2.8594866937112776e-04,
   7.8981156978924646e-04, 1.4823588205010103e-03, 7.7106114710675307e-04,
   3.5586318613686682e-04, 6.5657489327527010e-04, 4.1203914885321426e-04,
   1.1459765491404468e-03, 1.0139516933242551e-03, 1.0481557906271918e-04,
   3.8818429938079952e-04, 1.1756651305043552e-03},
  {2.4357016851740214e-03, 2.4961427104605001e-03, 1.5524817804651980e-03,
   1.7098653558570117e-03, 4.1042025902182758e-04, 5.6843729268296912e-03,
   3.1938622849651262e-03, 1.8500970336630773e-03, 1.0245276847880554e-03,
   1.2849197264462630e-03, 2.1618326111720785e-03, 2.8660992672576535e-03,
   8.4702447612542125e-04, 7.3960293189886505e-04, 1.0946565407497567e-03,
   2.3989430846357322e-03, 1.4716698819858265e-03, 3.0973861280282215e-04,
   1.0059662375582828e-03, 1.3753940441066036e-03},
  {3.7509741193044975e-03, 3.0703156814048727e-03, 2.1724722312522963e-03,
   4.7436012699642992e-03, 7.4458585782220040e-04, 3.1938622849651262e-03,
   1.3069658477215567e-02, 2.5107356320500625e-03, 1.3852382529276910e-03,
   1.7450831790645173e-03, 3.1086857110181228e-03, 4.4504838476236725e-03,
   8.9571496470550454e-04, 1.3425662787911086e-03, 2.2536863740022671e-03,
   3.2415108480856065e-03, 2.5397857261280324e-03, 4.0327648497408492e-04,
   1.2098752538504236e-03, 2.2567534430266742e-03},
  {6.3392371060867767e-03, 2.2360083825481514e-03, 3.3237456813136586e-03,
   2.7602948240886133e-03, 9.8139056130103924e-04, 1.8500970336630773e-03,
   2.5107356320500625e-03, 2.8511624448995753e-02, 1.2310524422167546e-03,
   1.9327062043969442e-03, 3.1643945035180797e-03, 3.0499894759105127e-03,
   1.0995162153881082e-03, 1.6723363525115967e-03, 2.2429535327172330e-03,
   4.8536849682850143e-03, 2.7272360099530155e-03, 5.9271120428223316e-04,
   1.3911803421160626e-03, 2.5146676607186078e-03},
  {1.2691974410907309e-03, 1.2617224002813071e-03, 1.2666696726132058e-03,
   1.2034182798676748e-03, 2.8594866937112776e-04, 1.0245276847880554e-03,
   1.3852382529276910e-03, 1.2310524422167546e-03, 5.8487547639124796e-03,
   6.9585846800609714e-04, 1.5573467613102150e-03, 1.3245694120032801e-03,
   5.7090651699323862e-04, 7.8182832078834081e-04, 6.9844962409397991e-04,
   1.2960325177514280e-03, 9.1931607877249958e-04, 1.4976351019639964e-04,
   1.2330522291934879e-03, 7.9246698200683503e-04},
  {3.6179059863255059e-03, 1.5810689324881372e-03, 1.4625067095661482e-03,
   1.3552305161392132e-03, 7.8981156978924646e-04, 1.2849197264462630e-03,
   1.7450831790645173e-03, 1.9327062043969442e-03, 6.9585846800609714e-04,
   1.2388694439401509e-02, 9.2647566985432136e-03, 1.9773203824746490e-03,
   2.2593292403687306e-03, 3.0575457844642532e-03, 1.6077385068018789e-03,
   2.3421848303183976e-03, 2.7542711781141610e-03, 4.6749463838911354e-04,
   1.8956764459114616e-03, 9.4267822167510788e-03},
  {5.2267067349121834e-03, 2.9473459585734607e-03, 1.8988677499765833e-03,
   2.1559462215056625e-03, 1.4823588205010103e-03, 2.1618326111720785e-03,
   3.1086857110181228e-03, 3.1643945035180797e-03, 1.5573467613102150e-03,
   9.2647566985432136e-03, 2.6346530417480200e-02, 3.1142098082328640e-03,
   4.0711638827261041e-03, 5.6719761997807835e-03, 1.9088185348168649e-03,
   3.1873279813785520e-03, 3.8426846085017905e-03, 8.4082046153240706e-04,
   3.0567323782711214e-03, 8.7503010016331175e-03},
  {3.6916191127573101e-03, 6.0953893700066292e-03, 2.8106528553236663e-03,
   2.8090778444402500e-03, 7.7106114710675307e-04, 2.8660992672576535e-03,
   4.4504838476236725e-03, 3.0499894759105127e-03, 1.3245694120032801e-03,
   1.9773203824746490e-03, 3.1142098082328640e-03, 1.1978396089560937e-02,
   1.1104403771137466e-03, 1.4742483750212233e-03, 1.9968025222690676e-03,
   3.2668812435946099e-03, 2.7862613227875948e-03, 4.5043772800615431e-04,
   1.4940888302424689e-03, 2.4843185667476147e-03},
  {1.6118871872377726e-03, 1.0175430650195330e-03, 7.1583261905988334e-04,
   6.1643397738889020e-04, 3.5586318613686682e-04, 8.4702447612542125e-04,
   8.9571496470550454e-04, 1.0995162153881082e-03, 5.7090651699323862e-04,
   2.2593292403687306e-03, 4.0711638827261041e-03, 1.1104403771137466e-03,
   2.5874360305861857e-03, 1.2371987255888946e-03, 6.8765677463444332e-04,
   1.0131873446874034e-03, 1.1327846844696357e-03, 2.1265849704555571e-04,
   8.6680034269080448e-04, 2.1688399348504966e-03},
  {2.1340510849853227e-03, 1.4313644854523438e-03, 1.1127971670944336e-03,
   9.9489940177469407e-04, 6.5657489327527010e-04, 7.3960293189886505e-04,
   1.3425662787911086e-03, 1.6723363525115967e-03, 7.8182832078834081e-04,
   3.0575457844642532e-03, 5.6719761997807835e-03, 1.4742483750212233e-03,
   1.2371987255888946e-03, 1.2391203870190888e-02, 8.9236221263296761e-04,
   1.7312816295078565e-03, 1.7453918151105632e-03, 8.4095245274993082e-04,
   3.4263744717066835e-03, 3.0946984716836139e-03},
  {2.3620871424910785e-03, 1.2956809668774457e-03, 1.1422087671867729e-03,
   1.5334105263610980e-03, 4.1203914885321426e-04, 1.0946565407497567e-03,
   2.2536863740022671e-03, 2.2429535327172330e-03, 6.9844962409397991e-04,
   1.6077385068018789e-03, 1.9088185348168649e-03, 1.9968025222690676e-03,
   6.8765677463444332e-04, 8.9236221263296761e-04, 1.6004098119159461e-02,
   1.9539606804874826e-03, 1.9148086102650892e-03, 2.9896951765680344e-04,
   6.8907122080648483e-04, 1.6099029423219423e-03},
  {6.2253573100243412e-03, 2.5563801601305607e-03, 3.0730446623880589e-03,
   2.8268709927001139e-03, 1.1459765491404468e-03, 2.3989430846357322e-03,
   3.2415108480856065e-03, 4.8536849682850143e-03, 1.2960325177514280e-03,
   2.3421848303183976e-03, 3.1873279813785520e-03, 3.2668812435946099e-03,
   1.0131873446874034e-03, 1.7312816295078565e-03, 1.9539606804874826e-03,
   1.0412392255159685e-02, 4.7291383160678064e-03, 3.5033107367116276e-04,
   1.4588588725561497e-03, 3.1161052123834937e-03},
  {4.1104541288450981e-03, 1.9632608045077912e-03, 2.4501354524355920e-03,
   2.2865632447178858e-03, 1.0139516933242551e-03, 1.4716698819858265e-03,
   2.5397857261280324e-03, 2.7272360099530155e-03, 9.1931607877249958e-04,
   2.7542711781141610e-03, 3.8426846085017905e-03, 2.7862613227875948e-03,
   1.1327846844696357e-03, 1.7453918151105632e-03, 1.9148086102650892e-03,
   4.7291383160678064e-03, 8.6497284024982021e-03, 3.1868671219664247e-04,
   1.3184355271303671e-03, 3.8213223234837145e-03},
  {5.9150588019808183e-04, 4.0556397557578358e-04, 2.1811180797041274e-04,
   2.4814784831918892e-04, 1.0481557906271918e-04, 3.0973861280282215e-04,
   4.0327648497408492e-04, 5.9271120428223316e-04, 1.4976351019639964e-04,
   4.6749463838911354e-04, 8.4082046153240706e-04, 4.5043772800615431e-04,
   2.1265849704555571e-04, 8.4095245274993082e-04, 2.9896951765680344e-04,
   3.5033107367116276e-04, 3.1868671219664247e-04, 5.3077625858668461e-03,
   8.1328347217338593e-04, 4.4278005713663357e-04},
  {1.6885104821419373e-03, 1.4263902102458958e-03, 8.5687995159461643e-04,
   1.0831280925706914e-03, 3.8818429938079952e-04, 1.0059662375582828e-03,
   1.2098752538504236e-03, 1.3911803421160626e-03, 1.2330522291934879e-03,
   1.8956764459114616e-03, 3.0567323782711214e-03, 1.4940888302424689e-03,
   8.6680034269080448e-04, 3.4263744717066835e-03, 6.8907122080648483e-04,
   1.4588588725561497e-03, 1.3184355271303671e-03, 8.1328347217338593e-04,
   6.5658130332894053e-03, 1.9130855013886519e-03},
  {5.5306101689579796e-03, 2.1140813134646885e-03, 1.6162116532974411e-03,
   1.7172231262216453e-03, 1.1756651305043552e-03, 1.3753940441066036e-03,
   2.2567534430266742e-03, 2.5146676607186078e-03, 7.9246698200683503e-04,
   9.4267822167510788e-03, 8.7503010016331175e-03, 2.4843185667476147e-03,
   2.1688399348504966e-03, 3.0946984716836139e-03, 1.6099029423219423e-03,
   3.1161052123834937e-03, 3.8213223234837145e-03, 4.4278005713663357e-04,
   1.9130855013886519e-03, 1.4058608660834061e-02}},

   { 7.8254696826829992e-02, 5.2293400508515497e-02, 4.1869234505207159e-02,
 4.9715478669430609e-02, 2.3504091554598174e-02, 3.5913319135963809e-02,
 5.8088865918176615e-02, 7.4985562582061308e-02, 2.4796120028184831e-02,
 6.1906885653760506e-02, 9.3758807045384390e-02, 6.0002347578480664e-02,
 2.5078218042817218e-02, 4.6429254925009635e-02, 4.2599362265185327e-02,
 6.1179450532953900e-02, 5.2495886521295561e-02, 1.3367812099806363e-02,
 3.3781387194819178e-02, 6.9979818411519248e-02 },

  { {0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
{0.00000000e+00, 2.95043377e+00, 7.34701741e-01, 8.00397827e-01,
 6.88936672e-01, 8.25164920e-01, 5.87357723e-01, 1.08031132e+00,
 6.54086288e-01, 7.46806187e-01, 7.86209397e-01, 7.12370041e-01,
 8.21348665e-01, 7.89043130e-01, 7.08569419e-01, 8.66678731e-01,
 6.99695540e-01, 1.30031418e+00, 1.00058530e+00, 1.00992663e+00,
 5.65442334e-01, 7.50000000e-01, 6.38727873e-01, 8.41025176e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.26064996e-01},
{0.00000000e+00, 7.34701741e-01, 3.25946658e+00, 6.00232275e-01,
 3.59386786e+00, 1.30000108e+00, 4.95670856e-01, 8.85913772e-01,
 1.08769141e+00, 4.96979579e-01, 1.02264352e+00, 4.72210752e-01,
 5.80058073e-01, 2.86239890e+00, 6.85801186e-01, 9.91862879e-01,
 8.29088221e-01, 1.05297301e+00, 9.85207016e-01, 5.20111147e-01,
 3.80841719e-01, 7.50000000e-01, 6.27051284e-01, 1.18227759e+00,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.82061098e-01},
{0.00000000e+00, 8.00397827e-01, 6.00232275e-01, 1.70900872e+01,
 5.32858023e-01, 5.45353890e-01, 6.01657157e-01, 5.56827599e-01,
 4.90637659e-01, 5.42801532e-01, 5.46735291e-01, 6.72663401e-01,
 6.03730225e-01, 6.80232381e-01, 4.11520916e-01, 4.86216592e-01,
 4.71814444e-01, 7.96941950e-01, 8.21766666e-01, 7.14771712e-01,
 3.33596922e-01, 7.50000000e-01, 4.88896599e-01, 5.22760621e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 6.21018471e-01},
{0.00000000e+00, 6.88936672e-01, 3.59386786e+00, 5.32858023e-01,
 5.35580571e+00, 1.64256912e+00, 4.31018420e-01, 7.40433725e-01,
 9.76205497e-01, 4.40334375e-01, 9.41681214e-01, 4.62523949e-01,
 4.94422549e-01, 1.50174498e+00, 7.24041930e-01, 9.57667486e-01,
 7.71179788e-01, 9.29413105e-01, 8.76125496e-01, 4.93585385e-01,
 3.73386452e-01, 7.50000000e-01, 6.44927232e-01, 1.38090402e+00,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.53699350e-01},
{0.00000000e+00, 8.25164920e-01, 1.30000108e+00, 5.45353890e-01,
 1.64256912e+00, 3.87327599e+00, 4.97795679e-01, 5.76408577e-01,
 9.61718230e-01, 4.85270933e-01, 1.27686825e+00, 5.70784073e-01,
 6.14865688e-01, 8.93236200e-01, 9.10746443e-01, 1.53097375e+00,
 1.01074883e+00, 9.12113764e-01, 8.32873235e-01, 5.55160304e-01,
 5.19337483e-01, 7.50000000e-01, 6.16552718e-01, 2.97840479e+00,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.36776244e-01},
{0.00000000e+00, 5.87357723e-01, 4.95670856e-01, 6.01657157e-01,
 4.31018420e-01, 4.97795679e-01, 5.74817622e+00, 4.80346092e-01,
 6.79103477e-01, 1.06375667e+00, 5.29188869e-01, 1.30295859e+00,
 1.06255416e+00, 5.72439082e-01, 4.51176385e-01, 4.43558969e-01,
 5.89537777e-01, 6.09495403e-01, 7.16103747e-01, 9.52475503e-01,
 1.35493791e+00, 7.50000000e-01, 2.18456832e+00, 4.77074668e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.20783008e+00},
{0.00000000e+00, 1.08031132e+00, 8.85913772e-01, 5.56827599e-01,
 7.40433725e-01, 5.76408577e-01, 4.80346092e-01, 5.07068525e+00,
 6.62087167e-01, 4.16341047e-01, 6.77879412e-01, 4.50091586e-01,
 5.84692214e-01, 1.05865660e+00, 7.02165561e-01, 6.87007231e-01,
 5.70228460e-01, 1.05800656e+00, 6.92819008e-01, 4.79214700e-01,
 5.91296285e-01, 7.50000000e-01, 5.49197180e-01, 6.18662539e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.36669292e-01},
{0.00000000e+00, 6.54086288e-01, 1.08769141e+00, 4.90637659e-01,
 9.76205497e-01, 9.61718230e-01, 6.79103477e-01, 6.62087167e-01,
 9.51252809e+00, 4.53313059e-01, 8.90272071e-01, 6.69868446e-01,
 9.18088604e-01, 1.22006964e+00, 6.61223470e-01, 1.15049417e+00,
 9.73045615e-01, 8.54331847e-01, 7.06245757e-01, 4.56693295e-01,
 4.51816356e-01, 7.50000000e-01, 1.47204221e+00, 1.03383965e+00,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.83746261e-01},
{0.00000000e+00, 7.46806187e-01, 4.96979579e-01, 5.42801532e-01,
 4.40334375e-01, 4.85270933e-01, 1.06375667e+00, 4.16341047e-01,
 4.53313059e-01, 3.23256769e+00, 5.32316397e-01, 1.59618413e+00,
 1.45527106e+00, 5.64240025e-01, 6.09639867e-01, 5.77938325e-01,
 4.88387978e-01, 6.18410187e-01, 8.47505386e-01, 2.17596400e+00,
 5.64907506e-01, 7.50000000e-01, 9.06458192e-01, 5.20674297e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.24695958e+00},
{0.00000000e+00, 7.86209397e-01, 1.02264352e+00, 5.46735291e-01,
 9.41681214e-01, 1.27686825e+00, 5.29188869e-01, 6.77879412e-01,
 8.90272071e-01, 5.32316397e-01, 3.32707189e+00, 5.53563636e-01,
 7.37955763e-01, 1.11877807e+00, 7.81202774e-01, 1.33004839e+00,
 1.94261316e+00, 8.89937552e-01, 8.84562104e-01, 5.91651856e-01,
 5.61572955e-01, 7.50000000e-01, 7.37107274e-01, 1.29718560e+00,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.45113795e-01},
{0.00000000e+00, 7.12370041e-01, 4.72210752e-01, 6.72663401e-01,
 4.62523949e-01, 5.70784073e-01, 1.30295859e+00, 4.50091586e-01,
 6.69868446e-01, 1.59618413e+00, 5.53563636e-01, 2.99708655e+00,
 1.73144954e+00, 4.83712850e-01, 4.77913692e-01, 6.42028706e-01,
 6.01135200e-01, 5.55659969e-01, 7.80723755e-01, 1.33363845e+00,
 6.70858407e-01, 7.50000000e-01, 9.65090110e-01, 5.98002922e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.43995990e+00},
{0.00000000e+00, 8.21348665e-01, 5.80058073e-01, 6.03730225e-01,
 4.94422549e-01, 6.14865688e-01, 1.06255416e+00, 5.84692214e-01,
 9.18088604e-01, 1.45527106e+00, 7.37955763e-01, 1.73144954e+00,
 4.11411354e+00, 6.81741591e-01, 6.43682874e-01, 9.40467390e-01,
 7.75906233e-01, 6.60370266e-01, 8.60449567e-01, 1.23582796e+00,
 6.34345311e-01, 7.50000000e-01, 1.02316322e+00, 7.39261071e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.62161577e+00},
{0.00000000e+00, 7.89043130e-01, 2.86239890e+00, 6.80232381e-01,
 1.50174498e+00, 8.93236200e-01, 5.72439082e-01, 1.05865660e+00,
 1.22006964e+00, 5.64240025e-01, 1.11877807e+00, 4.83712850e-01,
 6.81741591e-01, 4.47803773e+00, 6.40394172e-01, 1.03246645e+00,
 8.97848625e-01, 1.19968790e+00, 1.11473028e+00, 5.51607804e-01,
 3.89694095e-01, 7.50000000e-01, 6.05825405e-01, 9.46428796e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.15737804e-01},
{0.00000000e+00, 7.08569419e-01, 6.85801186e-01, 4.11520916e-01,
 7.24041930e-01, 9.10746443e-01, 4.51176385e-01, 7.02165561e-01,
 6.61223470e-01, 6.09639867e-01, 7.81202774e-01, 4.77913692e-01,
 6.43682874e-01, 6.40394172e-01, 8.81911509e+00, 7.15515810e-01,
 5.81631739e-01, 7.49733904e-01, 8.56242933e-01, 5.40037335e-01,
 5.25005050e-01, 7.50000000e-01, 4.78832406e-01, 8.36159027e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.30300041e-01},
{0.00000000e+00, 8.66678731e-01, 9.91862879e-01, 4.86216592e-01,
 9.57667486e-01, 1.53097375e+00, 4.43558969e-01, 6.87007231e-01,
 1.15049417e+00, 5.77938325e-01, 1.33004839e+00, 6.42028706e-01,
 9.40467390e-01, 1.03246645e+00, 7.15515810e-01, 4.40728842e+00,
 1.32912854e+00, 1.09183956e+00, 7.80601862e-01, 5.47266398e-01,
 6.45177884e-01, 7.50000000e-01, 8.29182983e-01, 2.62986317e+00,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 6.16540522e-01},
{0.00000000e+00, 6.99695540e-01, 8.29088221e-01, 4.71814444e-01,
 7.71179788e-01, 1.01074883e+00, 5.89537777e-01, 5.70228460e-01,
 9.73045615e-01, 4.88387978e-01, 1.94261316e+00, 6.01135200e-01,
 7.75906233e-01, 8.97848625e-01, 5.81631739e-01, 1.32912854e+00,
 4.74702063e+00, 7.99048209e-01, 7.15164318e-01, 5.77699501e-01,
 5.80165842e-01, 7.50000000e-01, 8.07446927e-01, 1.13238507e+00,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.56296615e-01},
{0.00000000e+00, 1.30031418e+00, 1.05297301e+00, 7.96941950e-01,
 9.29413105e-01, 9.12113764e-01, 6.09495403e-01, 1.05800656e+00,
 8.54331847e-01, 6.18410187e-01, 8.89937552e-01, 5.55659969e-01,
 6.60370266e-01, 1.19968790e+00, 7.49733904e-01, 1.09183956e+00,
 7.99048209e-01, 2.78188630e+00, 1.47248598e+00, 7.27836330e-01,
 4.28363793e-01, 7.50000000e-01, 7.05878947e-01, 9.80777594e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.80615182e-01},
{0.00000000e+00, 1.00058530e+00, 9.85207016e-01, 8.21766666e-01,
 8.76125496e-01, 8.32873235e-01, 7.16103747e-01, 6.92819008e-01,
 7.06245757e-01, 8.47505386e-01, 8.84562104e-01, 7.80723755e-01,
 8.60449567e-01, 1.11473028e+00, 8.56242933e-01, 7.80601862e-01,
 7.15164318e-01, 1.47248598e+00, 3.13871529e+00, 1.04019697e+00,
 4.54128072e-01, 7.50000000e-01, 7.43457494e-01, 8.12903077e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 8.07282226e-01},
{0.00000000e+00, 1.00992663e+00, 5.20111147e-01, 7.14771712e-01,
 4.93585385e-01, 5.55160304e-01, 9.52475503e-01, 4.79214700e-01,
 4.56693295e-01, 2.17596400e+00, 5.91651856e-01, 1.33363845e+00,
 1.23582796e+00, 5.51607804e-01, 5.40037335e-01, 5.47266398e-01,
 5.77699501e-01, 7.27836330e-01, 1.04019697e+00, 2.87075890e+00,
 4.73320057e-01, 7.50000000e-01, 8.09252575e-01, 5.52144455e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.66862396e+00},
{0.00000000e+00, 5.65442334e-01, 3.80841719e-01, 3.33596922e-01,
 3.73386452e-01, 5.19337483e-01, 1.35493791e+00, 5.91296285e-01,
 4.51816356e-01, 5.64907506e-01, 5.61572955e-01, 6.70858407e-01,
 6.34345311e-01, 3.89694095e-01, 5.25005050e-01, 6.45177884e-01,
 5.80165842e-01, 4.28363793e-01, 4.54128072e-01, 4.73320057e-01,
 2.97023509e+01, 7.50000000e-01, 1.80096028e+00, 5.67414520e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 6.28722660e-01},
{0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
{0.00000000e+00, 6.38727873e-01, 6.27051284e-01, 4.88896599e-01,
 6.44927232e-01, 6.16552718e-01, 2.18456832e+00, 5.49197180e-01,
 1.47204221e+00, 9.06458192e-01, 7.37107274e-01, 9.65090110e-01,
 1.02316322e+00, 6.05825405e-01, 4.78832406e-01, 8.29182983e-01,
 8.07446927e-01, 7.05878947e-01, 7.43457494e-01, 8.09252575e-01,
 1.80096028e+00, 7.50000000e-01, 5.75351902e+00, 6.97787623e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 9.41772708e-01},
{0.00000000e+00, 8.41025176e-01, 1.18227759e+00, 5.22760621e-01,
 1.38090402e+00, 2.97840479e+00, 4.77074668e-01, 6.18662539e-01,
 1.03383965e+00, 5.20674297e-01, 1.29718560e+00, 5.98002922e-01,
 7.39261071e-01, 9.46428796e-01, 8.36159027e-01, 2.62986317e+00,
 1.13238507e+00, 9.80777594e-01, 8.12903077e-01, 5.52144455e-01,
 5.67414520e-01, 7.50000000e-01, 6.97787623e-01, 2.84524527e+00,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.67250003e-01},
{0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
{0.00000000e+00, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
 2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
 2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
 2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
 2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
 2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
 2.90000000e-01, 1.33300000e+00, 2.90000000e-01, 2.90000000e-01},
{0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
{0.00000000e+00, 7.26064996e-01, 4.82061098e-01, 6.21018471e-01,
 4.53699350e-01, 5.36776244e-01, 1.20783008e+00, 4.36669292e-01,
 5.83746261e-01, 2.24695958e+00, 5.45113795e-01, 2.43995990e+00,
 1.62161577e+00, 5.15737804e-01, 5.30300041e-01, 6.16540522e-01,
 5.56296615e-01, 5.80615182e-01, 8.07282226e-01, 1.66862396e+00,
 6.28722660e-01, 7.50000000e-01, 9.41772708e-01, 5.67250003e-01,
 7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.36320536e+00} }

};

}