/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: basicmixer.hxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SDR_MIXER_BASICMIXER_HXX
#define _SDR_MIXER_BASICMIXER_HXX

#include <sal/types.h>
#include <tools/gen.hxx>

//////////////////////////////////////////////////////////////////////////////
// predeclarations

namespace sdr
{
	namespace contact
	{
		class DisplayInfo;
		class ViewObjectContact;
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace mixer
	{
		class BasicMixer
		{
		protected:
			// setup associated object for paint at given state
			virtual void SetupObject(double fMixerState, sdr::contact::DisplayInfo& rDisplayInfo) = 0;

			// restore associated object to original state
			virtual void RestoreObject(sdr::contact::DisplayInfo& rDisplayInfo) = 0;

		public:
			// basic constructor.
			BasicMixer();

			// destructor
			virtual ~BasicMixer();

			// paint method. This will call SetupObject(fMixerState), then the paint at the
			// associated ViewCOntact, and then RestoreObject().
			virtual sal_Bool PaintObject(double fMixerState, sdr::contact::DisplayInfo& rDisplayInfo, 
				Rectangle& rPaintRectangle, const sdr::contact::ViewObjectContact& rAssociatedVOC);
		};
	} // end of namespace mixer
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// #test# color change mixer
// predeclarations

class SdrObject;

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace mixer
	{
		class ColorChangeMixer : public BasicMixer
		{
			// The animated object
			SdrObject&								mrObject;

			// #test# color change mixer
			sal_uInt32								mnOrigColor;

		protected:
			// internal access to SdrObject
			SdrObject& GetSdrObject() const
			{
				return mrObject;
			}

			// setup associated object for paint at given state
			virtual void SetupObject(double fMixerState, sdr::contact::DisplayInfo& rDisplayInfo);

			// restore associated object to original state
			virtual void RestoreObject(sdr::contact::DisplayInfo& rDisplayInfo);

		public:
			// basic constructor.
			ColorChangeMixer(SdrObject& rObject);

			// destructor
			virtual ~ColorChangeMixer();
		};
	} // end of namespace mixer
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_MIXER_BASICMIXER_HXX

// eof
