/***************************************************************************
                          kmess.h  -  description
                             -------------------
    begin                : Sun Jan  5 15:18:36 CST 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESS_H
#define KMESS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qptrlist.h>

#include <kapp.h>
#include "kmessinterface.h"
#include "kmessdebug.h"

// Forward declarations
class Account;
class AccountAction;
class AutologinView;
class BalloonWidget;
class ChatMaster;
class ChatNotification;
class Contact;
class ContactList;
class ContactOfflineNotification;
class ContactOnlineNotification;
class CurrentAccount;
class EmailNotification;
class IdleTimer;
class InitialView;
class KMessTest;
class KMessView;
class MsnNotificationConnection;
class NetworkWindow;
class SystemTrayWidget;

// KMess is the base class of the project
class KMess : public KMessInterface
{
  Q_OBJECT

  friend class KMessTest;

  public: // Public methods
    // The construtor
                       KMess(QWidget* parent=0, const char *name=0);
    // The destructor
                      ~KMess();
    // Autologin with the first account that has autologin enabled
    void               checkAutologin(QString handle);
    // Initialize the class
    bool               initialize();

#ifdef KMESS_NETWORK_WINDOW
    /// Get the network window (for the chatmaster to bind to it)
    NetworkWindow *    getNetworkWindow() const
    { return networkWindow_; }
#endif

  protected:  // Protected methods
    // Read in account and other properties
    virtual void       readProperties(KConfig *config);
    // Save account and other properties
    virtual void       saveProperties(KConfig *config);

  private: // Private methods
    // Add an account to the settings and connect menus
    void               addAccountToMenus(Account *account);
    // The application is closing, after queryExit() was approved
    void               applicationClosing();
    // Create the program's default directories in .kde/share/apps/
    bool               createDirectories();
    // Initialize the autologin view
    bool               initAutologinView();
    // Initialize the chat master
    bool               initChatMaster();
    // Initialize the idle timer
    bool               initIdleTimer();
    // Initialize the initial view
    bool               initInitialView();
    // Initialize the main view
    bool               initKMessView();
    // Initialize the MSN notification connection
    bool               initMsnNotificationConnection();
    // Initialize notification objects
    bool               initNotifications();
    // Initialize the system tray widget
    bool               initSystemTrayWidget();
    // Set the caption
    void               setCaptionToUser();

  private slots: // Private slots
    // "Add a new contact" was selected from the menu.
    void               addNewContact();
    // "Add a new group" was selected from the menu.
    void               addNewGroup();
    // A status was selected from the menu.
    void               changeStatus(const QString &statusName);
    // The status was changed
    void               changedStatus();
    // A view mode has been selected from the menu.
    void               changeViewMode(int mode);
    // Show a "Contact added you" dialog
    void               showContactAddedUserDialog(const Contact *contact);
    // Show a dialog before removing the contact
    void               showRemoveContactDialog(QString handle);
    // Show a dialog before removing the group
    void               showRemoveGroupDialog(QString groupId);
    // Show a "Rename group" dialog
    void               showRenameGroupDialog(QString groupId);
#ifdef KMESS_NETWORK_WINDOW
    // Open the network window
    void               showNetworkWindow();
#endif
    // Open the transfer manager
    void               showTransferWindow();
    // A connection has been made with the notification server.
    void               connected();
    // Connect to the server with the given account
    void               connectWithAccount(Account *account);
    // Connect to the server with the given, possibly temporary, new account
    void               connectWithNewAccount(Account *account, bool doSave);
    // The current account changed its name, so set the corresponding account's name
    void               currentAccountChangedName();
    // "Add new account" has been selected from the menu.
    void               createNewAccount();
    // Delete the given account
    void               deleteAccount(Account *account);
    // Disconnect was selected from the menu.
    void               disconnectClicked();
    // The program is not connected (initially) or no longer connected (after
    //  a disconnect) to the notification server.
    void               disconnected();
    // Show the settings dialog for a given account
    void               showSettingsForAccount(Account *account);
    // Show the user's MSN profile.
    void               showUserProfile();
    // We're about to shutdown, apparently
    void               shutDown();
    // The "show allowed contacts" menu item has been toggled.
    void               toggleShowAllowed(bool show);
    // The "show offline contacts" menu item has been toggled.
    void               toggleShowOffline(bool show);
    // The "Show removed contacts" menu item has been toggled.
    void               toggleShowRemoved(bool show);
    // The user has gone idle
    void               userIsIdle();
    // The user is no longer idle
    void               userIsNotIdle();

  private: // Private attributes
    // A list of user accounts
    QPtrList<Account>  accounts_;
    // The autologin view widget
    AutologinView     *autologinView_;
    // The master notification widget which holds the others
    BalloonWidget     *balloonWidget_;
    // The chat master - the object that controls the chat window
    ChatMaster        *chatMaster_;
    // The notification object for when a ocntact starts a chat
    ChatNotification  *chatNotification_;
    // The notification object for when a contact goes offline
    ContactOfflineNotification *contactOfflineNotification_;
    // The notification object for when a contact comes online
    ContactOnlineNotification *contactOnlineNotification_;
    // A pointer to the instance of the current account
    CurrentAccount    *currentAccount_;
    // The notification object for when a new email is received
    EmailNotification *emailNotification_;
    // The idle timer
    IdleTimer         *idleTimer_;
    // Whether or not the object has been initialized
    bool               initialized_;
    // The initial login view widget
    InitialView       *initialView_;
    // The connection to the msn notification server
    MsnNotificationConnection *msnNotificationConnection_;
    // The system tray widget
    SystemTrayWidget  *systemTrayWidget_;
    // A list of impermanent user accounts
    QPtrList<Account>  unsavedAccounts_;
    // The main view widget
    KMessView         *view_;
#ifdef KMESS_NETWORK_WINDOW
    // The network window
    NetworkWindow     *networkWindow_;
#endif
};

#endif
