/***************************************************************************
                          contactbase.cpp  -  description
                             -------------------
    begin                : Thu Jan 16 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "contactbase.h"

#include <kdebug.h>
#include <kstandarddirs.h>

#include "../kmessdebug.h"

// The constructor
ContactBase::ContactBase(QString handle, QString friendlyName)
 : friendlyName_(friendlyName),
   handle_(handle)
{
}



// The destructor
ContactBase::~ContactBase()
{
}



// Return the default contact picture path
QString ContactBase::getContactDefaultPicturePath() const
{
  KStandardDirs *dirs   = KGlobal::dirs();
  return dirs->findResource( "data", "kmess/pics/unknown.png" );
}



// Return the contact's friendly name
QString ContactBase::getFriendlyName() const
{
  return friendlyName_;
}



// Return the contact's handle
QString ContactBase::getHandle() const
{
  return handle_;
}



// Return true if the contact is offline
bool ContactBase::isOffline() const
{
  return getStatus() == "FLN";
}



// Return true if the contact is online
bool ContactBase::isOnline() const
{
  return getStatus() != "FLN";
}


#include "contactbase.moc"
