/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMI_WAVETBL_H__
#define __SWAMI_WAVETBL_H__

#include <glib.h>
#include <instpatch.h>

/* FIXME */
// #include <glib-object.h>
#include "swamidll.h"
#include "GObjSup.h"

typedef struct _SwamiWavetbl SwamiWavetbl;
typedef struct _SwamiWavetblClass SwamiWavetblClass;

#define SWAMI_TYPE_WAVETBL   (swami_wavetbl_get_type ())
#define SWAMI_WAVETBL(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWAMI_TYPE_WAVETBL, SwamiWavetbl))
#define SWAMI_WAVETBL_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), SWAMI_TYPE_WAVETBL, SwamiWavetblClass))
#define SWAMI_IS_WAVETBL(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWAMI_TYPE_WAVETBL))
#define SWAMI_IS_WAVETBL_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), SWAMI_TYPE_WAVETBL))

SWAMI_API extern int swami_wavetbl_temp_bank;
SWAMI_API extern int swami_wavetbl_temp_psetnum;

/* Swami Wavetbl object */
struct _SwamiWavetbl
{
  GObject object;		/* derived from GObject */

  /*< private >*/

  gboolean active;		/* driver is active? */
};

struct _SwamiWavetblClass
{
  GObjectClass parent_class;

  /*< public >*/

  int (*init_driver) (SwamiWavetbl *wavetbl);
  void (*close_driver) (SwamiWavetbl *wavetbl);
  int (*load_patch) (SwamiWavetbl *wavetbl, IPItem *patch);
  int (*load_temp_item) (SwamiWavetbl *wavetbl, IPItem *item);
  void (*set_gen_realtime) (SwamiWavetbl *wavetbl, IPItem *item, IPItem *layer,
			    guint16 genid, int val);
};


SWAMI_API GType swami_wavetbl_get_type (void);
SWAMI_API SwamiWavetbl *swami_wavetbl_new (void);

SWAMI_API int swami_wavetbl_init_driver (SwamiWavetbl *wavetbl);
SWAMI_API void swami_wavetbl_close_driver (SwamiWavetbl *wavetbl);

SWAMI_API int swami_wavetbl_load_patch (SwamiWavetbl *wavetbl, IPItem *patch);
SWAMI_API int swami_wavetbl_load_temp_item (SwamiWavetbl *wavetbl,
					    IPItem *item);
SWAMI_API void swami_wavetbl_set_gen_realtime (SwamiWavetbl *wavetbl,
					       IPItem *item, IPItem *layer,
					       guint16 genid, int val);
#endif
