/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * AtFStk -- Attribute Filesystem Toolkit Library
 *
 * bind.h
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: bind.h[7.0] Tue Jun 29 16:16:14 1993 andy@cs.tu-berlin.de frozen $
 */

/*=============================
 *  constant definitions
 *=============================*/

#define BIND_RULES_FILENAME "BindRules"

#define BIND_MAX_BINDING_LEN 256
#define BIND_MAX_RULEARGS    16

/*========================================
 *  flags and constant definitions
 *========================================*/

extern int atBindTrace;

/*** predicate names ***/
#define BIND_PRED_ATTR		0
#define BIND_PRED_ATTREX	1
#define BIND_PRED_ATTRGE	2
#define BIND_PRED_ATTRGT	3
#define BIND_PRED_ATTRLE	4
#define BIND_PRED_ATTRLT	5
#define BIND_PRED_ATTRMAX	6
#define BIND_PRED_ATTRMIN	7
#define BIND_PRED_ATTRNOT	8
#define BIND_PRED_RULE		9
#define BIND_PRED_CONDEX	10
#define BIND_PRED_CONDEXPR	11
#define BIND_PRED_CONDNOT	12
#define BIND_PRED_CONDUNIQ	13
#define BIND_PRED_CONFIRM	14
#define BIND_PRED_CUT		15
#define BIND_PRED_MSG		16

/*==============================
 *  type definitions
 *==============================*/

#define BIND_ARG1_RULE_MACRO	 01
#define BIND_ARG1_SHAPE_MACRO	 02
#define BIND_ARG1_SHELL_COMMAND	 04
#define BIND_ARG2_RULE_MACRO	010
#define BIND_ARG2_SHAPE_MACRO	020
#define BIND_ARG2_SHELL_COMMAND	040

typedef struct predicate Predicate;

struct predicate {
  int       position; /* position in predicates list */
  char      *args[2];
  int       info;
  Predicate *next;
};

#define BIND_PATTERN_RULE_MACRO	   0100
#define BIND_PATTERN_SHAPE_MACRO   0200
#define BIND_PATTERN_SHELL_COMMAND 0400

typedef struct alternative Alternative;

struct alternative {
  char        *pattern;
  Predicate   *predList;
  int         info;
  Alternative *next;
};

typedef struct {
  char        *name;
  char        *body;
  int         argNum;
  char        *argList[BIND_MAX_RULEARGS];
  int         status;
  Alternative *altList;
  char        *fileName;
  int         srcLine;
} BindRule;

typedef struct {
  int    baselineType;
  char   *baselineString;
  int    baselineGen;
  int    baselineRev;
  time_t baselineDate;
} BindBaseline;

/*==============================
 *  function definitions
 *==============================*/

/*** bind_attr.c ***/

int	atBindAttrAbsolute A((Af_set *set, char *attrName, char *attrValue));
int	atBindAttrRelative A((Af_set *set, char *attrName, char *attrValue, int op));
int	atBindAttrMinMax   A((Af_set *set, char *attrName, int op));

/*** bind_rules.c ***/

int	atBindInitRules	A((void));
char	*atCurRuleName  A((void));
int	atBindSetRule	A((char *ruleName, char *targName, int init));
void	atBindUnsetRule	A((int abort));
char	*atBindRuleAlt	A((Af_set *hitSet));
int	atBindRulePred	A((char **arg1, char **arg2, Af_set *hitSet));

/*** bind_scan.c ***/

char	*atBindPredName	A((int pos));
int	atBindPredCode	A((int pos));
int	atRuleNameScan	A((BindRule *rule));
int	atRuleScan	A((BindRule *rule));
void	atRuleDisplay	A((BindRule *rule));
