/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000,2001 James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000,2001 Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] = "$Id: rpld.c,v 1.35 2001/11/01 15:30:29 root Exp $";

/*
 * $Log: rpld.c,v $
 * Revision 1.35  2001/11/01 15:30:29  root
 * #
 *
 * Revision 1.34  2001/11/01 15:28:23  root
 * #
 *
 * Revision 1.33  2001/11/01 15:26:45  root
 * #
 *
 * Revision 1.32  2001/11/01 15:26:29  root
 * #
 *
 * Revision 1.31  2001/11/01 15:23:59  root
 * #
 *
 * Revision 1.30  2000/09/26 04:06:07  root
 * #
 *
 * Revision 1.29  2000/09/26 03:48:23  root
 * #
 *
 * Revision 1.28  2000/09/26 02:32:46  root
 * #
 *
 * Revision 1.27  2000/09/26 02:31:38  root
 * #
 *
 * Revision 1.26  2000/09/26 01:42:24  root
 * #
 *
 * Revision 1.25  2000/09/26 01:41:22  root
 * #
 *
 * Revision 1.24  2000/09/26 01:41:20  root
 * #
 *
 * Revision 1.23  2000/09/26 01:41:08  root
 * #
 *
 * Revision 1.22  2000/09/26 01:39:17  root
 * #
 *
 * Revision 1.21  2000/09/26 01:03:19  root
 * #
 *
 * Revision 1.20  2000/07/29 23:25:58  root
 * #
 *
 * Revision 1.19  2000/07/29 23:20:02  root
 * #
 *
 * Revision 1.18  2000/07/23 19:14:19  root
 * #
 *
 * Revision 1.17  2000/07/17 11:59:45  root
 * #
 *
 * Revision 1.16  2000/07/17 10:49:20  root
 * #
 *
 * Revision 1.15  2000/07/17 10:45:38  root
 * #
 *
 * Revision 1.14  2000/07/17 10:43:54  root
 * #
 *
 * Revision 1.13  2000/07/17 10:43:34  root
 * #
 *
 * Revision 1.12  2000/07/16 14:22:06  root
 * #
 *
 * Revision 1.11  2000/07/16 14:05:28  root
 * #
 *
 * Revision 1.10  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.9  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.8  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.7  1999/09/13 11:04:13  root
 * \#
 *
 */

#include "project.h"

#define  DEF_IF "eth0"

static unsigned char RPL_MC_ADDR[ETH_ALEN] = { 0x3, 0x0, 0x2, 0x0, 0x0, 0x0 };

int downloading = 0;
int pacing = 10000;

int rpl_sap = RPL_SAP;
static void
usage (char *name)
{

  fprintf (stderr, "Usage \n");
  fprintf (stderr,
           "%s [-f] [-C configfile] [-i interface] [-s sap] [-h]\n", name);
  fprintf (stderr, "\n");
  fprintf (stderr, "-f               do not fork, run in foreground\n");
  fprintf (stderr,
           "-C configfile    read configfile as the configuration file\n");
  fprintf (stderr,
           "                 rather than the default %s\n", CONFIG_FILE);
  fprintf (stderr,
           "-i interface     bind to interface rather than default %s\n",
           DEF_IF);
  fprintf (stderr,
           "-s sap           Use SAP sap, sap may either be decimal or\n");
  fprintf (stderr,
           "                 hex proceeded by 0x common values are 0xfc\n");
  fprintf (stderr,
           "                 0xf8 and 0xf4 the default is 0x%02x\n", RPL_SAP);
  fprintf (stderr, "-h               print this message\n");

  exit (1);
}

int
main (argc, argv)
     int argc;
     char **argv;
{
  unsigned char buf[MAX_FRAME_LEN];
  struct llchdr *h = (struct llchdr *) buf;
  struct timeval last;
  struct llcdrv *lld;
  char *if_name = DEF_IF;
  char *config = CONFIG_FILE;
  int fg = 0;



  openlog ("rpld", LOG_PID, LOG_DAEMON);
  {
    extern char *optarg;
    extern int optind;
    int c;
    while ((c = getopt (argc, argv, "C:i:s:fh")) != EOF)
      {
        switch (c)
          {
          case 'C':
            config = optarg;
            break;
          case 'i':
            if_name = optarg;
            break;
          case 's':
            if (!strncmp (optarg, "0x", 2))
              {
                rpl_sap = strtol (optarg + 2, NULL, 16);
              }
            else
              {
                rpl_sap = strtol (optarg, NULL, 10);
              }

            if ((rpl_sap <= 0) || (rpl_sap > 255))
              {
                fprintf (stderr,
                         "%s: argument to -s must be in range 1-255\n",
                         argv[0]); return 1;
              }
            break;
          case 'f':
            fg++;
            break;
          case '?':
          case 'h':
            usage (argv[0]);
          }
      }

  }


  parse_config (config);
  if (!fg)
    daemonize ();
  lld = llc_open (rpl_sap, if_name);
  if (!lld)
    {
      syslog (LOG_ERR, "failed to initalize llc layer");
      return (-1);
    }

  if (lld->add_multicast)
    {
      lld->add_multicast (lld, RPL_MC_ADDR);
    }

  syslog (LOG_ERR, "my hw addr = %s", ethtoa (lld->mac (lld)));
  gettimeofday (&last, NULL);
  while (1)
    {
      int len;
      struct timeval tv;
      if (downloading)
        {
          tv.tv_sec = 0;
          tv.tv_usec = pacing >> 1;
        }
      else
        {
          tv.tv_sec = 10;
          tv.tv_usec = 0;
        }
      {
        char smac[ETH_ALEN];
        len = lld->recv (lld, buf, sizeof (buf), smac, NULL, &tv);
      }

      rpl_packet_recvd (lld, buf, len);
#if 0
      nit_read_packet (n, buf, sizeof (buf), &tv);
      if ((len > LLC_HDR_LEN) && (ntohs (h->h_len) <= 1514))
        {                       /*Short circuit most packets */
          llc_recv (n, buf, len);
        }
#endif


      if (downloading)
        {
          gettimeofday (&tv, NULL);
          len = tv.tv_sec;
          len -= last.tv_sec;
          if (len > 1)
            len = 2;
          len *= 1000000;
          len += tv.tv_usec;
          len -= last.tv_usec;
          if (len > pacing)
            {
              client_dispatch (lld);
              gettimeofday (&last, NULL);
            }
        }
    }

  lld->close (lld);
  return 0;
}
