/*
 *  Copyright 2001-2003 Adrian Thurston <adriant@ragel.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _FSMDUMP_H
#define _FSMDUMP_H

#include <iostream>

/* Forwards. */
struct ParseData;

class FsmDump
{
public:
	FsmDump( char *fsmName, ParseData *parseData, FsmAp *graph, std::ostream &out );

	/* Print an fsm to out stream. */
	void dumpGraph( );

private:
	void dumpFsmKey( int onChar );
	void dumpTransData( TransAp *trans );
	void dumpTrans( TransAp *trans );
	void dumpDefTrans( TransAp *trans );
	void dumpTransList( const TransList &list );
	void dumpState( StateAp *state );

	char *fsmName;
	ParseData *parseData;
	FsmAp *graph;
	std::ostream &out;
};


#endif /* _FSMDUMP */
