/****************************************************************************
** $Id: qg_actionfactory.cpp,v 1.60 2004/07/25 20:09:08 andrew Exp $
**
** Copyright (C) 2001-2003 RibbonSoft. All rights reserved.
**
** This file is part of the qcadlib Library project.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid qcadlib Professional Edition licenses may use 
** this file in accordance with the qcadlib Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.ribbonsoft.com for further details.
**
** Contact info@ribbonsoft.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "qg_actionfactory.h"

#include <qobject.h>

#include "rs_actionblockscreate.h"
#include "rs_actionblocksfreezeall.h"
#include "rs_actionblocksadd.h"
#include "rs_actionblocksremove.h"
#include "rs_actionblocksattributes.h"
#include "rs_actionblocksedit.h"
#include "rs_actionblocksinsert.h"
#include "rs_actionblockstoggleview.h"
#include "rs_actionblocksexplode.h"
#include "rs_actiondimaligned.h"
#include "rs_actiondimangular.h"
#include "rs_actiondimdiametric.h"
#include "rs_actiondimleader.h"
#include "rs_actiondimlinear.h"
#include "rs_actiondimradial.h"
#include "rs_actiondrawarc.h"
#include "rs_actiondrawarc3p.h"
#include "rs_actiondrawcircle.h"
#include "rs_actiondrawcircle2p.h"
#include "rs_actiondrawcircle3p.h"
#include "rs_actiondrawcirclecr.h"
#include "rs_actiondrawellipseaxis.h"
#include "rs_actiondrawhatch.h"
#include "rs_actiondrawimage.h"
#include "rs_actiondrawline.h"
#include "rs_actiondrawlineangle.h"
#include "rs_actiondrawlinebisector.h"
#include "rs_actiondrawlinefree.h"
#include "rs_actiondrawlinehorvert.h"
#include "rs_actiondrawlineparallel.h"
#include "rs_actiondrawlineparallelthrough.h"
#include "rs_actiondrawlinepolyline.h"
#include "rs_actiondrawlinepolygon.h"
#include "rs_actiondrawlinepolygon2.h"
#include "rs_actiondrawlinerectangle.h"
#include "rs_actiondrawlinerelangle.h"
#include "rs_actiondrawlinetangent1.h"
#include "rs_actiondrawlinetangent2.h"
#include "rs_actiondrawpoint.h"
#include "rs_actiondrawspline.h"
#include "rs_actiondrawtext.h"
#include "rs_actioneditcopy.h"
#include "rs_actioneditpaste.h"
#include "rs_actioneditundo.h"
#include "rs_actionfilenew.h"
#include "rs_actionfileopen.h"
#include "rs_actionfilesave.h"
#include "rs_actionfilesaveas.h"
#include "rs_actioninfoangle.h"
#include "rs_actioninfodist.h"
#include "rs_actioninfodist2.h"
#include "rs_actioninfoinside.h"
#include "rs_actioninfototallength.h"
#include "rs_actionlayersadd.h"
#include "rs_actionlayersfreezeall.h"
#include "rs_actionlayersremove.h"
#include "rs_actionlayerstogglelock.h"
#include "rs_actionlayerstoggleview.h"
#include "rs_actionlockrelativezero.h"
#include "rs_actionmodifyattributes.h"
#include "rs_actionmodifybevel.h"
#include "rs_actionmodifymirror.h"
#include "rs_actionmodifycut.h"
#include "rs_actionmodifydelete.h"
#include "rs_actionmodifydeletefree.h"
#include "rs_actionmodifydeletequick.h"
#include "rs_actionmodifyentity.h"
#include "rs_actionmodifymove.h"
#include "rs_actionmodifymoverotate.h"
#include "rs_actionmodifyrotate.h"
#include "rs_actionmodifyround.h"
#include "rs_actionmodifyscale.h"
#include "rs_actionmodifystretch.h"
#include "rs_actionmodifytrim.h"
#include "rs_actionmodifytrimamount.h"
#include "rs_actionmodifyexplodetext.h"
#include "rs_actionoptionsdrawing.h"
#include "rs_actionprintpreview.h"
#include "rs_actionselectall.h"
#include "rs_actionselectintersected.h"
#include "rs_actionselectinvert.h"
#include "rs_actionselectlayer.h"
#include "rs_actionselectsingle.h"
#include "rs_actionselectcontour.h"
#include "rs_actionselectwindow.h"
#include "rs_actionsetrelativezero.h"
#include "rs_actionsnapintersectionmanual.h"
#include "rs_actiontoolregeneratedimensions.h"
#include "rs_actionzoomauto.h"
#include "rs_actionzoomprevious.h"
#include "rs_actionzoomin.h"
#include "rs_actionzoompan.h"
#include "rs_actionzoomredraw.h"
#include "rs_actionzoomwindow.h"

#ifdef RS_CAM
#include "rs_actioncamexportauto.h"
#include "rs_actioncamreorder.h"
#endif

/**
 * Constructor.
 *
 * @param ah Action handler which provides the slots.
 * @param w Widget through which the events come in.
 */
QG_ActionFactory::QG_ActionFactory(QG_ActionHandler* ah, QWidget* w) {
    actionHandler = ah;
    widget = w;
}



/**
 * Destructor
 */
QG_ActionFactory::~QG_ActionFactory() {}



/**
 * Creates a new action object and links it to the appropriate slot(s).
 *
 * @param id ID of the action to create (see rs.h).
 * @param obj Object which the action will connect its signal to.
 *
 * @return Pointer to the action object or NULL if the action is unknown.
 */
QAction* QG_ActionFactory::createAction(RS2::ActionType id, QObject* obj) {
    // assert that action handler is not invalid:
    if (actionHandler==NULL) {
        std::cerr << "No valid action handler available to create action "
        << id << "\n";
        return NULL;
    }

    QWidget* mw = widget;
    QAction* action = NULL;
    QPixmap icon;

    if (mw==NULL) {
        std::cerr << "No valid main window available to create action "
        << id << "\n";
        return NULL;
    }

    // create requested action
    switch (id) {

        // File actions:
        //
    case RS2::ActionFileNew:
		action = RS_ActionFileNew::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotFileNew()));
        break;

    case RS2::ActionFileOpen:
		action = RS_ActionFileOpen::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotFileOpen()));
        break;

    case RS2::ActionFileSave:
		action = RS_ActionFileSave::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotFileSave()));
        break;

    case RS2::ActionFileSaveAs:
		action = RS_ActionFileSaveAs::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotFileSaveAs()));
        break;

    case RS2::ActionFileExport:
        action = new QAction(tr("Export Drawing"), tr("&Export..."),
                             0, mw);
        action->setStatusTip(tr("Exports the current drawing as bitmap"));
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotFileExport()));
        break;

    case RS2::ActionFileClose:
        action = new QAction(tr("Close Drawing"), QPixmap::fromMimeSource("fileclose.png"), tr("&Close"),
                             CTRL+Key_W, mw);
        action->setStatusTip(tr("Closes the current drawing"));
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotFileClose()));
        break;

    case RS2::ActionFilePrint:
        icon = QPixmap::fromMimeSource("fileprint.png");
        action = new QAction(tr("Print Drawing"), icon, tr("&Print..."),
                             CTRL+Key_P, mw);
        action->setStatusTip(tr("Prints out the current drawing"));
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotFilePrint()));
        break;

    case RS2::ActionFilePrintPreview:
		action = RS_ActionPrintPreview::createGUIAction(id, mw);
		action->setToggleAction(true);
        connect(action, SIGNAL(toggled(bool)),
                obj, SLOT(slotFilePrintPreview(bool)));
        break;

    case RS2::ActionFileQuit:
        action = new QAction(tr("Quit"), QPixmap::fromMimeSource("exit.png"), 
							tr("&Quit"),
                             CTRL+Key_Q, mw);
        action->setStatusTip(tr("Quits the application"));
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotFileQuit()));
        break;

        // Viewing actions:
        //
    case RS2::ActionViewGrid:
        icon = QPixmap::fromMimeSource("viewgrid.png");
        action = new QAction(tr("Grid"), icon, tr("&Grid"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Enables/disables the grid"));
        connect(action, SIGNAL(toggled(bool)),
                obj, SLOT(slotViewGrid(bool)));
        break;
    case RS2::ActionViewDraft:
        icon = QPixmap::fromMimeSource("viewdraft.png");
        action = new QAction(tr("Draft"), icon, tr("&Draft"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Enables/disables the draft mode"));
        connect(action, SIGNAL(toggled(bool)),
                obj, SLOT(slotViewDraft(bool)));
        break;
    case RS2::ActionViewStatusBar:
        action = new QAction(tr("Statusbar"), tr("&Statusbar"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Enables/disables the statusbar"));
        connect(action, SIGNAL(toggled(bool)),
                obj, SLOT(slotViewStatusBar(bool)));
        break;
        /*
                   case RS2::ActionViewLayerList:
                       action = new QAction(tr("Layer List"), tr("&Layer List"),
                                            0, mw, 0, true);
                       action->setStatusTip(tr("Enables/disables the layerlist"));
                       connect(action, SIGNAL(toggled(bool)),
                               obj, SLOT(slotViewLayerList(bool)));
                       break;
         
                   case RS2::ActionViewBlockList:
                       action = new QAction(tr("Block List"), tr("&Block List"),
                                            0, mw, 0, true);
                       action->setStatusTip(tr("Enables/disables the blocklist"));
                       connect(action, SIGNAL(toggled(bool)),
                               obj, SLOT(slotViewBlockList(bool)));
                       break;
         
                   case RS2::ActionViewCommandLine:
                       action = new QAction(tr("Command Widget"), tr("&Command Widget"),
                                            0, mw, 0, true);
                       action->setStatusTip(tr("Enables/disables the command widget"));
                       connect(action, SIGNAL(toggled(bool)),
                               obj, SLOT(slotViewCommandLine(bool)));
                       break;
         
                   case RS2::ActionViewOptionToolbar:
                       action = new QAction(tr("Option Toolbar"), tr("&Option Toolbar"),
                                            0, mw, 0, true);
                       action->setStatusTip(tr("Enables/disables the option toolbar"));
                       connect(action, SIGNAL(toggled(bool)),
                               obj, SLOT(slotViewOptionToolbar(bool)));
                       break;
                	*/

        // Tools:
        //
    case RS2::ActionToolRegenerateDimensions:
		action = RS_ActionToolRegenerateDimensions::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotToolRegenerateDimensions()));
        break;

        // Zooming actions:
        //
    case RS2::ActionZoomIn:
		action = RS_ActionZoomIn::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Zoom in"), QPixmap(zoomin_xpm),
                             tr("Zoom &In"), 0, mw);
        action->setStatusTip(tr("Zooms in"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotZoomIn()));
        break;

    case RS2::ActionZoomOut:
		action = RS_ActionZoomIn::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Zoom out"), icon,
                             tr("Zoom &Out"), 0, mw);
        action->setStatusTip(tr("Zooms out"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotZoomOut()));
        break;

    case RS2::ActionZoomAuto:
		action = RS_ActionZoomAuto::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Auto Zoom"), QPixmap(zoomauto_xpm),
                             tr("&Auto Zoom"), 0, mw);
        action->setStatusTip(tr("Zooms automatic"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotZoomAuto()));
        break;

    case RS2::ActionZoomWindow:
		action = RS_ActionZoomWindow::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Window Zoom"), QPixmap(zoomwindow_xpm),
                             tr("&Window Zoom"), 0, mw);
        action->setStatusTip(tr("Zooms in a window"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotZoomWindow()));
        break;

    case RS2::ActionZoomPan:
		action = RS_ActionZoomPan::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Pan Zoom"), QPixmap(zoompan_xpm),
                             tr("&Pan Zoom"), 0, mw);
        action->setStatusTip(tr("Realtime Panning"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotZoomPan()));
        break;
    
	case RS2::ActionZoomPrevious:
		action = RS_ActionZoomPrevious::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotZoomPrevious()));
        break;

    case RS2::ActionZoomRedraw:
		action = RS_ActionZoomRedraw::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Redraw"), QPixmap(zoomredraw_xpm),
                             tr("&Redraw"), 0, mw);
        action->setStatusTip(tr("Redraw"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotZoomRedraw()));
        break;

        // Editing actions:
        //
    case RS2::ActionEditUndo:
		action = RS_ActionEditUndo::createGUIAction(id, mw);
		/*
        icon = QPixmap(editundo_xpm);
        action = new QAction(tr("Undo"), icon, tr("&Undo"),
                             CTRL+Key_Z, mw);
        action->setStatusTip(tr("Undoes last action"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotEditUndo()));
        break;

    case RS2::ActionEditRedo:
		action = RS_ActionEditUndo::createGUIAction(id, mw);
		/*
        icon = QPixmap(editredo_xpm);
        action = new QAction(tr("Redo"), icon, tr("&Redo"),
                             CTRL+SHIFT+Key_Z, mw);
        action->setStatusTip(tr("Redoes last action"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotEditRedo()));
        break;

    case RS2::ActionEditCut:
		action = RS_ActionEditCopy::createGUIAction(id, mw);
		/*
        icon = QPixmap(editcut_xpm);
        action = new QAction(tr("Cut"), icon, tr("Cu&t"),
                             CTRL+Key_X, mw);
        action->setStatusTip(tr("Cuts entities "
                                " to the clipboard"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotEditCut()));
        break;

    case RS2::ActionEditCopy:
		action = RS_ActionEditCopy::createGUIAction(id, mw);
		/*
        icon = QPixmap(editcopy_xpm);
        action = new QAction(tr("Copy"), icon, tr("&Copy"),
                             CTRL+Key_C, mw);
        action->setStatusTip(tr("Copies entities"
                                " to the clipboard"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotEditCopy()));
        break;

    case RS2::ActionEditPaste:
		action = RS_ActionEditPaste::createGUIAction(id, mw);
		/*
        icon = QPixmap(editpaste_xpm);
        action = new QAction(tr("Paste"), icon, tr("&Paste"),
                             CTRL+Key_V, mw);
        action->setStatusTip(tr("Pastes the clipboard contents"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotEditPaste()));
        break;

        // Selecting actions:
        //
    case RS2::ActionSelectSingle:
		action = RS_ActionSelectSingle::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Select Entity"), tr("(De-)&Select Entity"),
                             0, mw);
        action->setStatusTip(tr("Selects single Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSelectSingle()));
        break;

    case RS2::ActionSelectWindow:
		action = RS_ActionSelectWindow::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Select Window"), tr("Select &Window"),
                             0, mw);
        action->setStatusTip(tr("Selects all Entities in a given Window"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSelectWindow()));
        break;

    case RS2::ActionDeselectWindow:
		action = RS_ActionSelectWindow::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Deselect Window"), tr("Deselect &Window"),
                             0, mw);
        action->setStatusTip(tr("Deselects all Entities" " in a given Window"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDeselectWindow()));
        break;

    case RS2::ActionSelectContour:
		action = RS_ActionSelectContour::createGUIAction(id, mw);
		/*
        action = new QAction(tr("(De-)Select Contour"), tr("(De-)Select &Contour"),
                             0, mw);
        action->setStatusTip(tr("(De-)Selects connected entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSelectContour()));
        break;

    case RS2::ActionSelectAll:
		action = RS_ActionSelectAll::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Select All"), tr("Select &All"),
                             CTRL+Key_A, mw);
        action->setStatusTip(tr("Selects all Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSelectAll()));
        break;

    case RS2::ActionDeselectAll:
		action = RS_ActionSelectAll::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Deselect all"), tr("Deselect &all"),
                             CTRL+Key_K, mw);
        action->setStatusTip(tr("Deselects all Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDeselectAll()));
        break;

    case RS2::ActionSelectInvert:
		action = RS_ActionSelectInvert::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Invert Selection"), tr("&Invert Selection"),
                             0, mw);
        action->setStatusTip(tr("Inverts the current selection"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSelectInvert()));
        break;

    case RS2::ActionSelectIntersected:
		action = RS_ActionSelectIntersected::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Select Intersected Entities"), tr("In&tersected Entities"),
                             0, mw);
        action->setStatusTip(tr("Selects all entities intersected by a line"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSelectIntersected()));
        break;

    case RS2::ActionDeselectIntersected:
		action = RS_ActionSelectIntersected::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Deselect Intersected Entities"), tr("Deselect Inte&rsected Entities"),
                             0, mw);
        action->setStatusTip(tr("Deselects all entities intersected by a line"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDeselectIntersected()));
        break;

    case RS2::ActionSelectLayer:
		action = RS_ActionSelectLayer::createGUIAction(id, mw);
		/*
        action = new QAction(tr("(De-)Select Layer"), tr("(De-)Select Layer"),
                             0, mw);
        action->setStatusTip(tr("(De-)Selects layers"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSelectLayer()));
        break;

        // Drawing actions:
        //
    case RS2::ActionDrawPoint:
		action = RS_ActionDrawPoint::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Points"), tr("&Points"),
                             0, mw);
        action->setStatusTip(tr("Draw Points"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawPoint()));
        break;

    case RS2::ActionDrawLine:
		action = RS_ActionDrawLine::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Line: 2 Points"), tr("&2 Points"),
                             0, mw);
        action->setStatusTip(tr("Draw lines"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLine()));
        break;

    case RS2::ActionDrawLineAngle:
		action = RS_ActionDrawLineAngle::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Line: Angle"), tr("&Angle"),
                             0, mw);
        action->setStatusTip(tr("Draw lines with a given angle"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineAngle()));
        break;

    case RS2::ActionDrawLineHorizontal:
		action = RS_ActionDrawLineAngle::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Line: Horizontal"), tr("&Horizontal"),
                             0, mw);
        action->setStatusTip(tr("Draw horizontal lines"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineHorizontal()));
        break;

    case RS2::ActionDrawLineHorVert:
		action = RS_ActionDrawLineHorVert::createGUIAction(id, mw);
		/*
        action = new QAction(tr("hor./vert. line"), tr("H&orizontal / Vertical"),
                             0, mw);
        action->setStatusTip(tr("Draw horizontal/vertical lines"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineHorVert()));
        break;

    case RS2::ActionDrawLineVertical:
		action = RS_ActionDrawLineAngle::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Line: Vertical"), tr("&Vertical"),
                             0, mw);
        action->setStatusTip(tr("Draw vertical lines"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineVertical()));
        break;

    case RS2::ActionDrawLineFree:
		action = RS_ActionDrawLineFree::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Line: Freehand"), tr("&Freehand Line"),
                             0, mw);
        action->setStatusTip(tr("Draw freehand lines"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineFree()));
        break;

    case RS2::ActionDrawLineParallel:
		action = RS_ActionDrawLineParallel::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Parallel"), tr("Para&llel"),
                             0, mw);
        action->setStatusTip(tr("Draw parallels to existing lines, arcs, "
                                "circles"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineParallel()));
        break;

    case RS2::ActionDrawLineParallelThrough:
		action = RS_ActionDrawLineParallelThrough::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Parallel through point"),
                             tr("Par&allel through point"),
                             0, mw);
        action->setStatusTip(tr("Draw parallel through a given point"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineParallelThrough()));
        break;

    case RS2::ActionDrawLineRectangle:
		action = RS_ActionDrawLineRectangle::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Rectangle"), tr("&Rectangle"),
                             0, mw);
        action->setStatusTip(tr("Draw rectangles"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineRectangle()));
        break;

    case RS2::ActionDrawLineBisector:
		action = RS_ActionDrawLineBisector::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Bisector"), tr("&Bisector"),
                             0, mw);
        action->setStatusTip(tr("Draw bisectors"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineBisector()));
        break;

    case RS2::ActionDrawLineTangent1:
		action = RS_ActionDrawLineTangent1::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Tangent (P,C)"), tr("&Tangent (P,C)"),
                             0, mw);
        action->setStatusTip(tr("Draw tangent (point, circle)"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineTangent1()));
        break;

    case RS2::ActionDrawLineTangent2:
		action = RS_ActionDrawLineTangent2::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Tangent (C,C)"), tr("Tan&gent (C,C)"),
                             0, mw);
        action->setStatusTip(tr("Draw tangent (circle, circle)"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineTangent2()));
        break;

    case RS2::ActionDrawLineOrthogonal:
		action = RS_ActionDrawLineRelAngle::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Orthogonal"), tr("&Orthogonal"),
                             0, mw);
        action->setStatusTip(tr("Draw orthogonal line"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineOrthogonal()));
        break;

    case RS2::ActionDrawLineRelAngle:
		action = RS_ActionDrawLineRelAngle::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Relative angle"), tr("R&elative angle"),
                             0, mw);
        action->setStatusTip(tr("Draw line with relative angle"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLineRelAngle()));
        break;

    case RS2::ActionDrawLinePolyline:
		action = RS_ActionDrawLinePolyline::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLinePolyline()));
        break;
		
    case RS2::ActionDrawLinePolygon:
		action = RS_ActionDrawLinePolygon::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Polygon"), tr("Pol&ygon (Cen,Cor)"),
                             0, mw);
        action->setStatusTip(tr("Draw polygon with center and corner"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLinePolygon()));
        break;

    case RS2::ActionDrawLinePolygon2:
		action = RS_ActionDrawLinePolygon::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Polygon"), tr("Polygo&n (Cor,Cor)"),
                             0, mw);
        action->setStatusTip(tr("Draw polygon with two corners"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawLinePolygon2()));
        break;

    case RS2::ActionDrawCircle:
		action = RS_ActionDrawCircle::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Circle: Center, Point"),
                             tr("Center, &Point"),
                             0, mw);
        action->setStatusTip(tr("Draw circles with center and point"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawCircle()));
        break;

    case RS2::ActionDrawCircleCR:
		action = RS_ActionDrawCircleCR::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Circle: Center, Radius"),
                             tr("Center, &Radius"),
                             0, mw);
        action->setStatusTip(tr("Draw circles with center and radius"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawCircleCR()));
        break;

    case RS2::ActionDrawCircle2P:
		action = RS_ActionDrawCircle2P::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Circle: 2 Points"), tr("2 Points"),
                             0, mw);
        action->setStatusTip(tr("Draw circles with 2 points"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawCircle2P()));
        break;

    case RS2::ActionDrawCircle3P:
		action = RS_ActionDrawCircle3P::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Circle: 3 Points"), tr("3 Points"),
                             0, mw);
        action->setStatusTip(tr("Draw circles with 3 points"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawCircle3P()));
        break;

    case RS2::ActionDrawCircleParallel:
		action = RS_ActionDrawLineParallel::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Circle: Concentric"),
                             tr("&Concentric"),
                             0, mw);
        action->setStatusTip(tr("Draw circles concentric to existing circles"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawCircleParallel()));
        break;

    case RS2::ActionDrawArc:
        /*action = new QAction(tr("Arc: Center, Point, Angles"),
                             tr("&Center, Point, Angles"),
                             0, mw);
        action->setStatusTip(tr("Draw arcs"));*/
		action = RS_ActionDrawArc::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawArc()));
        break;

    case RS2::ActionDrawArc3P:
		action = RS_ActionDrawArc3P::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Arc: 3 Points"),
                             tr("&3 Points"),
                             0, mw);
        action->setStatusTip(tr("Draw arcs with 3 points"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawArc3P()));
        break;

    case RS2::ActionDrawArcParallel:
		action = RS_ActionDrawLineParallel::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Arc: Concentric"),
                             tr("&Concentric"),
                             0, mw);
        action->setStatusTip(tr("Draw arcs concentric to existing arcs"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawArcParallel()));
        break;

    case RS2::ActionDrawEllipseAxis:
		action = RS_ActionDrawEllipseAxis::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Ellipse with Axis"),
                             tr("&Ellipse (Axis)"), 0, mw);
        action->setStatusTip(tr("Draw Ellipses"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawEllipseAxis()));
        break;

    case RS2::ActionDrawEllipseArcAxis:
		action = RS_ActionDrawEllipseAxis::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Ellipse Arc with Axis"),
                             tr("&Ellipse Arc (Axis)"), 0, mw);
        action->setStatusTip(tr("Draw Ellipse Arcs"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawEllipseArcAxis()));
        break;
		
    case RS2::ActionDrawSpline:
		action = RS_ActionDrawSpline::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawSpline()));
        break;

    case RS2::ActionDrawText:
		action = RS_ActionDrawText::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Text"), tr("&Text"),
                             0, mw);
        action->setStatusTip(tr("Draw Text Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawText()));
        break;

    case RS2::ActionDrawHatch:
		action = RS_ActionDrawHatch::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Hatch"), tr("&Hatch"),
                             0, mw);
        action->setStatusTip(tr("Draw Hatches and Solid Fills"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawHatch()));
        break;

    case RS2::ActionDrawImage:
		action = RS_ActionDrawImage::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Image"), tr("&Image"),
                             0, mw);
        action->setStatusTip(tr("Insert Image (Bitmap)"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDrawImage()));
        break;

        // Dimensioning actions:
        //
    case RS2::ActionDimAligned:
		action = RS_ActionDimAligned::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Aligned"), tr("&Aligned"),
                             0, mw);
        action->setStatusTip(tr("Aligned Dimension"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDimAligned()));
        break;

    case RS2::ActionDimLinear:
		action = RS_ActionDimLinear::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Linear"), tr("&Linear"),
                             0, mw);
        action->setStatusTip(tr("Linear Dimension"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDimLinear()));
        break;

    case RS2::ActionDimLinearHor:
		action = RS_ActionDimLinear::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Horizontal"), tr("&Horizontal"),
                             0, mw);
        action->setStatusTip(tr("Horizontal Dimension"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDimLinearHor()));
        break;

    case RS2::ActionDimLinearVer:
		action = RS_ActionDimLinear::createGUIAction(id, mw);
		
		/*
        action = new QAction(tr("Vertical"), tr("&Vertical"),
                             0, mw);
        action->setStatusTip(tr("Vertical Dimension"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDimLinearVer()));
        break;

    case RS2::ActionDimRadial:
		action = RS_ActionDimRadial::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Radial"), tr("&Radial"),
                             0, mw);
        action->setStatusTip(tr("Radial Dimension"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDimRadial()));
        break;

    case RS2::ActionDimDiametric:
		action = RS_ActionDimDiametric::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Diametric"), tr("&Diametric"),
                             0, mw);
        action->setStatusTip(tr("Diametric Dimension"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDimDiametric()));
        break;

    case RS2::ActionDimAngular:
		action = RS_ActionDimAngular::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Angular"), tr("&Angular"),
                             0, mw);
        action->setStatusTip(tr("Angular Dimension"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDimAngular()));
        break;

    case RS2::ActionDimLeader:
		action = RS_ActionDimLeader::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Leader"), tr("&Leader"),
                             0, mw);
        action->setStatusTip(tr("Leader Dimension"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotDimLeader()));
        break;

        // Modifying actions:
        //
    case RS2::ActionModifyAttributes:
		action = RS_ActionModifyAttributes::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Attributes"), tr("&Attributes"),
                             0, mw);
        action->setStatusTip(tr("Modify Entity Attributes"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyAttributes()));
        break;
    case RS2::ActionModifyDelete:
		action = RS_ActionModifyDelete::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Delete"), tr("&Delete"),
                             0, mw);
        action->setStatusTip(tr("Delete Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyDelete()));
        break;

    case RS2::ActionModifyDeleteQuick:
		action = RS_ActionModifyDeleteQuick::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Delete selected"), tr("&Delete selected"),
                             Key_Delete, mw);
        action->setStatusTip(tr("Delete selected entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyDeleteQuick()));
        break;

    case RS2::ActionModifyDeleteFree:
		action = RS_ActionModifyDeleteFree::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Delete Freehand"), tr("&Delete Freehand"),
                             0, mw);
        action->setStatusTip(tr("Delete Freehand"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyDeleteFree()));
        break;

    case RS2::ActionModifyMove:
		action = RS_ActionModifyMove::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Move"), tr("&Move"),
                             0, mw);
        action->setStatusTip(tr("Move Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyMove()));
        break;

    case RS2::ActionModifyRotate:
		action = RS_ActionModifyRotate::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Rotate"), tr("&Rotate"),
                             0, mw);
        action->setStatusTip(tr("Rotate Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyRotate()));
        break;

    case RS2::ActionModifyScale:
		action = RS_ActionModifyScale::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Scale"), tr("&Scale"),
                             0, mw);
        action->setStatusTip(tr("Scale Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyScale()));
        break;

    case RS2::ActionModifyMirror:
		action = RS_ActionModifyMirror::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Mirror"), tr("&Mirror"),
                             0, mw);
        action->setStatusTip(tr("Mirror Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyMirror()));
        break;

    case RS2::ActionModifyMoveRotate:
		action = RS_ActionModifyMoveRotate::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Move and Rotate"), tr("M&ove and Rotate"),
                             0, mw);
        action->setStatusTip(tr("Move and Rotate Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyMoveRotate()));
        break;

    case RS2::ActionModifyRotate2:
		action = RS_ActionModifyRotate::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Rotate Two"), tr("Rotate T&wo"),
                             0, mw);
        action->setStatusTip(tr("Rotate Entities around two centers"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyRotate2()));
        break;

    case RS2::ActionModifyEntity:
		action = RS_ActionModifyEntity::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Properties"), tr("&Properties"),
                             0, mw);
        action->setStatusTip(tr("Modify Entity Properties"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyEntity()));
        break;

    case RS2::ActionModifyTrim:
		action = RS_ActionModifyTrim::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Trim"), tr("&Trim"),
                             0, mw);
        action->setStatusTip(tr("Trim Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyTrim()));
        break;

    case RS2::ActionModifyTrim2:
		action = RS_ActionModifyTrim::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Trim Two"), tr("&Trim Two"),
                             0, mw);
        action->setStatusTip(tr("Trim two Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyTrim2()));
        break;

    case RS2::ActionModifyTrimAmount:
		action = RS_ActionModifyTrimAmount::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Lengthen"), tr("&Lengthen"),
                             0, mw);
        action->setStatusTip(tr("Lengthen by a given amount"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyTrimAmount()));
        break;

    case RS2::ActionModifyCut:
		action = RS_ActionModifyCut::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Cut"), tr("&Cut"),
                             0, mw);
        action->setStatusTip(tr("Cut Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyCut()));
        break;

    case RS2::ActionModifyStretch:
		action = RS_ActionModifyStretch::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Stretch"), tr("&Stretch"),
                             0, mw);
        action->setStatusTip(tr("Stretch Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyStretch()));
        break;

    case RS2::ActionModifyBevel:
		action = RS_ActionModifyBevel::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Bevel"), tr("&Bevel"),
                             0, mw);
        action->setStatusTip(tr("Bevel Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyBevel()));
        break;

    case RS2::ActionModifyRound:
		action = RS_ActionModifyRound::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Round"), tr("&Round"),
                             0, mw);
        action->setStatusTip(tr("Round Entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyRound()));
        break;

    case RS2::ActionModifyExplodeText:
		action = RS_ActionModifyExplodeText::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotModifyExplodeText()));
        break;

        // Snapping actions:
        //
    case RS2::ActionSnapFree:
        action = new QAction(tr("Free"), tr("&Free"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Free positioning"));
        actionHandler->setActionSnapFree(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSnapFree()));
        break;

    case RS2::ActionSnapGrid:
        action = new QAction(tr("Grid"), tr("&Grid"),
                             0, mw, "snapGrid", true);
        action->setStatusTip(tr("Grid positioning"));
        actionHandler->setActionSnapGrid(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSnapGrid()));
        break;

    case RS2::ActionSnapEndpoint:
        action = new QAction(tr("Endpoints"), tr("&Endpoints"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Snap to endpoints"));
        actionHandler->setActionSnapEndpoint(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSnapEndpoint()));
        break;

    case RS2::ActionSnapOnEntity:
        action = new QAction(tr("On Entity"), tr("&On Entity"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Snap to nearest point on entity"));
        actionHandler->setActionSnapOnEntity(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSnapOnEntity()));
        break;

    case RS2::ActionSnapCenter:
        action = new QAction(tr("Center"), tr("&Center"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Snap to centers"));
        actionHandler->setActionSnapCenter(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSnapCenter()));
        break;

    case RS2::ActionSnapMiddle:
        action = new QAction(tr("Middle"), tr("&Middle"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Snap to middle points"));
        actionHandler->setActionSnapMiddle(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSnapMiddle()));
        break;

    case RS2::ActionSnapDist:
        action = new QAction(tr("Distance from Endpoint"),
                             tr("&Distance from Endpoint"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Snap to points with a given"
                                " distance to an endpoint"));
        actionHandler->setActionSnapDist(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSnapDist()));
        break;

    case RS2::ActionSnapIntersection:
        action = new QAction(tr("Intersection"), tr("&Intersection"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Snap to intersection points"));
        actionHandler->setActionSnapIntersection(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSnapIntersection()));
        break;

    case RS2::ActionSnapIntersectionManual:
		action = RS_ActionSnapIntersectionManual::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Intersection Manually"), tr("I&ntersection Manually"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Snap to intersection points manually"));
		*/
        actionHandler->setActionSnapIntersectionManual(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSnapIntersectionManual()));
        break;

        // Snap restriction actions:
        //
    case RS2::ActionRestrictNothing:
        action = new QAction(tr("Restrict Nothing"), tr("Restrict &Nothing"),
                             0, mw, 0, true);
        action->setStatusTip(tr("No snap restriction"));
        actionHandler->setActionRestrictNothing(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotRestrictNothing()));
        break;

    case RS2::ActionRestrictOrthogonal:
        action = new QAction(tr("Restrict Orthogonally"),
                             tr("Restrict &Orthogonally"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Restrict snapping orthogonally"));
        actionHandler->setActionRestrictOrthogonal(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotRestrictOrthogonal()));
        break;

    case RS2::ActionRestrictHorizontal:
        action = new QAction(tr("Restrict Horizontally"),
                             tr("Restrict &Horizontally"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Restrict snapping horizontally"));
        actionHandler->setActionRestrictHorizontal(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotRestrictHorizontal()));
        break;

    case RS2::ActionRestrictVertical:
        action = new QAction(tr("Restrict Vertically"),
                             tr("Restrict &Vertically"),
                             0, mw, 0, true);
        action->setStatusTip(tr("Restrict snapping vertically"));
        actionHandler->setActionRestrictVertical(action);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotRestrictVertical()));
        break;

        // Relative zero point
        //
    case RS2::ActionSetRelativeZero:
		action = RS_ActionSetRelativeZero::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Set Relative Zero"), tr("&Set Relative Zero"),
                             0, mw);
        action->setStatusTip(tr("Set position of the Relative Zero point"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotSetRelativeZero()));
        break;
    case RS2::ActionLockRelativeZero:
		action = RS_ActionLockRelativeZero::createGUIAction(id, mw);
		/*
        action = new QAction(tr("(Un-)Lock Relative Zero"),
                             tr("(Un-)&Lock Relative Zero"),
                             0, mw, 0, true);
        action->setStatusTip(tr("(Un-)Lock relative Zero"));
		*/
        actionHandler->setActionLockRelativeZero(action);
        connect(action, SIGNAL(toggled(bool)),
                obj, SLOT(slotLockRelativeZero(bool)));
        break;

        // Info actions:
        //
    case RS2::ActionInfoInside:
		action = RS_ActionInfoInside::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Point inside contour"),
                             tr("&Point inside contour"),
                             0, mw);
        action->setStatusTip(tr("Checks if a given point is inside the "
                                "selected contour"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotInfoInside()));
        break;

    case RS2::ActionInfoDist:
		action = RS_ActionInfoDist::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Distance Point to Point"),
                             tr("&Distance Point to Point"),
                             0, mw);
        action->setStatusTip(tr("Measures the distance between two points"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotInfoDist()));
        break;

    case RS2::ActionInfoDist2:
		action = RS_ActionInfoDist2::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Distance Entity to Point"),
                             tr("&Distance Entity to Point"),
                             0, mw);
        action->setStatusTip(tr("Measures the distance between an "
                                "entity and a point"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotInfoDist2()));
        break;

    case RS2::ActionInfoAngle:
		action = RS_ActionInfoAngle::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Angle between two lines"),
                             tr("&Angle between two lines"),
                             0, mw);
        action->setStatusTip(tr("Measures the angle between two lines"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotInfoAngle()));
        break;
		
    case RS2::ActionInfoTotalLength:
		action = RS_ActionInfoTotalLength::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Total length of selected entities"),
                             tr("&Total length of selected entities"),
                             0, mw);
        action->setStatusTip(tr("Measures the total length of all "
  				"selected entities"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotInfoTotalLength()));
        break;

        // Layer actions:
        //
    case RS2::ActionLayersDefreezeAll:
		action = RS_ActionLayersFreezeAll::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Defreeze all"), tr("&Defreeze all"),
                             0, mw);
        action->setStatusTip(tr("Defreeze all layers"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotLayersDefreezeAll()));
        break;
    case RS2::ActionLayersFreezeAll:
		action = RS_ActionLayersFreezeAll::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Freeze all"), tr("&Freeze all"),
                             0, mw);
        action->setStatusTip(tr("Freeze all layers"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotLayersFreezeAll()));
        break;
    case RS2::ActionLayersAdd:
		action = RS_ActionLayersAdd::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Add Layer"), tr("&Add Layer"),
                             0, mw);
        action->setStatusTip(tr("Add Layer"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotLayersAdd()));
        break;

    case RS2::ActionLayersRemove:
		action = RS_ActionLayersRemove::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Remove Layer"), tr("&Remove Layer"),
                             0, mw);
        action->setStatusTip(tr("Remove Layer"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotLayersRemove()));
        break;

    case RS2::ActionLayersEdit:
		action = RS_ActionLayersAdd::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Edit Layer"), tr("&Edit Layer"),
                             0, mw);
        action->setStatusTip(tr("Edit Layer"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotLayersEdit()));
        break;
		
    case RS2::ActionLayersToggleLock:
		action = RS_ActionLayersToggleLock::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Toggle Layer Lock"),
                             tr("&Toggle Lock"),
                             0, mw);
        action->setStatusTip(tr("Toggle Lock"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotLayersToggleView()));
        break;

    case RS2::ActionLayersToggleView:
		action = RS_ActionLayersToggleView::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Toggle Layer Visibility"),
                             tr("&Toggle Layer"),
                             0, mw);
        action->setStatusTip(tr("Toggle Layer"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotLayersToggleView()));
        break;

        // Block actions:
        //
    case RS2::ActionBlocksDefreezeAll:
		action = RS_ActionBlocksFreezeAll::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Defreeze all"), tr("&Defreeze all"),
                             0, mw);
        action->setStatusTip(tr("Defreeze all blocks"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotBlocksDefreezeAll()));
        break;
    case RS2::ActionBlocksFreezeAll:
		action = RS_ActionBlocksFreezeAll::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Freeze all"), tr("&Freeze all"),
                             0, mw);
        action->setStatusTip(tr("Freeze all blocks"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotBlocksFreezeAll()));
        break;
    case RS2::ActionBlocksAdd:
		action = RS_ActionBlocksAdd::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Add Block"), tr("&Add Block"),
                             0, mw);
        action->setStatusTip(tr("Add Block"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotBlocksAdd()));
        break;
    case RS2::ActionBlocksRemove:
		action = RS_ActionBlocksRemove::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Remove Block"), tr("&Remove Block"),
                             0, mw);
        action->setStatusTip(tr("Remove Block"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotBlocksRemove()));
        break;
    case RS2::ActionBlocksAttributes:
		action = RS_ActionBlocksAttributes::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Rename Block"),
                             tr("&Rename Block"),
                             0, mw);
        action->setStatusTip(tr("Rename Block and all Inserts"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotBlocksAttributes()));
        break;
    case RS2::ActionBlocksEdit:
		action = RS_ActionBlocksEdit::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Edit Block"), tr("&Edit Block"),
                             0, mw);
        action->setStatusTip(tr("Edit Block"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotBlocksEdit()));
        break;
    case RS2::ActionBlocksInsert:
		action = RS_ActionBlocksInsert::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Insert Block"), tr("&Insert Block"),
                             0, mw);
        action->setStatusTip(tr("Insert Block"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotBlocksInsert()));
        break;
    case RS2::ActionBlocksToggleView:
		action = RS_ActionBlocksToggleView::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Toggle Block Visibility"),
                             tr("&Toggle Block"),
                             0, mw);
        action->setStatusTip(tr("Toggle Block"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotBlocksToggleView()));
        break;
    case RS2::ActionBlocksCreate:
		action = RS_ActionBlocksCreate::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotBlocksCreate()));
        /*
		action = new QAction(tr("Create Block"),
                             tr("&Create Block"),
                             0, mw);
        action->setStatusTip(tr("Create Block"));
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotBlocksCreate()));
		*/
        break;
    case RS2::ActionBlocksExplode:
		action = RS_ActionBlocksExplode::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Explode"),
                             tr("&Explode"),
                             0, mw);
        action->setStatusTip(tr("Explode Blocks and other Entity Groups"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotBlocksExplode()));
        break;
		

        // Options actions:
        //
    case RS2::ActionOptionsGeneral:
        action = new QAction(tr("Application"), QPixmap::fromMimeSource("configure.png"),
#ifdef __APPLE__
							 tr("&Preferences"),
#else
                             tr("&Application Preferences")+"...",
#endif
                             0, mw);
        action->setStatusTip(tr("General Application Preferences"));
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotOptionsGeneral()));
        break;

    case RS2::ActionOptionsDrawing:
		action = RS_ActionOptionsDrawing::createGUIAction(id, mw);
		/*
        action = new QAction(tr("Drawing"), tr("Current &Drawing Preferences"),
                             0, mw);
        action->setStatusTip(tr("Settings for the current Drawing"));
		*/
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotOptionsDrawing()));
        break;
		
        // Scripting actions:
        //
	case RS2::ActionScriptOpenIDE:
        action = new QAction(tr("Open IDE"),
                             tr("&Open IDE"),
                             0, mw);
        action->setStatusTip(tr("Opens the integrated development "
		   "environment for scripting"));
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotScriptOpenIDE()));
		break;
		
	case RS2::ActionScriptRun:
        action = new QAction(tr("Run Script.."),
                             tr("&Run Script.."),
                             0, mw);
        action->setStatusTip(tr("Runs a script"));
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotScriptRun()));
		break;

		// CAM actions:
		//
#ifdef RS_CAM
    case RS2::ActionCamExportAuto:
		action = RS_ActionCamExportAuto::createGUIAction(id, mw);
        //action = new QAction(tr("CAM Export"), tr("&CAM Export.."),
        //                     0, mw);
        //action->setStatusTip(tr("Exports the current drawing as "
		//				"CAM CNC program"));
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotCamExportAuto()));
        break;
		
    case RS2::ActionCamReorder:
		action = RS_ActionCamReorder::createGUIAction(id, mw);
        connect(action, SIGNAL(activated()),
                obj, SLOT(slotCamReorder()));
        break;
#endif

    default:
        std::cerr << "No action " << id << " defined\n";
        break;
    }

    return action;
}


