/***************************************************************************
                          lvi_track.h  -  description
                             -------------------
    begin                : Wed May 23 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LVI_TRACK_H
#define LVI_TRACK_H

#include "prokyon.h"

#include <qlistview.h>

class LVI_Track : public QListViewItem  {
 public: 
  LVI_Track(QListView *parent, TRACK *_track);
  
  void setFilename(QString);
  void setArtist(QString);
  void setTitle(QString);
  void setAlbum(QString);
  void setTracknumber(int);
  void setYear(QString);
  void setComment(QString);
  void setGenre(int);

  void setNewFilename(QString);

  QString getFilename();
  QString getArtist();
  QString getTitle();
  QString getAlbum();
  int     getTracknumber();
  QString getYear();
  int     getGenre();
  QString getComment();

  bool hasFilenameChanged();
  bool hasArtistChanged();
  bool hasTitleChanged();
  bool hasAlbumChanged();
  bool hasTracknumberChanged();
  bool hasYearChanged();
  bool hasGenreChanged();
  bool hasCommentChanged();

  void applyChanges();

  void applyMedium(int type, QString label);
  void applyPath(QString path);

  void setAvailability(bool state);

  bool getIsAvailable() { return isAvailable; }
  void setIsShowed(bool _isShowed);
  bool getIsShowed() { return isShowed; }
  int getType() { return myType; }
  int getMedium() { return track->medium; }

  TRACK *getOriginalTrack() { return track; }

  ~LVI_Track();

private:
  TRACK *track;

  bool isAvailable;
  bool isShowed;

  QString myfilename;
  QString mypath;
  int mygenre;
  int mytracknumber;
  QString myalbum;

  int myType;

  void adjustIcon();
};

#endif
