#include <qdatetime.h>

#include "job_generateplaylist.h"

#include "job_disconnectfromdatabase.h"

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"

Job_GeneratePlaylist::Job_GeneratePlaylist(int _numberTracks, int _minTrackLength, int _maxTrackLength, bool _onlyFavouriteArtists)
  : numberTracks(_numberTracks), minTrackLength(_minTrackLength), maxTrackLength(_maxTrackLength), onlyFavouriteArtists(_onlyFavouriteArtists)
{}

void Job_GeneratePlaylist::run()
{
  int error;
  int ID;
  QString time = QDateTime::currentDateTime().toString(Qt::ISODate);
  QString listname (_("generated ") + time);
  
  database->lock();
  ID = database->appendPlaylist(listname);
  error = database->getError();
  if(!error) {
      database->generatePlaylist(ID, numberTracks, minTrackLength, maxTrackLength, onlyFavouriteArtists);

      if(!error) {
        app->lock();
        datadispatcher->eventNewPlaylistBasis(database->getPlaylistBasis());
        datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(0),0);
        app->unlock();
      }
  }
  database->unlock();

  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
  exit();
}

Job_GeneratePlaylist::~Job_GeneratePlaylist() {}
