/***************************************************************************
                          createdb.cpp  -  description
                             -------------------
    begin                : Sat Aug 11 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qtooltip.h>

#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>
#include <kmessagebox.h>

#include <iostream.h>

#include "createdb.h"
#include "utils.h"

CreateDB::CreateDB(QWidget* parent, const char* name)
     : QDialog (parent, name, true)
{
     initDialog();
     setOptions();

     connect (butok, SIGNAL(clicked()), SLOT (slotbutok()));
     connect (butcancel, SIGNAL(clicked()), SLOT (slotbutcancel()));
}

CreateDB::~CreateDB(){
}


void CreateDB::initDialog()
{
     setCaption(i18n("Create DataBase"));

     QGridLayout* grid = new QGridLayout (this,3,3,8,20);

     QGroupBox* group = new QGroupBox (this);
     group->setTitle(i18n("DataBase Info"));
     grid->addMultiCellWidget(group, 0, 0, 0, 2);

     QGridLayout* grid1 = new QGridLayout (group, 5, 2, 18, 4);

     QLabel *lhost= new QLabel(i18n("Host"), group);
     grid1->addWidget(lhost, 0,0);
     host = new QLineEdit(group);
     grid1->addWidget(host,0,1);

      QLabel *luser= new QLabel(i18n("User"), group);
     grid1->addWidget(luser, 1,0);
     user = new QLineEdit(group);
     grid1->addWidget(user,1,1);

     QLabel *lpassword= new QLabel(i18n("Password"), group);
     grid1->addWidget(lpassword, 2,0);
     password = new QLineEdit(group);
     password->setEchoMode(QLineEdit::Password);
		 QToolTip::add(password,i18n("By default is \"mp3kult\""));
     grid1->addWidget(password,2,1);

	QLabel *lpassword2= new QLabel(i18n("Retype Password"), group);
     grid1->addWidget(lpassword2, 3,0);
     password2 = new QLineEdit(group);
     password2->setEchoMode(QLineEdit::Password);
		 QToolTip::add(password2,i18n("By default is \"mp3kult\""));
     grid1->addWidget(password2,3,1);

     QLabel *ldatabase= new QLabel(i18n("DataBase"), group);
     grid1->addWidget(ldatabase, 4,0);
     database = new QLineEdit(group);
     grid1->addWidget(database,4,1);

     QGroupBox* group2 = new QGroupBox (this);
     group2->setTitle(i18n("Admin Info"));
     grid->addMultiCellWidget(group2, 1, 1, 0, 2);

     QGridLayout* grid2 = new QGridLayout (group2, 2, 2, 18, 4);

	QLabel *ladminuser= new QLabel(i18n("Admin User"), group2);
     grid2->addWidget(ladminuser, 0,0);
     adminuser = new QLineEdit(group2);
     grid2->addWidget(adminuser,0,1);

	QLabel *ladminpass= new QLabel(i18n("Admin Password"), group2);
     grid2->addWidget(ladminpass, 1,0);
     adminpass = new QLineEdit(group2);
     adminpass->setEchoMode(QLineEdit::Password);
     grid2->addWidget(adminpass,1,1);

     butok = new QPushButton (this, "Push_OK");
     butok->resize (butok->sizeHint() );
     butok->setText( i18n("Ok") );
     grid->addWidget (butok, 2,0);

     butcancel = new QPushButton( this, "Push_Cancel" );
     grid->addWidget(butcancel,2,2);
     butcancel->resize (butcancel->sizeHint() );
     butcancel->setText( i18n("Cancel") );

     host->setFocus();
     resize (310, 210);
}

void CreateDB::setOptions()
{
 /* KConfig *config;
  config = kapp->config();

  config->setGroup("DataBase");

  host->setText(config->readEntry("Host", "localhost"));
  user->setText(config->readEntry("User", "mp3kult"));
  password->setText(Utils::decryptStr(config->readEntry("Password", Utils::encryptStr("mp3kult"))));
  database->setText(config->readEntry("DB", "Mp3Kult"));*/
	host->setText("localhost");
	user->setText("mp3kult");
	password->setText("mp3kult");
	password2->setText("mp3kult");
	database->setText("Mp3Kult");
	adminuser->setText("root");
}

void CreateDB::slotbutok()
{
	if(password->text() != password2->text())
	{
		KMessageBox::error( this, i18n("Passwords are different!"));
		return;
	}
	if (host->text().isEmpty() || user->text().isEmpty() || password->text().isEmpty() ||
			password2->text().isEmpty() || database->text().isEmpty() || adminuser->text().isEmpty())
	{
		KMessageBox::error( this, i18n("All fields are obligatory !\n"
																		"Except Admin Password"
																		"(If he hasn't got a password)"));
		return;
	}
	done (0);

}

void CreateDB::slotbutcancel()
{
    done(1);
}



#include "createdb.moc"
