/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.rmi.iiop;

import java.lang.reflect.Constructor;

import mx4j.tools.adaptor.rmi.RMIAdaptorMBeanDescription;

/**
 * Management interface descriptions for the IIOPAdaptor MBean.
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class IIOPAdaptorMBeanDescription extends RMIAdaptorMBeanDescription
{
   public String getMBeanDescription()
   {
      return "Adaptor for the RMI/IIOP protocol";
   }

   public String getConstructorDescription(Constructor ctor)
   {
      if (ctor.toString().equals("public mx4j.tools.adaptor.rmi.iiop.IIOPAdaptor()"))
      {
         return "Creates a new IIOP adaptor";
      }
      return super.getConstructorDescription(ctor);
   }
}
