#include <stdio.h>
#include <unistd.h>

#include "../config.h"
#include "audiobuffer.h"
#include "dspout.h"
#include "dspoutrtp.h"
#include "dspaudioin.h"

DspAudioIn::DspAudioIn( DspOut *in, DspOut *out )
	: DspAudio( in, out )
{
	udp_failures = 0;
}

DspAudioIn::~DspAudioIn( void )
{
}

void DspAudioIn::timerTick( void )
{

	if( broken ) {
		printf("(B)");
		fflush(stdout);
		return;
	}

	int bytes = input->readableBytes();
	
	// Fixed problem with ALSA or the OSS emulation layer
	bytes=bytes&0xfff0;
	
	if( bytes > 0 ) {

		// Read in a buffer
		input->readBuffer( bytes );

		// Make sure there's room in the output
		output->getBuffer().resize( input->getBuffer().getSize() );
		if (!generateDTMF((short*)output->getBuffer().getData(),
			input->getBuffer().getSize() / sizeof(short))) {

			// Copy the data
			memcpy( output->getBuffer().getData(),
				input->getBuffer().getData(),
				input->getBuffer().getSize() );
		}

		// If the write fails, mark the pipe as broken and stop sending!
		if( !output->writeBuffer() ) {
			udp_failures++;
			if(udp_failures > 5){
				broken = true;
				printf( QObject::tr("DspAudioIn: Broken pipe") + "\n" );
			} else {
				printf( QObject::tr("DspAudioIn: UDP-failure(%d)") + "\n", udp_failures );
			}
		} else {
			udp_failures = 0;
		}
	}
}

#ifndef QT_THREAD_SUPPORT
void DspAudioIn::start( void )
{
	timer = new QTimer();
	connect( timer, SIGNAL( timeout() ), this, SLOT( timeout() ) );
	timer->start( 1 );
}

void DspAudioIn::timeout()
{
	timerTick();
}

#endif
