#include <stdio.h>
#include <assert.h>
#include <unistd.h>
#include "../config.h"
#include "audiobuffer.h"
#include "dspout.h"
#include "dspoutrtp.h"
#include "dspaudio.h"

DspAudio::DspAudio( DspOut *in, DspOut *out )
	: input( in ), output( out )
{
	broken = false;
	cancel = false;
	copybuffer.resize( out->getBuffer().getSize() );
	newTone = 0;
	currentTone = 0;
	input->getBuffer().resize( 0 );
	dtmfSamples = 0;
#ifndef QT_THREAD_SUPPORT
	timer = 0;
#endif
}

DspAudio::~DspAudio( void )
{
	if( input ) delete input;
	if( output ) delete output;
#ifndef QT_THREAD_SUPPORT
	if( timer ) delete timer;
#endif
}

#ifdef QT_THREAD_SUPPORT
void DspAudio::run( void )
{
	for(;;) {
		if( isCanceled() ) break;
		timerTick();
		msleep( 1 );
	}
#ifdef QTHREAD_TERMINATE
	terminate();  // use this function only if absolutely necessary. (e.g. Redhat9)
#else
	QThread::exit();
#endif
}
#endif

void DspAudio::startTone(char code)
{
	newTone = code;
}

void DspAudio::stopTone(void)
{
	newTone = 0;
}

bool DspAudio::generateDTMF(short* buffer, size_t n)
{
	if (!buffer) return false;

	if (currentTone != 0) {
		// Currently generating a DTMF tone
		if (currentTone == newTone) {
			// Continue generating the same tone
			dtmf.getNextSamples(buffer, n);
			return true;
		} else if (newTone != 0) {
			// New tone requested
			dtmf.getSamples(buffer, n, newTone);
			currentTone = newTone;
			return true;
		} else {
			// Stop requested
			currentTone = newTone;
			return false;
		}
	} else {
		// Not generating any DTMF tone
		if (newTone) {
			// Requested to generate a DTMF tone
			dtmf.getSamples(buffer, n, newTone);
			currentTone = newTone;
			return true;
		}
		return false;
	}
}

void DspAudio::setCodec( const codecType newCodec, int newCodecNum )
{
	((DspOutRtp *)input)->setCodec( newCodec, newCodecNum );
}
