
/*
 * utils.h -- written for Juice
 *  Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef UTILS_UTILS_H
#define UTILS_UTILS_H

#include "typedefs.h"							 /* bool */

/*
 * Trim blanks from left and right sides of given string.
 */
void trim (char *str);

/*
 * Read at most count characters from fd and store it in buf. If a
 * '\n' is not found, -1 is returned, otherwise the number of
 * characters read is returned.
 *
 * UPDATE: I've changed the code to accept '\n' since some of my
 * friends have invalid descript.ion's that doesn't have a '\n'
 * after the last entry.
 */
int readline (int fd,char *buf,int count);

/*
 * Check if the given file is one of the types specified in
 * type, and that we have the necessary permissions to open
 * the file in the mode specified. Mode can be one or more of
 * the following characters: 'r' (readable), 'w' (writable),
 * 'x' (executable), e.g. "rw" would mean that we want read
 * and write permissions. Type can be one or more of the
 * following characters: 'l' (symbolic link), 'r' (regular
 * file), 'd' (directory), 'c' (character device), 'b' (block
 * device), 'f' (fifo), 's' (socket), e.g. "bsf" would mean
 * that we want a block device, socket, or a fifo. Both type
 * and mode must contain at least one character.
 */
bool fperm (const char *filename,const char *type,const char *mode);

/*
 * Copy a string to a volatile string.
 */
void safe_strcpy (volatile char *dest,const char *src);

/*
 * Copy a volatile string to a string.
 */
void safe_strcpy2 (volatile char *dest,volatile const char *src);

#endif
