
/*
 * dialogs.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DIALOGS_DIALOGS_H
#define DIALOGS_DIALOGS_H

#include "windows.h"
#include "vfs.h"
#include "background.h"

typedef struct
{
   int id;
   char *txt;
   void (*function)();
} MenuRec;

typedef struct HotkeyRec
{
   struct HotkeyRec *next;
   int hotkey;
   void (*function)();
} HotkeyType;

class Dialogs : public Background
{
 public:

   /*
	* Constructors & destructors
	*/

   /* Initialize Dialogs */
   Dialogs ();
   /* Cleanup datastructures */
   ~Dialogs ();

   /*
	* Operators
	*/

   /* Create a child Dialogs class */
   void operator = (const Windows &parent);

   /*
	* Dialogs
	*/

   /* Confirm dialog */
   bool Confirm (int tlx,int tly,const char *title,int attr,int fg,int bg);
   /* Menu dialog */
   void Menu (const MenuRec *options,const char *title,int fg,int bg);
   /* Select dialog - Same as Menu dialog except that it quits the menu */
   /* after an option is selected */
   void Select (const MenuRec *options,const char *title,int fg,int bg);
   /* Input dialog. Please note that the buffer will be truncated if the window doesn't fit */
   /* on the screen. Also, please check that tly is valid, i.e. tly < LINES - 3 */
   void Input (char *buffer,int buflen,int tlx,int tly,const char *title,int attr,int fg,int bg);
   /* Select directory dialog */
   void SelectDirectory (char *dirname,int maxdirlen,const char *title);
   /* Select file dialog  */
   void SelectFile (char *filename,int maxfilelen,char *filespec,const char *title);
   /* Help dialog */
   void Help (const char *filename,const char *title);
   /* Info display dialog */
   void Info (int tlx,int tly,const char *txt,int attr,int fg,int bg);
   /* Question dialog */
   bool Question (int tlx,int tly,const char *question,int attr,int fg,int bg);
   /* Save file dialog */
   void SaveFile (char *filename,int maxfilelen,char *filespec,const char *title);

   /*
	* Hotkeys
	*/

   /* Check if key is a valid hotkey */
   bool IsHotkey (int hotkey);
   /* Add a hotkey with it's associated function which will be called if the hotkey is */
   /* pressed while any of the dialogs is executed. Please note that if you add two functions */
   /* with the same hotkeys, only the first one will be used and RemoveHotkey will also only */
   /* remove one key at a time. BIG FAT WARNING: I'm assuming that you're going to open another */
   /* dialog/window with when any particular hotkey is pressed. In other words, the dialog in */
   /* which the hotkey is pressed might already be in the background when your function is */
   /* called although this is not necesseraly the case. */
   void AddHotkey (int hotkey,void (*function)());
   /* Remove the hotkey and it's associated function */
   void RemoveHotkey (int hotkey);
   /* Enable the abort flag. This allows Hotkey functions to make the dialog exit prematurely */
   void SetAbort (bool enabled);
   /* Reset the hotkey flag to HOTKEY_NONE */
   void ResetHotkeyFlag ();
   /* Return the last hotkey pressed (HOTKEY_NONE if none) */
   int LastHotkey ();
 private:
   /* Hotkeys & associated functions */
   HotkeyType *hotkeys;
   /* Hotkey flag */
   int hotkeyflag;
 protected:
   /* Abort flag */
   bool abortflag;
   /* Execute function associated with specified hotkey */
   void execfunc (int hotkey);
   /* Draw scrollbar frame for dialogs */
   void scrollframe (PANEL *curpan,bool single,bool visible,int frametype);
   /* Draw scrollbar button for dialogs */
   void scrollbutton (PANEL *curpan,int current,int total,bool visible,int frametype);
   /* Get name of directory in which file resides */
   void getfiledir (char *dirname,char *filename);
   /* Check if name is a directory */
   bool isdir (char *name);
};

#endif
