/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2003 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 */

#include <jni.h>
#include <sys/types.h>
#include <libgtkhtml/gtkhtml.h>

#ifndef _Included_org_gnu_gtkhtml_HTMLView
#define _Included_org_gnu_gtkhtml_HTMLView
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1get_1type
  (JNIEnv *env, jclass cls)
{
  return (jint) html_view_get_type();
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1new
  (JNIEnv *env, jclass cls)
{
  return (jint) html_view_new();
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_set_document
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1set_1document
  (JNIEnv *env, jclass cls, jint view, jint document)
{
  if (0 == document)
    html_view_set_document((HtmlView *)view, NULL);
  else
    html_view_set_document((HtmlView *)view, (HtmlDocument *)document);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_jump_to_anchor
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1jump_1to_1anchor
  (JNIEnv *env, jclass cls, jint view, jstring anch)
{
  const gchar *anchor = NULL;
  
  if (anch != NULL)
    anchor = (gchar*)(*env)->GetStringUTFChars(env, anch, 0);
  
  html_view_jump_to_anchor((HtmlView*)view, anchor);
	
  if (anch != NULL)
    (*env)->ReleaseStringUTFChars(env, anch, anchor);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_get_magnification
 * Signature: (I)D
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1get_1magnification
  (JNIEnv *env, jclass cls, jint view)
{
  return (jdouble) html_view_get_magnification((HtmlView *)view);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_set_magnification
 * Signature: (ID)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1set_1magnification
  (JNIEnv *env, jclass cls, jint view, jdouble mag)
{
  html_view_set_magnification((HtmlView *)view, (gdouble)mag);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_zoom_in
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1zoom_1in
  (JNIEnv *env, jclass cls, jint view)
{
  html_view_zoom_in((HtmlView *)view);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_zoom_out
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1zoom_1out
  (JNIEnv *env, jclass cls, jint view)
{
  html_view_zoom_out((HtmlView *)view);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_zoom_reset
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1zoom_1reset
  (JNIEnv *env, jclass cls, jint view)
{
  html_view_zoom_reset((HtmlView *)view);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_find_layout_box
 * Signature: (IIZ)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1find_1layout_1box
  (JNIEnv *env, jclass cls, jint view, jint node, jboolean findParent)
{
  return (jint)html_view_find_layout_box((HtmlView *)view, (DomNode *)node, (gboolean) findParent);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLView
 * Method:    html_view_scroll_to_node
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLView_html_1view_1scroll_1to_1node
  (JNIEnv *env, jclass cls, jint view, jint node, jint scrollType)
{
  html_view_scroll_to_node((HtmlView *)view, (DomNode *)node, (HtmlViewScrollToType)scrollType);}

#ifdef __cplusplus
}
#endif
#endif
