/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <libgnomevfs/gnome-vfs.h>

#ifndef _Included_org_gnu_gnomevfs_VFSURI
#define _Included_org_gnu_gnomevfs_VFSURI
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_new
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1new
  (JNIEnv *env, jclass cls, jstring uri)
{
	const gchar* u = (*env)->GetStringUTFChars(env, uri, NULL);
	jint result = (jint)gnome_vfs_uri_new(u);
	(*env)->ReleaseStringUTFChars(env, uri, u);
	return result;
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_resolve_relative
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1resolve_1relative
  (JNIEnv *env, jclass cls, jint base, jstring relative)
{
	const gchar* r = (*env)->GetStringUTFChars(env, relative, NULL);
	jint result = (jint)gnome_vfs_uri_resolve_relative((GnomeVFSURI*)base, r);
	(*env)->ReleaseStringUTFChars(env, relative, r);
	return result;
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_append_string
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1append_1string
  (JNIEnv *env, jclass cls, jint uri, jstring fragment)
{
	const gchar* str = (*env)->GetStringUTFChars(env, fragment, NULL);
	jint result = (jint)gnome_vfs_uri_append_string((GnomeVFSURI*)uri, str);
	(*env)->ReleaseStringUTFChars(env, fragment, str);
	return result;
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_append_path
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1append_1path
  (JNIEnv *env, jclass cls, jint uri, jstring path)
{
	const gchar* str = (*env)->GetStringUTFChars(env, path, NULL);
	jint result = (jint)gnome_vfs_uri_append_path((GnomeVFSURI*)uri, str);
	(*env)->ReleaseStringUTFChars(env, path, str);
	return result;
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_append_file_name
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1append_1file_1name
  (JNIEnv *env, jclass cls, jint uri, jstring filename)
{
	const gchar* str = (*env)->GetStringUTFChars(env, filename, NULL);
	jint result = (jint)gnome_vfs_uri_append_file_name((GnomeVFSURI*)uri, str);
	(*env)->ReleaseStringUTFChars(env, filename, str);
	return result;
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_to_string
 * Signature: (II)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1to_1string
  (JNIEnv *env, jclass cls, jint uri, jint hideOptions)
{
	gchar* str = gnome_vfs_uri_to_string((GnomeVFSURI*)uri, (GnomeVFSURIHideOptions)hideOptions);
	return (*env)->NewStringUTF(env, str);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_dup
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1dup
  (JNIEnv *env, jclass cls, jint uri)
{
	return (jint)gnome_vfs_uri_dup((GnomeVFSURI*)uri);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_is_local
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1is_1local
  (JNIEnv *env, jclass cls, jint uri)
{
	return (jboolean)gnome_vfs_uri_is_local((GnomeVFSURI*)uri);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_has_parent
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1has_1parent
  (JNIEnv *env, jclass cls, jint uri)
{
	return (jboolean)gnome_vfs_uri_has_parent((GnomeVFSURI*)uri);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_get_parent
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1get_1parent
  (JNIEnv *env, jclass cls, jint uri)
{
	return (jint)gnome_vfs_uri_get_parent((GnomeVFSURI*)uri);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_get_toplevel
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1get_1toplevel
  (JNIEnv *env, jclass cls, jint uri)
{
	return (jint)gnome_vfs_uri_get_toplevel((GnomeVFSURI*)uri);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_get_host_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1get_1host_1name
  (JNIEnv *env, jclass cls, jint uri)
{
	return (*env)->NewStringUTF(env, gnome_vfs_uri_get_host_name((GnomeVFSURI*)uri));
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_get_scheme
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1get_1scheme
  (JNIEnv *env, jclass cls, jint uri)
{
	return (*env)->NewStringUTF(env, gnome_vfs_uri_get_scheme((GnomeVFSURI*)uri));
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_get_host_port
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1get_1host_1port
  (JNIEnv *env, jclass cls, jint uri)
{
	return (jint)gnome_vfs_uri_get_host_port((GnomeVFSURI*)uri);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_get_user_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1get_1user_1name
  (JNIEnv *env, jclass cls, jint uri)
{
	return (*env)->NewStringUTF(env, gnome_vfs_uri_get_user_name((GnomeVFSURI*)uri));
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_get_password
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1get_1password
  (JNIEnv *env, jclass cls, jint uri)
{
	return (*env)->NewStringUTF(env, gnome_vfs_uri_get_password((GnomeVFSURI*)uri));
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_set_host_name
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1set_1host_1name
  (JNIEnv *env, jclass cls, jint uri, jstring host)
{
	const gchar* str = (*env)->GetStringUTFChars(env, host, NULL);
	gnome_vfs_uri_set_host_name((GnomeVFSURI*)uri, str);
	(*env)->ReleaseStringUTFChars(env, host, str);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_set_host_port
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1set_1host_1port
  (JNIEnv *env, jclass cls, jint uri, jint port)
{
	gnome_vfs_uri_set_host_port((GnomeVFSURI*)uri, port);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_set_user_name
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1set_1user_1name
  (JNIEnv *env, jclass cls, jint uri, jstring name)
{
	const gchar* str = (*env)->GetStringUTFChars(env, name, NULL);
	gnome_vfs_uri_set_user_name((GnomeVFSURI*)uri, str);
	(*env)->ReleaseStringUTFChars(env, name, str);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_set_password
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1set_1password
  (JNIEnv *env, jclass cls, jint uri, jstring pass)
{
	const gchar* str = (*env)->GetStringUTFChars(env, pass, NULL);
	gnome_vfs_uri_set_password((GnomeVFSURI*)uri, str);
	(*env)->ReleaseStringUTFChars(env, pass, str);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_equal
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1equal
  (JNIEnv *env, jclass cls, jint a, jint b)
{
	return (jboolean)gnome_vfs_uri_equal((GnomeVFSURI*)a, (GnomeVFSURI*)b);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_is_parent
 * Signature: (IIZ)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1is_1parent
  (JNIEnv *env, jclass cls, jint parent, jint child, jboolean recursive)
{
	return (jboolean)gnome_vfs_uri_is_parent((GnomeVFSURI*)parent, (GnomeVFSURI*)child, recursive);
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_get_path
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1get_1path
  (JNIEnv *env, jclass cls, jint uri)
{
	return (*env)->NewStringUTF(env, gnome_vfs_uri_get_path((GnomeVFSURI*)uri));
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_get_fragment_identifier
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1get_1fragment_1identifier
  (JNIEnv *env, jclass cls, jint uri)
{
	return (*env)->NewStringUTF(env, gnome_vfs_uri_get_fragment_identifier((GnomeVFSURI*)uri));
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_extract_dirname
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1extract_1dirname
  (JNIEnv *env, jclass cls, jint uri)
{
	return (*env)->NewStringUTF(env, gnome_vfs_uri_extract_dirname((GnomeVFSURI*)uri));
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_extract_short_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1extract_1short_1name
  (JNIEnv *env, jclass cls, jint uri)
{
	return (*env)->NewStringUTF(env, gnome_vfs_uri_extract_short_name((GnomeVFSURI*)uri));
}

/*
 * Class:     org_gnu_gnomevfs_VFSURI
 * Method:    gnome_vfs_uri_extract_short_path_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSURI_gnome_1vfs_1uri_1extract_1short_1path_1name
  (JNIEnv *env, jclass cls, jint uri)
{
	return (*env)->NewStringUTF(env, gnome_vfs_uri_extract_short_path_name((GnomeVFSURI*)uri));
}

#ifdef __cplusplus
}
#endif
#endif
