/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gnomevfs;

import org.gnu.glib.Enum;

/**
 */
public class VFSFileType extends Enum {
    static final private int _UNKNOWN = 0;

    static final public VFSFileType UNKNOWN = new VFSFileType(_UNKNOWN);

    static final private int _REGULAR = 1;

    static final public VFSFileType REGULAR = new VFSFileType(_REGULAR);

    static final private int _DIRECTORY = 2;

    static final public VFSFileType DIRECTORY = new VFSFileType(_DIRECTORY);

    static final private int _FIFO = 3;

    static final public VFSFileType FIFO = new VFSFileType(_FIFO);

    static final private int _SOCKET = 4;

    static final public VFSFileType SOCKET = new VFSFileType(_SOCKET);

    static final private int _CHARACTER_DEVICE = 5;

    static final public VFSFileType CHARACTER_DEVICE = new VFSFileType(_CHARACTER_DEVICE);

    static final private int _BLOCK_DEVICE = 6;

    static final public VFSFileType BLOCK_DEVICE = new VFSFileType(_BLOCK_DEVICE);

    static final private int _SYMBOLIC_LINK = 7;

    static final public VFSFileType SYMBOLIC_LINK = new VFSFileType(_SYMBOLIC_LINK);

    static final private VFSFileType[] theInterned = new VFSFileType[] {
    		REGULAR, DIRECTORY, FIFO, SOCKET, CHARACTER_DEVICE, BLOCK_DEVICE, SYMBOLIC_LINK };

    static private java.util.Hashtable theInternedExtras;

    static final private VFSFileType theSacrificialOne = new VFSFileType(
            0);

    static public VFSFileType intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        VFSFileType already = (VFSFileType) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new VFSFileType(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private VFSFileType(int value) {
        value_ = value;
    }

    public VFSFileType or(VFSFileType other) {
        return intern(value_ | other.value_);
    }

    public VFSFileType and(VFSFileType other) {
        return intern(value_ & other.value_);
    }

    public VFSFileType xor(VFSFileType other) {
        return intern(value_ ^ other.value_);
    }

    public boolean test(VFSFileType other) {
        return (value_ & other.value_) == other.value_;
    }
}
