/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>

#define MAX_CHAR_LEN 	4

int  main(int argc, char **argv)
{
    	char            *file_name; 
	char		line[256], value1[256];
	unsigned char	value2[256];
    
	char 		*ptr;
	FILE 		*fd;
	int 		i;

	if (argc != 2) {
		printf("usage: %s file_name\n", argv[0]);
		exit(0);
	}

    	/* read profile from file to memory buffer  */ 
	file_name = argv[1];

	fd = fopen(file_name, "r");
	if (! fd)
		return -1;

	while (fgets(line, 255, fd) != NULL) {
		ptr = line;

		/* skip space */
		while (*ptr == ' ' || *ptr == '\t') ptr++;

		/* check null line or comment line */
		if ((*ptr == '\0') || (*ptr == '\n') || (*ptr == '#'))
			continue;

		memset(value1, 0, 256);
		memset(value2, 0, 256);
		for (i=0; i<MAX_CHAR_LEN; i++) {
			if (*ptr == ' ' || *ptr == '\t' || *ptr == '\n')
				break;
			value1[i] = tolower(*ptr++);
		}
		value1[i] = 0;

		/* skip space */
		while (*ptr == ' ' || *ptr == '\t') ptr++;

		if (*ptr && *ptr != '\n') {
			unsigned char *vptr = value2;
			while(*ptr && *ptr != ' ' && *ptr != '\n' && *ptr != '\t') {
				*vptr++ = *ptr++;
			}
			*vptr = 0;
				
			printf("%s\t%s\n", value1, value2);
		}
	}
	
	fclose(fd);

    	return 0;
}

