/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>

#include "thai_le.h"
#include "thai_keymap.h"
#include "encode.h"
#include "wtt_isc.h"

void proc_paletteaux_connect_event();
void proc_paletteaux_switch_mode_event();
void proc_paletteaux_change_position_event();
void proc_paletteaux_show_keyboardaux_event(iml_session_t *s, int nKeyboardID);
void proc_paletteaux_show_optionaux_event(iml_session_t *s);
void proc_paletteaux_hide_keyboardaux_event(iml_session_t *s);
void proc_keyboardaux_change_position_event(iml_session_t *s, int x, int y);
void proc_keyboardaux_change_key_status_event(iml_session_t *s, int key_status);
void proc_optionaux_change_status_event(iml_session_t *s, int on_status);
void proc_commonaux_commit_string_event(iml_session_t *s, int locale_id, char *commit_str);
void proc_commonaux_commit_key_event(iml_session_t *s, int keycode, int keychar, int keystatus);
void proc_commonaux_lost_focus_event(iml_session_t *s);
void proc_commonaux_set_default_value_event(iml_session_t *s, int isc_mode_id, int keyboard_id);

void le_start_paletteaux(iml_session_t *s);
void le_start_keyboardaux(iml_session_t *s);
void le_start_optionaux(iml_session_t *s);
void le_change_keyboardaux_focus_notify(iml_session_t *s);
void le_change_focus_notify(iml_session_t *s);
void le_show_keyboardaux_notify(iml_session_t *s, int nKeyboardID);
void le_hide_keyboardaux_notify(iml_session_t *s);
void le_show_optionaux_notify(iml_session_t *s);
void le_send_keyboardlayout_info(iml_session_t *s, char *classname);
void le_send_modename_list_info(iml_session_t *s, char *classname);
void le_send_keyboardname_list_info(iml_session_t *s, char *classname);
void le_switch_mode_notify(iml_session_t *s, int mode_id);

extern char *wtt_isc_mode_names[];
extern TThaiKeymapList gThaiKeymapList;

/* ============================================================== */
/*            Process information from Auxiliary Window           */
/* ============================================================== */
void proc_aux_event(iml_session_t *s, IMAuxEvent *auxevent)
{
	IMAuxDrawCallbackStruct *aux_data = auxevent->aux;
	int nIntegerCount, *pIntegerList;
	int nStringCount, nStringLen;
        int reqType;
	int locale_id, on, mode_id, qjbj, punct, x, y;
	int nKeyboardID, keycode, keychar, keystatus;
	char *command_str, *commit_str;
	int  isc_mode_id, keyboard_id;
	IMText *lt;

	nIntegerCount = aux_data->count_integer_values;
	pIntegerList = aux_data->integer_values;

	if (nIntegerCount <= 0) return;

	reqType = pIntegerList[0];

	DEBUG_printf("proc_aux_event: session:%x\n",aux_data, s);
	DEBUG_printf("reqType: %d\n", reqType);
	switch (reqType)
	{
		/* need not check whether the Palette is started */
		case PALETTEAUX_CONNECT:
			locale_id = pIntegerList[1];
			proc_paletteaux_connect_event(s, locale_id);
			break;

		case PALETTEAUX_SWITCH_ISC_MODE:
			mode_id = pIntegerList[1];
			proc_paletteaux_switch_mode_event(s, mode_id);
			break;

		case PALETTEAUX_CHANGE_POSITION:
			x = pIntegerList[1];
			y = pIntegerList[2];
			proc_paletteaux_change_position_event(s, x, y);
			break;

		case PALETTEAUX_SHOW_KEYBOARDAUX:
			nKeyboardID = pIntegerList[1];
			proc_paletteaux_show_keyboardaux_event(s, nKeyboardID);
			break;

		case PALETTEAUX_SHOW_OPTIONAUX:
			proc_paletteaux_show_optionaux_event(s);
			break;

		case KEYBOARDAUX_CHANGE_POSITION:
			x = pIntegerList[1];
			y = pIntegerList[2];
			proc_keyboardaux_change_position_event(s, x, y);
			break;

		case KEYBOARDAUX_CHANGE_KEY_STATUS:
			keystatus = pIntegerList[1];
			proc_keyboardaux_change_key_status_event(s, keystatus);
			break;

		case OPTIONAUX_CHANGE_STATUS:
			on = pIntegerList[1];
			proc_optionaux_change_status_event(s, on);
			break;

		case COMMONAUX_COMMIT_STRING:
			nStringCount = aux_data->count_string_values;
			if (nStringCount != 1) break;

			locale_id = pIntegerList[1];
			commit_str = (char *)aux_data->string_values->text.utf_chars;
			proc_commonaux_commit_string_event(s, locale_id, commit_str);

			break;

		case COMMONAUX_COMMIT_KEY:
			keycode = pIntegerList[1];
			keychar = pIntegerList[2];
			keystatus = pIntegerList[3];
			proc_commonaux_commit_key_event(s, keycode, keychar, keystatus);
			break;

		case COMMONAUX_SET_DEFAULT_VALUE:
			isc_mode_id = pIntegerList[1];
			keyboard_id = pIntegerList[2];

			proc_commonaux_set_default_value_event(s, isc_mode_id, keyboard_id);

			break;

		case COMMONAUX_LOST_FOCUS:
			proc_commonaux_lost_focus_event(s);
			break;

	}
}

void proc_paletteaux_connect_event(iml_session_t *s, int locale_id)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	
	DEBUG_printf("PALETTEAUX_CONNECT Request Received\n");
	desktop_data->bPaletteAux_Ready = True;
}

void proc_paletteaux_switch_mode_event(iml_session_t *s, int isc_mode_id)
{
	DEBUG_printf("PALETTEAUX_SWITCH_ISC_MODE:  mode_id:%d\n", isc_mode_id);
	le_session_save_isc_mode(s, isc_mode_id);

	isc_mode_id = le_session_get_isc_mode(s);
	le_switch_mode_notify(s, isc_mode_id);

	le_status_draw(s);
}

void proc_paletteaux_change_position_event(iml_session_t *s, int x, int y)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("PALETTEAUX_CHANGE_POSITION:  x: 0x%x, y:0x%x\n", x, y);
	session_data->tPaletteAux_Status.nXPos = x;
	session_data->tPaletteAux_Status.nYPos = y;
}

void proc_paletteaux_show_keyboardaux_event(iml_session_t *s, int nKeyboardID)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	char *classname = XAUX_KEYBOARD_CLASS_NAME;
	int keyboard_id;

	le_start_keyboardaux(s);

	if (session_data->tKeyboardAux_Status.bShow == False) {
		keyboard_id = le_session_get_keyboard_mode(s);
		le_show_keyboardaux_notify(s, keyboard_id);
		session_data->tKeyboardAux_Status.bShow = True;
	} else {
		session_data->tKeyboardAux_Status.bShow = False;
		le_hide_keyboardaux_notify(s);
	}
}

void proc_paletteaux_show_optionaux_event(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	le_start_optionaux(s);

	DEBUG_printf("proc_paletteaux_show_optionaux_event\n");
	session_data->tOptionAux_Status.bShow = True;
	le_show_optionaux_notify(s);
}

void proc_keyboardaux_change_position_event(iml_session_t *s, int x, int y)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("KEYBOARDAUX_CHANGE_POSITION:  x: 0x%x, y:0x%x\n", x, y);
	session_data->tKeyboardAux_Status.nXPos = x;
	session_data->tKeyboardAux_Status.nYPos = y;
}

void proc_keyboardaux_change_key_status_event(iml_session_t *s, int key_status)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("KEYBOARDAUX_CHANGE_KEY_STATUS:  key_status: 0x%x\n", key_status);
	session_data->tKeyboardAux_Status.nKeyStatus = key_status;
}

void proc_optionaux_change_status_event(iml_session_t *s, int on_status)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("OPTIONAUX_CHANGE_STATUS:  on_status: 0x%x\n", on_status);
	session_data->tOptionAux_Status.bShow = on_status;
	if (on_status == False) {
		le_change_focus_notify(s);
	}
}

void proc_commonaux_commit_string_event(iml_session_t *s, int locale_id, char *commit_str)
{
	DEBUG_printf("COMMONAUX_COMMIT_STRING Request Received: \n");
	DEBUG_printf("locale_id:%d, command_str:%s, len:%d\n", 
		locale_id, commit_str, strlen(commit_str));

	encode_commit(s, locale_id, (unsigned char *)commit_str);
}

void proc_commonaux_commit_key_event(iml_session_t *s, int keycode, int keychar, int keystatus)
{
	static IMKeyEventStruct akey;
	static IMKeyListEvent keyev;

	DEBUG_printf("COMMONAUX_COMMIT_KEY Request Received: \n");
	DEBUG_printf("keycode:0x%x, keychar:0x%x, keystatus:0x%x\n", 
		keycode, keychar, keystatus);

	akey.keyCode = keycode;
	akey.keyChar = keychar;
	akey.modifier = keystatus;
	keyev.type = IM_EventKeyList;
	keyev.keylist = (IMKeyList) &akey;
	proc_key_event(s, (IMKeyListEvent *) &keyev);
}

void proc_commonaux_lost_focus_event(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	int on_save = session_data->tPaletteAux_Status.bShow;

	DEBUG_printf("COMMONAUX_LOST_FOCUS Request Received\n");
	session_data->tPaletteAux_Status.bShow = False;
	le_change_focus_notify(s);
	session_data->tPaletteAux_Status.bShow = on_save;
}

void proc_commonaux_set_default_value_event(iml_session_t *s, int isc_mode_id, int keyboard_id)
{
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);

	DEBUG_printf("COMMONAUX_SET_DEFAULT_VALUE Request Received: isc_mode_id: %d, keyboard_id:%d\n", isc_mode_id, keyboard_id);

	le_desktop_save_default_isc_mode(s, isc_mode_id);
	le_desktop_save_default_keyboard_mode(s, keyboard_id);

	proc_paletteaux_switch_mode_event(s, isc_mode_id);

	if (desktop_data->bKeyboardAux_Started == True)
		le_change_keyboardaux_focus_notify(s);

}

/* ============================================================== */
/*              Send information to Auxiliary Window              */
/* ============================================================== */
void le_start_paletteaux(iml_session_t *s)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	char *classname = XAUX_PALETTE_CLASS_NAME;

	if (desktop_data->pRootSession == NULL) return;
	if (desktop_data->bPaletteAux_Started == True) return;

	DEBUG_printf("First start PaletteAux\n");
	desktop_data->bPaletteAux_Started = True;
	iml_aux_start(desktop_data->pRootSession, classname);

	le_send_modename_list_info(s, classname);
}

void le_start_keyboardaux(iml_session_t *s)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	char *classname = XAUX_KEYBOARD_CLASS_NAME;

	if (desktop_data->pRootSession == NULL) return;
	if (desktop_data->bKeyboardAux_Started == True) return;

	DEBUG_printf("First start KeyboardAux\n");
	desktop_data->bKeyboardAux_Started = True;
	iml_aux_start(desktop_data->pRootSession, classname);

	le_send_keyboardlayout_info(s, classname);
}

void le_start_optionaux(iml_session_t *s)
{
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	char *classname = XAUX_OPTION_CLASS_NAME;

	if (desktop_data->pRootSession == NULL) return;
	if (desktop_data->bOptionAux_Started == True) return;

	DEBUG_printf("First start OptionAux\n");
	desktop_data->bOptionAux_Started = True;
	iml_aux_start(desktop_data->pRootSession, classname);

	le_send_modename_list_info(s, classname);
	le_send_keyboardname_list_info(s, classname);
}

void send_info_to_aux(iml_session_t *s, char *classname,
		 int count_integers,  int *integers,
		 int count_strings,   int *len_strings,
		 char **strings)
{
	iml_aux_draw(	s, classname, 
			count_integers,  integers,
			count_strings,   len_strings,
			strings);
}

void le_switch_mode_notify(iml_session_t *s, int mode_id)
{
	char *classname = XAUX_PALETTE_CLASS_NAME;
	int nIntegerCount,  pIntegerList[2];

	DEBUG_printf("le_switch_ime_notify: ======\n");

	nIntegerCount = 2;
	pIntegerList[0] = PALETTEAUX_SWITCH_ISC_MODE_NOTIFY;
	pIntegerList[1] = mode_id;

	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_paletteaux_focus_notify(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	char *classname = XAUX_PALETTE_CLASS_NAME;
	int nIntegerCount,  pIntegerList[5];

	DEBUG_printf("le_change_paletteaux_focus_notify: ======\n");

	nIntegerCount = 5;
	pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
	pIntegerList[1] = session_data->tPaletteAux_Status.nXPos;
	pIntegerList[2] = session_data->tPaletteAux_Status.nYPos;
	pIntegerList[3] = session_data->tPaletteAux_Status.bShow;
	pIntegerList[4] = le_session_get_isc_mode(s);

	DEBUG_printf(" x:%d, y:%d, on:%d, mode_id:%d\n",
		pIntegerList[1],
		pIntegerList[2],
		pIntegerList[3],
		pIntegerList[4]);
	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_keyboardaux_focus_notify(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	char *classname = XAUX_KEYBOARD_CLASS_NAME;
	int nIntegerCount,  pIntegerList[7];

	DEBUG_printf("le_change_keyboardaux_focus_notify: ======\n");

	nIntegerCount = 7;
	pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
	pIntegerList[1] = session_data->tKeyboardAux_Status.nXPos;
	pIntegerList[2] = session_data->tKeyboardAux_Status.nYPos;
	pIntegerList[3] = session_data->tPaletteAux_Status.bShow;
	pIntegerList[4] = session_data->tKeyboardAux_Status.bShow;
	pIntegerList[5] = le_session_get_keyboard_mode(s);
	pIntegerList[6] = session_data->tKeyboardAux_Status.nKeyStatus;
	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_optionaux_focus_notify(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	char *classname = XAUX_OPTION_CLASS_NAME;
	int nIntegerCount,  pIntegerList[5];

	DEBUG_printf("le_change_optionaux_focus_notify: ======\n");

	nIntegerCount = 5;
	pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
	pIntegerList[1] = session_data->tPaletteAux_Status.bShow;
	pIntegerList[2] = session_data->tOptionAux_Status.bShow;
	pIntegerList[3] = le_session_get_isc_mode(s);
	pIntegerList[4] = le_session_get_keyboard_mode(s);
	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_focus_notify(iml_session_t *s)
{
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);

	if (desktop_data->bPaletteAux_Started == True) 
		le_change_paletteaux_focus_notify(s);

	if (desktop_data->bKeyboardAux_Started == True)
		le_change_keyboardaux_focus_notify(s);

	if (desktop_data->bOptionAux_Started == True)
		le_change_optionaux_focus_notify(s);
}

void le_show_keyboardaux_notify(iml_session_t *s, int nKeyboardID)
{
	char *classname = XAUX_KEYBOARD_CLASS_NAME;
	int nIntegerCount,  pIntegerList[2];

	DEBUG_printf("le_show_keyboardaux_notify: ====== nKeyboardID:%d\n", nKeyboardID);

	nIntegerCount = 2;
	pIntegerList[0] = KEYBOARDAUX_SHOW_NOTIFY;
	pIntegerList[1] = nKeyboardID;

	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_hide_keyboardaux_notify(iml_session_t *s)
{
	char *classname = XAUX_KEYBOARD_CLASS_NAME;
	int nIntegerCount,  pIntegerList[1];

	DEBUG_printf("le_hide_keyboardaux_notify: \n");

	nIntegerCount = 1;
	pIntegerList[0] = KEYBOARDAUX_HIDE_NOTIFY;

	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_show_optionaux_notify(iml_session_t *s)
{
	char *classname = XAUX_OPTION_CLASS_NAME;
	int nIntegerCount,  pIntegerList[3];

	DEBUG_printf("le_show_optionaux_notify: ======\n");

	nIntegerCount = 3;
	pIntegerList[0] = OPTIONAUX_SHOW_NOTIFY;
	pIntegerList[1] = le_session_get_isc_mode(s);
	pIntegerList[2] = le_session_get_keyboard_mode(s);

	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_hide_optionaux_notify(iml_session_t *s)
{
	char *classname = XAUX_OPTION_CLASS_NAME;
	int nIntegerCount,  pIntegerList[1];

	DEBUG_printf("le_hide_optionaux_notify: ======\n");

	nIntegerCount = 1;
	pIntegerList[0] = OPTIONAUX_HIDE_NOTIFY;

	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_send_modename_list_info(iml_session_t *s, char *classname)
{
	int nIntegerCount,  pIntegerList[2];
	int nStringsCount,  pLenStrings[WTT_ISC_MODES_NUM];
	char *pStrings[WTT_ISC_MODES_NUM];

	int i;
	char *mode_name;

	DEBUG_printf("le_send_modename_list_info_notify\n");

	nIntegerCount = 2;
	pIntegerList[0] = COMMONAUX_MODE_NAME_NOTIFY;
	pIntegerList[1] = WTT_ISC_MODES_NUM;

	nStringsCount = WTT_ISC_MODES_NUM;
	for (i = 0; i < WTT_ISC_MODES_NUM; i++) {
		mode_name = (char *)wtt_isc_mode_names[i];
		pLenStrings[i] = strlen(mode_name) + 1;
		pStrings[i] = (char *)mode_name;
		DEBUG_printf("%d, mode_name:%s\n", i, mode_name);
	}

	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 
			nStringsCount,  pLenStrings,
			pStrings);
}

void le_send_keyboardname_list_info(iml_session_t *s, char *classname)
{
	int nIntegerCount,  pIntegerList[2];
	int nStringsCount,  *pLenStrings;
	char **pStrings;

	int i, nKeyboard_Num;
	char *keyboard_name;

	nKeyboard_Num = gThaiKeymapList.nNum_Keymaps;
	
	if (nKeyboard_Num < 0) 
		return;

	if (gThaiKeymapList.pKeymaps == NULL)
		return;

	pLenStrings = (int *)calloc(nKeyboard_Num + 1, sizeof(int));
	pStrings = (char **)calloc(nKeyboard_Num + 1, sizeof(char *));
	if (pLenStrings == NULL || pStrings == NULL)
		goto Error;

	nIntegerCount = 2;
	pIntegerList[0] = COMMONAUX_KEYBOARD_NAME_NOTIFY;
	pIntegerList[1] = nKeyboard_Num;

	nStringsCount = 0;
	for (i = 0; i < nKeyboard_Num; i++) {
		if (gThaiKeymapList.pKeymaps[i] == NULL) continue;
		keyboard_name = (char *)gThaiKeymapList.pKeymaps[i]->pName;
		if (keyboard_name == NULL) keyboard_name = "keyboard";
		pLenStrings[i] = strlen(keyboard_name) + 1;
		pStrings[i] = (char *)keyboard_name;

		nStringsCount ++;
	}

	DEBUG_printf("le_send_keyboardname_list_notify\n");
	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 
			nStringsCount,  pLenStrings,
			pStrings);

Error:
	if (pLenStrings != NULL)
		free((char *)pLenStrings);

	if (pStrings != NULL)
		free((char *)pStrings);
}

void le_send_keyboardlayout_info(iml_session_t *s, char *classname)
{
	int nIntegerCount,  pIntegerList[2];
	int nStringsCount,  *pLenStrings;
	char **pStrings;

	int i, nKeyboard_Num;
	char *th_keymap;

	nKeyboard_Num = gThaiKeymapList.nNum_Keymaps;
	
	if (nKeyboard_Num < 0) 
		return;

	if (gThaiKeymapList.pKeymaps == NULL)
		return;

	pLenStrings = (int *)calloc(nKeyboard_Num + 1, sizeof(int));
	pStrings = (char **)calloc(nKeyboard_Num + 1, sizeof(char *));
	if (pLenStrings == NULL || pStrings == NULL)
		goto Error;

	nIntegerCount = 2;
	pIntegerList[0] = COMMONAUX_KEYBOARD_LAYOUT_NOTIFY;
	pIntegerList[1] = nKeyboard_Num;

	nStringsCount = 0;
	for (i = 0; i < nKeyboard_Num; i++) {
		if (gThaiKeymapList.pKeymaps[i] == NULL) continue;
		th_keymap = (char *)gThaiKeymapList.pKeymaps[i]->pKeymap;
		if (th_keymap == NULL) continue;
		pLenStrings[i] = THAI_KEYMAP_LEN + 1;
		pStrings[i] = (char *)th_keymap;

		nStringsCount ++;
	}

	DEBUG_printf("le_send_modename_list_notify\n");
	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 
			nStringsCount,  pLenStrings,
			pStrings);

Error:
	if (pLenStrings != NULL)
		free((char *)pLenStrings);

	if (pStrings != NULL)
		free((char *)pStrings);
}


