/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "IMLanguageList.hh"

IMLanguageList::IMLanguageList(CompoundString alang) {
  add(alang);
}

IMLanguageList::~IMLanguageList() {
  int n = count();
  language_list.destroy();
}

IMLanguageList&
IMLanguageList::operator=(const IMLanguageList& a) {
  language_list.destroy();
  int n = a.count();
  for (int i = 1; i <= n; i++) {
    CompoundString langp = a.getLang(i);
    add(langp);
  }
  return *this;
}

int
IMLanguageList::count() const {
  return language_list.getSize();
}

CompoundString&
IMLanguageList::getLang(unsigned int index) const {
  return language_list.getItem(index);
}

void
IMLanguageList::add(CompoundString alang) {
  char *str;

  if (alang.compare("ja", 2))
    str = (char*)"ja";
  else if (alang.compare("ko", 2))
    str = (char*)"ko";
  else if (alang.compare("zh_TW", 5))
    str = (char*)"zh_TW";
  else if (alang.compare("zh_HK", 5))
    str = (char*)"zh_HK";
  else if (alang.compare("zh", 2))
    str = (char*)"zh_CN";
  else
		str = (char *)alang;

  for(int i=1;i<=count();i++){
    CompoundString lang = getLang(i);
    if(lang.compare(str)){
      // duplicated
      return;
    }
  }

  CompoundString *item = new CompoundString(str);
  language_list.addItem(item);
}
