%define release		1
%define	name		gnome-im-switcher
%define	version		1.0.3
%define	release		1
%define	serial		1

Name:         %{name}
License:      LGPL
Group:        System/GUI/GNOME
Version:      %{version}
Release:      %{release}
Serial:	      %{serial}
Distribution: Mercury
Vendor:	      Sun Microsystems, Inc.
Summary:      GNOME Input Method Switcher Applet
Packager:     Hidetoshi Tajima <hidetoshi.tajima@sun.com>
Source:       %{name}-%{version}.tar.bz2
URL:          http://www.sun.com
BuildRoot:    %{_tmppath}/%{name}-%{version}-build
Autoreqprov:  on

Requires:       glib2 >= 2.1.0
Requires:       gtk2 >= 2.1.1
Requires:	libgnome >= 2.1.1
Requires:	libgnomeui >= 2.1.1
Requires:	gnome-panel >= 2.0.0

BuildRequires:	glib2-devel >= 2.1.0
BuildRequires:	gtk2-devel >= 2.1.1
BuildRequires:	libgnome-devel >= 2.1.1
BuildRequires:	libgnomeui-devel >= 2.1.1
BuildRequires:	gnome-panel-devel >= 2.0.0

%description
Input Method Switcher Applet provides GUI to display input method status
and to select input languages from your GNOME panel.

%prep
%setup -q -n gnome-im-switcher

%build
CFLAGS="$RPM_OPT_FLAGS"			\
./autogen.sh --prefix=%{_prefix}	\
	    --sysconfdir=%{_sysconfdir} \
	    --libexecdir=%{_libexecdir} \
	    --localstatedir=/var/lib
make

%install
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1 
make DESTDIR=$RPM_BUILD_ROOT install
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
SCHEMAS="gnome-im-switcher.schemas"
for S in $SCHEMAS; do
  gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/$S >/dev/null
done

# Ensures a clean build root before building a package a second time.
%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr (-, root, root)
%{_datadir}/locale/*/LC_MESSAGES/*.mo
%{_sysconfdir}/gconf/schemas/*.schemas
%{_libdir}/bonobo/servers/*.server
%{_libexecdir}/*
%{_datadir}/gnome-2.0/ui/*

%changelog
* Mon Nov 03 2003 - hidetoshi.tajima@sun.com
- Initial release
