dnl system checking configure definitions for im-sdk
dnl               Author: MIYASHITA Hisashi<himi@li18nux.org>

dnl output:
dnl       HAVE_SOCKET
dnl       HAVE_GETADDRINFO
dnl       HAVE_GETHOSTBYADDR
dnl       HAVE_UNIX_SOCKET
dnl	  HAVE_SOCKADDR_STORAGE
dnl       SOCKET_LIBS
AC_DEFUN(IM_CHECK_SOCKET,
[
	socket_lib_flag=""
	nsl_lib_flag=""

dnl     candidates: socket, connect, getaddrinfo, accept, setsockopt, listen...
	AC_CHECK_FUNCS(socket, [ HAVE_SOCKET="yes" ])
	AC_CHECK_FUNCS(getaddrinfo, [ HAVE_GETADDRINFO="yes" ])
	AC_CHECK_FUNCS(gethostbyaddr, [ HAVE_GETHOSTBYADDR="yes" ])
	AC_CHECK_HEADERS([sys/un.h sys/socket.h netdb.h])
	AC_CHECK_TYPES([struct sockaddr_un], [AC_DEFINE(HAVE_UNIX_SOCKET, 1, [Define to 1 if your system supports unix socket.])],,
	[#include <sys/types.h>
	#ifdef HAVE_SYS_UN_H
	#include <sys/un.h>
	#endif
	])
	AC_CHECK_TYPES([struct sockaddr_storage], [AC_DEFINE(HAVE_SOCKADDR_STORAGE, 1, [ Define to 1 if your system has struct sockaddr_storage])],,
	[#include <sys/types.h>
	#ifdef HAVE_SYS_SOCKET_H
	#include <sys/socket.h>
	#endif
	])

	if test "X${HAVE_SOCKET}" != "Xyes"; then
		AC_CHECK_LIB(socket, socket,
                             [ socket_lib_flag="-lsocket";
                               HAVE_SOCKET="yes";
	                       AC_DEFINE(HAVE_SOCKET) ])
		AC_CHECK_LIB(socket, getaddrinfo,
                             [ socket_lib_flag="-lsocket";
                               HAVE_GETADDRINFO="yes";
	                       AC_DEFINE(HAVE_GETADDRINFO) ])
		AC_CHECK_LIB(socket, gethostbyaddr,
                             [ socket_lib_flag="-lsocket";
                               HAVE_GETHOSTBYADDR="yes";
	                       AC_DEFINE(HAVE_GETHOSTBYADDR) ])
	fi
	if test "X${HAVE_GETADDRINFO}" != "Xyes"; then
		AC_CHECK_LIB(nsl, getaddrinfo,
                             [ nsl_lib_flag="-lnsl";
                               HAVE_GETADDRINFO="yes";
	                       AC_DEFINE(HAVE_GETADDRINFO) ])
	fi
	if test "X${HAVE_GETHOSTBYADDR}" != "Xyes"; then
		AC_CHECK_LIB(nsl, gethostbyaddr,
                             [ nsl_lib_flag="-lnsl";
                               HAVE_GETHOSTBYADDR="yes";
	                       AC_DEFINE(HAVE_GETHOSTBYADDR) ])
	fi
	SOCKET_LIBS="${socket_lib_flag} ${nsl_lib_flag}"
	AC_SUBST(SOCKET_LIBS)

        AC_MSG_CHECKING([whether this system supports MSG_NOSIGNAL])
        AC_TRY_COMPILE([
        #ifdef HAVE_SYS_TYPES_H
        #include <sys/types.h>
        #endif
        #ifdef HAVE_SYS_SOCKET_H
        #include <sys/socket.h>
        #endif
        ],[int test = MSG_NOSIGNAL;],
        [ AC_MSG_RESULT([yes])  AC_DEFINE(HAVE_MSG_NOSIGNAL, 1, [ Define to 1 if your system supports MSG_NOSIGNAL ]) ],
        [ AC_MSG_RESULT([no]) ])

        AC_MSG_CHECKING([whether this system supports SO_NOSIGPIPE])
        AC_TRY_COMPILE([
        #ifdef HAVE_SYS_TYPES_H
        #include <sys/types.h>
        #endif
        #ifdef HAVE_SYS_SOCKET_H
        #include <sys/socket.h>
        #endif
        ],[int test = SO_NOSIGPIPE;],
        [ AC_MSG_RESULT([yes]) AC_DEFINE(HAVE_SO_NOSIGPIPE, 1, [ Define to 1 if your system supports SO_NOSIGPIPE]) ],
        [ AC_MSG_RESULT([no])])

        AC_MSG_CHECKING([whether msg_accrights field in struct msghdr])
        AC_TRY_COMPILE([
        #ifdef HAVE_SYS_TYPES_H
        #include <sys/types.h>
        #endif
        #ifdef HAVE_SYS_SOCKET_H
        #include <sys/socket.h>
        #endif
        ], [
             struct msghdr m;
             m.msg_accrights = 0;
             return 0;
        ],
        [ AC_MSG_RESULT([yes]) AC_DEFINE(HAVE_ACCRIGHTS_IN_MSGHDR, 1, [ Define to 1 if struct msghdr has msg_accrights field]) ],
        [ AC_MSG_RESULT([no]) ])

        AC_MSG_CHECKING([whether msg_control field in struct msghdr])
        AC_TRY_COMPILE([
        #ifdef HAVE_SYS_TYPES_H
        #include <sys/types.h>
        #endif
        #ifdef HAVE_SYS_SOCKET_H
        #include <sys/socket.h>
        #endif
        ], [
             struct msghdr m;
             m.msg_control = 0;
             return 0;
        ],
        [ AC_MSG_RESULT([yes]) AC_DEFINE(HAVE_CONTROL_IN_MSGHDR, 1, [ Define to 1 if struct msghdr has msg_control field]) ],
        [ AC_MSG_RESULT([no]) ] )
])
