#ifndef IAC_SERVLINK_H_
#define IAC_SERVLINK_H_

#include "types.h"

void iac_servlink_parse(iac_server_conn_t *);
int iac_servlink_connect(iac_client_conn_t *, iac_link_line_t *ll);
void iac_servlink_retry(const char *servername);
void iac_server_send(iac_server_conn_t *dst, const char *fmt, ...);
void iac_server_send_simple(iac_server_conn_t *dst, char *msg);
void iac_server_bcast(const char *fmt, ...);
void iac_server_forward_simple(iac_server_conn_t *src);
void iac_server_forward(iac_server_conn_t *src, const char *fmt, ...);
void iac_servlink_autoconnect(void);
void iac_servlink_check_pong(const char *unused);
void iac_servlink_start_sync(void);
void iac_servlink_slowretry(const char *name);

#endif
