#ifndef __IAC_CONFIG_H_
#define __IAC_CONFIG_H_

#include <limits.h>

#include "defs.h"

#define IAC_APPNAME "iacd"
#define IAC_VERSION "0.0.26"


/* #define IAC_STRICT_RFC 1 */

/*
 * RLIMIT_OFILE value, defines the max number of open files
 * in the same process. if you increase the size the process needs
 * to be run as root
 */
#define IAC_MAX_SOCK_CONNECTS 1024

/*
 * number of lookups that can be done simultaneously.
 * each one costs you a socket. 
 */
#define IAC_MAX_DNS_RESOLVERS 8

/*
 * Limits against DoS
 *
 * max clones (i.e. connection with the same source ip address)
 */
#define IAC_MAX_CLONES 2000                /* Max Clones                     */
#define IAC_MAX_CHANNEL_JOINS 256          /* Max Channels you may member of */
#define IAC_MAX_CHANNELS 4096              /* Max global channels            */
#define IAC_MAX_SERVER_CONNECTIONS 256
#define IAC_PARSELEN 2048
#define IAC_MAX_MODE_CHANGES 128

/*
 * max connections in waiting state. waiting state means the state after
 * you've successfully connected but didnt send the NICK and USER command
 * to register yourself on the network.
 */
#define IAC_MAX_WAITING 1024


#define IAC_MAX_LASTLOG 25

#define IAC_CONF_HASHSIZE 100

/*
 * IRC Operator stuff
 */
#define IAC_PROTECT_CONNECT 1
#define IAC_PROTECT_SQUIT 1
#define IAC_PROTECT_SYNC 1
#define IAC_PROTECT_WALLOPS 1
#define IAC_PROTECT_DUMP 1
#define IAC_PROTECT_STATS_M 1
#define IAC_PROTECT_STATS_O 1
#define IAC_PROTECT_LINK 1
#define IAC_PROTECT_REHASH 1
/* #define IAC_PROTECT_STATS_C 1 */
#define IAC_PROTECT_BLOCK 1
/* #define IAC_PROTECT_KILL 1 */
/* #define IAC_OPERATOR_IS_GOD 1 */

#ifdef IAC_OPERATOR_IS_GOD
#define IAC_OPERATOR_MODE 1
#endif

#define IAC_AUTOAWAY 1
#define IAC_AUTOAWAY_DEFAULT 300
#define IAC_AUTOAWAY_CHECK 20


/* #define IAC_CRYPT_SALT "vc"   */         /* Salt 2 character for DES */
#define IAC_CRYPT_SALT "$1$NNm1Gdb0"   /* Salt 8 character for MD5 */
#define HAVE_CRYPT

#define IAC_CMD_USAGE

#define IAC_COUNT_IDLETIME

/*
 * Message Id stuff
 *
 * highest message id possible
 * IAC_MAX_MESSAGE_ID + 1 should be a power of 2
 */
#define IAC_MAX_SERVER_NUMERIC 256
#define IAC_MAX_MESSAGE_ID 4095

#define i32 int
#if INT_MAX != 2147483647
#error Adjust value of i32
#endif

#define IAC_MSGCACHE_SIZE ( (IAC_MAX_MESSAGE_ID + 1) / 32)

#define IAC_MSGCACHE_S1 (IAC_MSGCACHE_SIZE / 4)
#define IAC_MSGCACHE_S2 (IAC_MSGCACHE_SIZE / 2)
#define IAC_MSGCACHE_S3 (IAC_MSGCACHE_SIZE / 4*3)


/*
 * SYNC stuff
 */
#define IAC_SYNC_WAIT_BEFORE_SEND 2
#define IAC_SYNC_WAIT_BEFORE_CHECK 30


/*
 * server link stuff
 */
#define IAC_SERVERPASSWORDLEN 128
#define IAC_SERVERFLAGSLEN 32

#define IAC_SERVLINK_RETRY_TIME 20

/*
 * irc limitiations
 *
 * Values taken from RFC 2812 (IRC-CLIENT)
 */
#define IAC_MSGLEN 512

#ifdef HAVE_IPV6
#define IAC_HOSTLEN INET6_ADDRSTRLEN
#else
#define IAC_HOSTLEN 63
#endif

#define IAC_NICKLEN 15
#define IAC_USERLEN 15
#define IAC_HOSTMASKLEN (IAC_NICKLEN+IAC_USERLEN+IAC_HOSTLEN+3)
#define IAC_IRCNAMELEN 128
#define IAC_QUITMSGLEN 256
#define IAC_AWAYLEN 64
#define IAC_SERVERINFOLEN 64
#define IAC_PINGLEN 64
#define IAC_CHANNAMELEN 26
#define IAC_TOPICLEN 4096
#define IAC_SERV_OPTIONSLEN 100
#define IAC_PASSWORDLEN 52

#define IAC_PING_TIMEOUT 120


#define IAC_TLIST_MAX 10

/*
 * actual message being sent, 2 colons ':' and enough space to store
 * the server numeric and message id both max 10 in length
 */
#define IAC_SERVERMSGLEN (IAC_MSGLEN + 48)


/*
 * must be set to the biggest value that can act as a target
 * like a nickname or a channelname
 */
#define IAC_TARGETLEN IAC_CHANNAMELEN


/*
 * :<prefix> PRIVMSG <target> :<text>\r\n
 *
 * length of the text in a message
 *
 * 15 = strlen("PRIVMSG") + 3 spaces + 2x':' + "\r\n" + \0
 */
#define IAC_TEXTLEN (IAC_MSGLEN - IAC_TARGETLEN - IAC_HOSTLEN - 13)


/*
 * Coonfigfile stuff
 */
#define IAC_CONFIG_IDLEN 128
#define IAC_CONFIG_VALUELEN 256

#define IAC_CONF_CLIENT_PORT "client_port"
#define IAC_CONF_SERVER_PORT "server_port"
#define IAC_CONF_SERVER_NUMERIC "server_numeric"
#define IAC_CONF_SERVER_NAME "server_name"
#define IAC_CONF_SERVER_INFO "server_info"
#define IAC_CONF_MOTD "motd"
#define IAC_CONF_LOG_PREFIX "log_prefix"
#define IAC_CONF_LOG_CHANNELS "log_channels"
#define IAC_CONF_PARANOIA "paranoia"
#define IAC_CONF_LASTLOG "lastlog"
#define IAC_CONF_TIMESTAMPS "timestamps"
#define IAC_CONF_INTERFACE "interface"
#define IAC_CONF_CHANNEL_LIST "channel_list"

#undef _POSIX_C_SOURCE
#undef __EXTENSIONS__
#undef _XOPEN_SOURCE
#undef _XOPEN_SOURCE_EXTENDED

#define __EXTENSIONS__ 1
#define _XOPEN_SOURCE 1

#endif
